/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.recipe;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BackpackRecipe
extends ShapedRecipe {
    private static final Map<Item, Integer> BACKPACK_MULTIPLIERS = Map.of(ModBlocks.ANDESITE_BACKPACK.asItem(), 4, ModBlocks.COPPER_BACKPACK.asItem(), 8, ModBlocks.BRASS_BACKPACK.asItem(), 16, ModBlocks.HARDENED_BACKPACK.asItem(), 32);
    private final ShapedRecipe wrapped;

    public BackpackRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
        this.wrapped = recipe;
    }

    public ShapedRecipe getWrapped() {
        return this.wrapped;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = super.assemble(input, registries);
        Optional<ItemStack> oldBackpack = input.items().stream().filter(stack -> !stack.isEmpty() && stack.has(DataComponents.CONTAINER) && stack.has(ModDataComponents.BACKPACK_STACK_MULTIPLIER)).findFirst();
        if (oldBackpack.isEmpty()) {
            return result;
        }
        result.copyFrom((DataComponentHolder)oldBackpack.get(), new DataComponentType[]{DataComponents.CONTAINER});
        Integer newStackMultiplier = BACKPACK_MULTIPLIERS.get(result.getItem());
        if (newStackMultiplier != null) {
            result.set(ModDataComponents.BACKPACK_STACK_MULTIPLIER, (Object)newStackMultiplier);
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<BackpackRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(BackpackRecipe::new, BackpackRecipe::getWrapped);
        public static final StreamCodec<RegistryFriendlyByteBuf, BackpackRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(BackpackRecipe::new, BackpackRecipe::getWrapped);

        public MapCodec<BackpackRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BackpackRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private Serializer() {
        }
    }
}

