/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import com.simibubi.create.AllItems;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.PickBlockHandler;
import net.fxnt.fxntstorage.backpack.upgrade.ToolSwapHandler;
import net.fxnt.fxntstorage.backpack.upgrade.TorchDeployerManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BackpackOnBackUpgradeHandler {
    private final Player player;
    private final BackpackHelper helper;
    private final ItemStack itemStack;

    public BackpackOnBackUpgradeHandler(Player player) {
        this.player = player;
        this.helper = new BackpackHelper();
        this.itemStack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
    }

    public boolean hasUpgrade(String upgradeName) {
        if (this.itemStack.isEmpty() || this.itemStack.getComponentsPatch().isEmpty()) {
            return false;
        }
        List upgrades = Optional.ofNullable((List)this.itemStack.getComponents().get(ModDataComponents.BACKPACK_UPGRADES)).orElse(List.of()).stream().toList();
        return upgrades.contains(upgradeName);
    }

    private IBackpackContainer getContainer() {
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof BackpackMenu) {
            BackpackMenu backPackMenu = (BackpackMenu)abstractContainerMenu;
            if (backPackMenu.backpackType == 1) {
                return backPackMenu.container;
            }
        }
        return new BackpackContainer(this.itemStack, this.player);
    }

    public void applyMagnetUpgrade() {
        if (this.itemStack.isEmpty() || this.player.level().isClientSide || !this.hasUpgrade("backpack_magnet_upgrade")) {
            return;
        }
        AABB boundingBox = new AABB(this.player.blockPosition()).inflate((double)((Integer)ConfigManager.CommonConfig.BACKPACK_MAGNET_RANGE.get()).intValue());
        List nearbyItems = this.player.level().getEntitiesOfClass(ItemEntity.class, boundingBox);
        if (!nearbyItems.isEmpty()) {
            for (ItemEntity itemEntity : nearbyItems) {
                CompoundTag processing;
                CompoundTag createData;
                CompoundTag nbt;
                CompoundTag pd;
                if (itemEntity.getItem().getItem() instanceof BackpackItem || (pd = this.player.getPersistentData().getCompound("fxntstorageSettings")).contains("IgnoreFanProcessing") && pd.getBoolean("IgnoreFanProcessing") && (nbt = itemEntity.getPersistentData()).contains("CreateData") && (createData = nbt.getCompound("CreateData")).contains("Processing") && (processing = createData.getCompound("Processing")).contains("Time") && processing.getInt("Time") > 0) continue;
                this.helper.itemEntityToBackpack(this.getContainer(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE);
                this.player.take((Entity)itemEntity, itemEntity.getItem().getCount());
            }
        }
    }

    public boolean applyItemPickupUpgrade(ItemEntity itemEntity, UUID target, int pickupDelay) {
        if (this.itemStack.isEmpty() || this.player.level().isClientSide || !this.hasUpgrade("backpack_itempickup_upgrade") || this.hasUpgrade("backpack_magnet_upgrade")) {
            return false;
        }
        ItemStack itemStack = itemEntity.getItem();
        Item item = itemStack.getItem();
        int i = itemStack.getCount();
        if (pickupDelay == 0 && (target == null || target.equals(this.player.getUUID())) && this.helper.itemEntityToBackpack(this.getContainer(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE)) {
            this.player.take((Entity)itemEntity, i);
            if (itemStack.isEmpty()) {
                itemEntity.discard();
                itemStack.setCount(i);
            }
            this.player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
            this.player.onItemPickup(itemEntity);
            return true;
        }
        return false;
    }

    public void applyPickBlockUpgrade(ItemStack pickedStack) {
        if (this.itemStack.isEmpty() || this.player.level().isClientSide || !this.hasUpgrade("backpack_pickblock_upgrade")) {
            return;
        }
        PickBlockHandler.pickBlockHandler(this.player, this.getContainer(), pickedStack);
    }

    public void applyFeederUpgrade() {
        if (this.itemStack.isEmpty() || this.player.level().isClientSide || !this.hasUpgrade("backpack_feeder_upgrade")) {
            return;
        }
        boolean doFeed = this.shouldFeedPlayer();
        if (doFeed) {
            IBackpackContainer container = this.getContainer();
            ItemStackHandler itemHandler = container.getItemHandler();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack food = itemHandler.getStackInSlot(i);
                if (!this.isEdible(food, (LivingEntity)this.player) || this.hasNegativeEffects(food)) continue;
                String foodName = food.getItem().getName(food).getString();
                ItemStack mainHandItem = this.player.getMainHandItem();
                this.player.getInventory().items.set(this.player.getInventory().selected, (Object)food);
                ItemStack singleItem = food.copyWithCount(1);
                if (singleItem.use(this.player.level(), this.player, InteractionHand.MAIN_HAND).getResult() == InteractionResult.CONSUME) {
                    this.player.getInventory().items.set(this.player.getInventory().selected, (Object)mainHandItem);
                    food.shrink(1);
                    itemHandler.setStackInSlot(i, food);
                    ItemStack remainder = EventHooks.onItemUseFinish((LivingEntity)this.player, (ItemStack)singleItem.copy(), (int)0, (ItemStack)singleItem.getItem().finishUsingItem(singleItem, this.player.level(), (LivingEntity)this.player));
                    if (!remainder.isEmpty()) {
                        boolean itemPlaced = false;
                        int firstEmptyStack = -1;
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            ItemStack stack = itemHandler.getStackInSlot(j);
                            if (stack.isEmpty() && firstEmptyStack < 0) {
                                firstEmptyStack = j;
                            }
                            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)remainder) || stack.getCount() >= container.getStackMultiplier() * remainder.getMaxStackSize()) continue;
                            ItemStack insertResult = itemHandler.insertItem(j, remainder, false);
                            if (!insertResult.isEmpty()) {
                                this.player.drop(remainder, true);
                            }
                            itemPlaced = true;
                            break;
                        }
                        if (!itemPlaced && firstEmptyStack > -1) {
                            itemHandler.insertItem(firstEmptyStack, remainder, false);
                        }
                    }
                    container.setDataChanged();
                    if (this.player.getPersistentData().getCompound("fxntstorageSettings").getBoolean("DisplayFeederMessage")) {
                        String foodNameFormatted = (Util.isVowel(foodName.charAt(0)) ? "an" : "a") + " \u00a7a" + foodName + "\u00a7r";
                        this.player.displayClientMessage((Component)Component.translatable((String)"item.fxntstorage.backpack_feeder_upgrade.message", (Object[])new Object[]{foodNameFormatted}), true);
                    }
                } else {
                    this.player.getInventory().items.set(this.player.getInventory().selected, (Object)mainHandItem);
                }
                return;
            }
        }
    }

    private boolean isEdible(@NotNull ItemStack stack, LivingEntity player) {
        if (!stack.has(DataComponents.FOOD)) {
            return false;
        }
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, player);
        return foodProperties != null && foodProperties.nutrition() > 0;
    }

    private boolean hasNegativeEffects(@NotNull ItemStack food) {
        Iterator iterator;
        FoodProperties foodProperties = food.getFoodProperties((LivingEntity)this.player);
        if (foodProperties == null) {
            return false;
        }
        if (food.is(Items.CHORUS_FRUIT) && !this.player.getPersistentData().getCompound("fxntstorageSettings").getBoolean("AllowChorusFruit")) {
            return true;
        }
        if (food.is(Items.OMINOUS_BOTTLE)) {
            return true;
        }
        SuspiciousStewEffects stewEffects = (SuspiciousStewEffects)food.get(DataComponents.SUSPICIOUS_STEW_EFFECTS);
        if (stewEffects != null && (iterator = stewEffects.effects().iterator()).hasNext()) {
            SuspiciousStewEffects.Entry entry = (SuspiciousStewEffects.Entry)iterator.next();
            return ((MobEffect)entry.effect().value()).getCategory().equals((Object)MobEffectCategory.HARMFUL);
        }
        for (FoodProperties.PossibleEffect effect : foodProperties.effects()) {
            MobEffectInstance instance = (MobEffectInstance)effect.effectSupplier().get();
            if (!((MobEffect)instance.getEffect().value()).getCategory().equals((Object)MobEffectCategory.HARMFUL)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldFeedPlayer() {
        CompoundTag fxntSettings;
        double healthThreshold;
        float maxHealth;
        if (this.player.isCreative() || this.player.isSpectator()) {
            return false;
        }
        FoodData foodData = this.player.getFoodData();
        int hunger = foodData.getFoodLevel();
        float health = this.player.getHealth();
        if ((double)health < (double)(maxHealth = this.player.getMaxHealth()) * (healthThreshold = (double)(fxntSettings = this.player.getPersistentData().getCompound("fxntstorageSettings")).getInt("FeederHealthThreshold") / 100.0) && hunger < 20) {
            return true;
        }
        return (double)hunger < fxntSettings.getDouble("FeederHungerLevel");
    }

    public void applyRefillUpgrade() {
        if (this.itemStack.isEmpty() || this.player.level().isClientSide || !this.hasUpgrade("backpack_refill_upgrade")) {
            return;
        }
        this.refillHand(this.player.getMainHandItem(), false);
        this.refillHand(this.player.getOffhandItem(), true);
    }

    private void refillHand(@NotNull ItemStack handItem, boolean isOffHand) {
        int ignorePlayerSlot;
        if (handItem.isEmpty() || handItem.getCount() >= handItem.getMaxStackSize()) {
            return;
        }
        if (!(handItem.getItem() instanceof BlockItem)) {
            return;
        }
        if (this.isBlacklisted(handItem)) {
            return;
        }
        int requiredItems = handItem.getMaxStackSize() - handItem.getCount();
        int remaining = this.refillFromPlayerInventory(handItem, requiredItems, ignorePlayerSlot = isOffHand ? 40 : this.player.getInventory().selected);
        if (remaining > 0) {
            this.refillFromBackpack(handItem, remaining);
        }
    }

    private boolean isBlacklisted(ItemStack stack) {
        if (stack.is(ModTags.Items.REFILL_BLACKLIST)) {
            return true;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String fullId = itemId.toString();
        for (String pattern : (List)ConfigManager.CommonConfig.REFILL_BLACKLIST.get()) {
            if (pattern.endsWith(":*")) {
                String namespace = pattern.substring(0, pattern.length() - 2);
                if (!itemId.getNamespace().equals(namespace)) continue;
                return true;
            }
            if (!fullId.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    private int refillFromPlayerInventory(ItemStack handItem, int requiredItems, int ignoreSlot) {
        Inventory inventory = this.player.getInventory();
        int remaining = requiredItems;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack inventoryItem;
            if (i == ignoreSlot || (inventoryItem = inventory.getItem(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)handItem, (ItemStack)inventoryItem)) continue;
            int amountToTransfer = Math.min(remaining, inventoryItem.getCount());
            inventoryItem.shrink(amountToTransfer);
            handItem.grow(amountToTransfer);
            remaining -= amountToTransfer;
        }
        if (requiredItems != remaining) {
            AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
            if (abstractContainerMenu instanceof BackpackMenu) {
                BackpackMenu menu = (BackpackMenu)abstractContainerMenu;
                menu.container.setDataChanged();
            } else {
                this.player.containerMenu.slotsChanged((Container)inventory);
            }
        }
        return remaining;
    }

    private void refillFromBackpack(ItemStack handItem, int requiredItems) {
        IBackpackContainer container = this.getContainer();
        ItemStackHandler itemHandler = container.getItemHandler();
        if (itemHandler == null) {
            return;
        }
        int remaining = requiredItems;
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            int amountToTransfer;
            ItemStack extracted;
            ItemStack containerItem = itemHandler.getStackInSlot(i);
            if (containerItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)handItem, (ItemStack)containerItem) || (extracted = itemHandler.extractItem(i, amountToTransfer = Math.min(remaining, containerItem.getCount()), false)).isEmpty()) continue;
            handItem.grow(extracted.getCount());
            remaining -= extracted.getCount();
        }
        if (requiredItems != remaining) {
            container.setDataChanged();
        }
    }

    public boolean applyFallDamageUpgrade() {
        return !this.itemStack.isEmpty() && !this.player.level().isClientSide && this.hasUpgrade("backpack_falldamage_upgrade");
    }

    public void fromAttackBlockEvent(Player player, Level level, InteractionHand hand, BlockPos pos) {
        if (this.itemStack.isEmpty() || hand != InteractionHand.OFF_HAND && player.isSpectator() || level.isClientSide || !player.isAlive() || player.isSleeping() || player.isDeadOrDying() || !this.hasUpgrade("backpack_toolswap_upgrade") || player.getMainHandItem().is((Holder)AllItems.WRENCH)) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(pos, null);
    }

    public void fromAttackEntityEvent(Player player, Level level, InteractionHand hand, LivingEntity entity) {
        if (this.itemStack.isEmpty() || hand != InteractionHand.OFF_HAND && player.isSpectator() || level.isClientSide || !player.isAlive() || player.isSleeping() || player.isDeadOrDying() || !this.hasUpgrade("backpack_toolswap_upgrade") || player.getMainHandItem().is((Holder)AllItems.WRENCH)) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(null, entity);
    }

    public void applyOreMiningUpgrade(Level level, BlockPos origin, Player player, boolean mineAllBlocks, int maxBlocks) {
        BlockState targetState = level.getBlockState(origin);
        List<BlockPos> vein = this.findVein(level, origin, targetState, mineAllBlocks, maxBlocks);
        ArrayList drops = new ArrayList();
        ItemStack tool = player.getMainHandItem();
        int blocksMined = 0;
        for (BlockPos blockPos : vein) {
            if (tool.isEmpty()) break;
            BlockState state = level.getBlockState(blockPos);
            if (level.isEmptyBlock(blockPos)) continue;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
            List blockDrops = state.getDrops(lootParams);
            drops.addAll(blockDrops);
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
            state.onDestroyedByPlayer(level, blockPos, player, true, level.getFluidState(blockPos));
            if (state.getDestroySpeed((BlockGetter)level, blockPos) >= 0.0f) {
                tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                if (!player.getAbilities().instabuild) {
                    player.causeFoodExhaustion(0.2f);
                }
            }
            ++blocksMined;
        }
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (stack.isEmpty()) continue;
            boolean merged = false;
            for (ItemStack existing : condensed) {
                int transferable;
                if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack) || !existing.isStackable() || (transferable = Math.min(stack.getCount(), existing.getMaxStackSize() - existing.getCount())) <= 0) continue;
                existing.grow(transferable);
                stack.shrink(transferable);
                if (!stack.isEmpty()) continue;
                merged = true;
                break;
            }
            if (merged || stack.isEmpty()) continue;
            condensed.add(stack.copy());
        }
        for (ItemStack drop : condensed) {
            Block.popResource((Level)level, (BlockPos)origin, (ItemStack)drop);
        }
        if (!FMLEnvironment.production) {
            MutableComponent mutableComponent = Component.literal((String)("Successfully mined \u00a7a" + blocksMined + "\u00a7r out of \u00a7a" + vein.size() + "\u00a7r"));
            player.displayClientMessage((Component)mutableComponent, false);
        }
    }

    public List<BlockPos> findVein(Level level, BlockPos start, BlockState targetState, boolean mineAllBlocks, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        toVisit.add(start);
        while (!toVisit.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (!visited.add(current)) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockState neighborState;
                        BlockPos neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = current.offset(dx, dy, dz)) || !(neighborState = level.getBlockState(neighbor)).getBlock().equals(targetState.getBlock()) || !mineAllBlocks && !neighborState.is(ModTags.Blocks.ORE_MINING_BLOCK)) continue;
                        toVisit.add(neighbor);
                    }
                }
            }
        }
        return visited.stream().sorted(Comparator.comparingDouble(blockPos -> blockPos.distSqr((Vec3i)this.player.blockPosition()))).toList();
    }

    public void applyTorchDeployerUpgrade(Player player) {
        int blockLightLevel;
        ConfigManager.ClientConfig.TorchDeployerLightSource lightSource;
        BlockPos playerPos = player.blockPosition();
        BlockPos belowPos = playerPos.below();
        Level level = player.level();
        int lightLevel = player.getPersistentData().getCompound("fxntstorageSettings").getInt("TorchDeployerLightLevel");
        int cooldown = player.getPersistentData().getCompound("fxntstorageSettings").getInt("TorchDeployerCooldown");
        String sourceValue = player.getPersistentData().getCompound("fxntstorageSettings").getString("TorchDeployerLightSource");
        try {
            lightSource = ConfigManager.ClientConfig.TorchDeployerLightSource.valueOf(sourceValue.isEmpty() ? "BLOCK_LIGHT" : sourceValue);
        }
        catch (IllegalArgumentException e) {
            lightSource = ConfigManager.ClientConfig.TorchDeployerLightSource.BLOCK_LIGHT;
        }
        int n = blockLightLevel = lightSource == ConfigManager.ClientConfig.TorchDeployerLightSource.SKY_LIGHT ? level.getBrightness(LightLayer.BLOCK, playerPos) : level.getMaxLocalRawBrightness(playerPos);
        if (blockLightLevel <= lightLevel && level.getBlockState(belowPos).isSolid() && level.getBlockState(playerPos).isAir()) {
            if (!TorchDeployerManager.canPlaceTorch(player, cooldown)) {
                return;
            }
            IBackpackContainer container = this.getContainer();
            ItemStackHandler itemHandler = container.getItemHandler();
            for (int slot = 0; slot < Util.ITEM_SLOT_END_RANGE; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.is(Items.TORCH)) continue;
                stack.shrink(1);
                itemHandler.setStackInSlot(slot, stack);
                level.setBlock(playerPos, Blocks.TORCH.defaultBlockState(), 3);
                level.playSound(null, playerPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS);
                container.setDataChanged();
                if (FMLEnvironment.production) break;
                player.displayClientMessage((Component)Component.literal((String)("Placed \u00a7a1\u00a7r torch with \u00a7a" + stack.getCount() + "\u00a7r left in the stack")), false);
                break;
            }
        }
    }
}

