/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class JetpackManager {
    private static final Map<UUID, JetpackHandler> SERVER = new HashMap<UUID, JetpackHandler>();
    private static final Map<UUID, JetpackHandler> CLIENT = new HashMap<UUID, JetpackHandler>();

    public static JetpackHandler getJetpackHandler(@NotNull Player player) {
        return player.level().isClientSide ? CLIENT.computeIfAbsent(player.getUUID(), uuid -> new JetpackHandler(player)) : SERVER.computeIfAbsent(player.getUUID(), uuid -> new JetpackHandler(player));
    }

    public static void addPlayer(@NotNull Player player) {
        JetpackManager.removePlayer(player);
        JetpackHandler handler = JetpackManager.getJetpackHandler(player);
        handler.resetState();
        CompoundTag tag = player.getPersistentData().getCompound("fxntstorageSettings");
        tag.remove("JetpackFlying");
        tag.remove("JetpackHover");
        tag.remove("Jetpackforward");
        tag.remove("Jetpackleft");
        if (!player.level().isClientSide) {
            double fuel = handler.calculateJetPackFuel(player);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new JetpackFuelSyncPacket((float)fuel, System.currentTimeMillis()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void removePlayer(@NotNull Player player) {
        if (player.level().isClientSide) {
            CLIENT.remove(player.getUUID());
        } else {
            SERVER.remove(player.getUUID());
        }
    }
}

