/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PickBlockHandler {
    public static void pickBlockHandler(@NotNull Player player, IBackpackContainer container, @NotNull ItemStack pickedItem) {
        Inventory inventory = player.getInventory();
        int matchingBackpackSlot = new BackpackHelper().getItemSlotFromContainer(container, pickedItem.getItem());
        if (matchingBackpackSlot != -1) {
            ItemStack backpackStack = container.getItemHandler().getStackInSlot(matchingBackpackSlot);
            int hotbarSlot = player.getInventory().selected;
            if (!inventory.contains(pickedItem)) {
                if (!inventory.getItem(hotbarSlot).isEmpty()) {
                    ItemStack hotbarStack = inventory.getItem(hotbarSlot);
                    int hotbarStackSize = hotbarStack.getCount();
                    int freeSlot = inventory.getFreeSlot();
                    if (freeSlot != -1) {
                        ItemStack hotbarStackCopy = hotbarStack.copyWithCount(hotbarStack.getCount());
                        player.getInventory().setItem(freeSlot, hotbarStackCopy);
                        int amountToMove = Math.min(backpackStack.getCount(), backpackStack.getItem().getMaxStackSize(backpackStack));
                        ItemStack backPackStackCopy = backpackStack.copyWithCount(amountToMove);
                        player.getInventory().setItem(hotbarSlot, backPackStackCopy);
                        backpackStack.shrink(amountToMove);
                        container.setDataChanged();
                        inventory.selected = hotbarSlot;
                    } else {
                        for (int i = 0; i < inventory.getContainerSize(); ++i) {
                            if (i == hotbarSlot) continue;
                            ItemStack thisStack = inventory.getItem(i);
                            int thisStackSize = thisStack.getCount();
                            int maxStackSize = thisStack.getMaxStackSize();
                            int freeSpace = maxStackSize - thisStackSize;
                            if (!ItemStack.isSameItemSameComponents((ItemStack)hotbarStack, (ItemStack)thisStack) || freeSpace < hotbarStackSize) continue;
                            ItemStack newInventoryStack = thisStack.copyWithCount(thisStackSize + hotbarStackSize);
                            player.getInventory().setItem(i, newInventoryStack);
                            int amountToMove = Math.min(backpackStack.getCount(), backpackStack.getItem().getMaxStackSize(backpackStack));
                            ItemStack backPackStackCopy = backpackStack.copyWithCount(amountToMove);
                            player.getInventory().setItem(hotbarSlot, backPackStackCopy);
                            backpackStack.shrink(amountToMove);
                            container.setDataChanged();
                            inventory.selected = hotbarSlot;
                            break;
                        }
                    }
                } else {
                    int amountToMove = Math.min(backpackStack.getCount(), backpackStack.getItem().getMaxStackSize(backpackStack));
                    ItemStack backPackStackCopy = backpackStack.copyWithCount(amountToMove);
                    player.getInventory().setItem(hotbarSlot, backPackStackCopy);
                    backpackStack.shrink(amountToMove);
                    container.setDataChanged();
                    inventory.selected = hotbarSlot;
                }
            } else {
                ItemStack hotbarStack = inventory.getItem(hotbarSlot);
                int hotbarStackSize = hotbarStack.getCount();
                int maxHotBarStackSize = hotbarStack.getMaxStackSize();
                if (ItemStack.isSameItem((ItemStack)hotbarStack, (ItemStack)pickedItem) && maxHotBarStackSize > hotbarStackSize) {
                    ItemStack newInventoryStack;
                    int amountToMove;
                    int freeHotBarStackSpace = maxHotBarStackSize - hotbarStackSize;
                    int backPackStackSize = backpackStack.getCount();
                    if (backPackStackSize > freeHotBarStackSpace) {
                        amountToMove = hotbarStack.getMaxStackSize() - hotbarStackSize;
                        newInventoryStack = pickedItem.copyWithCount(hotbarStack.getMaxStackSize());
                    } else {
                        amountToMove = Math.min(backpackStack.getCount(), backpackStack.getItem().getMaxStackSize(backpackStack));
                        newInventoryStack = backpackStack.copyWithCount(amountToMove - hotbarStackSize);
                    }
                    player.getInventory().setItem(hotbarSlot, newInventoryStack);
                    backpackStack.shrink(amountToMove);
                    container.setDataChanged();
                    inventory.selected = hotbarSlot;
                }
            }
        }
    }
}

