/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.util;

import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackItemMenu;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackHandler {
    public static void openBackpackFromInventory(@NotNull ServerPlayer player, final byte backpackType) {
        if (player.level().isClientSide) {
            return;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        if (backpackType == 1) {
            itemStack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        } else if (backpackType == 2) {
            itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (itemStack.isEmpty()) {
            return;
        }
        final ItemStack backpack = itemStack;
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return backpack.getHoverName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new BackpackItemMenu(containerId, player.getInventory(), new BackpackContainer(backpack, player), backpackType);
            }
        }, buf -> {
            buf.writeNbt(backpack.save((HolderLookup.Provider)player.level().registryAccess(), (Tag)new CompoundTag()));
            buf.writeByte(backpackType);
        });
    }
}

