/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.util;

import java.util.Optional;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BackpackHelper {
    public static boolean isBackpackCuriosSlotVisible(Player player) {
        if (player == null) {
            return false;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).map(slotResult -> slotResult.slotContext().visible()).orElse(false);
    }

    public static boolean isWearingBackpack(Player player, boolean checkVisibility) {
        ItemStack itemStack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        if (FXNTStorage.curiosLoaded && checkVisibility && !(player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof BackpackItem)) {
            return BackpackHelper.isBackpackCuriosSlotVisible(player);
        }
        return !itemStack.isEmpty();
    }

    public static boolean isWearingBackpack(Player player) {
        return BackpackHelper.isWearingBackpack(player, false);
    }

    public static ItemStack getEquippedBackpackStack(LivingEntity player) {
        Optional stacksHandler;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        if (!FXNTStorage.curiosLoaded) {
            return BackpackHelper.checkChestSlot(player);
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curios.isPresent() && (stacksHandler = ((ICuriosItemHandler)curios.get()).getStacksHandler("back")).isPresent()) {
            IDynamicStackHandler stacks = ((ICurioStacksHandler)stacksHandler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                if (!(stack.getItem() instanceof BackpackItem)) continue;
                return stack;
            }
        }
        return BackpackHelper.checkChestSlot(player);
    }

    private static ItemStack checkChestSlot(@NotNull LivingEntity player) {
        ItemStack chestSlotItem = player.getItemBySlot(EquipmentSlot.CHEST);
        return chestSlotItem.getItem() instanceof BackpackItem ? chestSlotItem : ItemStack.EMPTY;
    }

    public static boolean equipBackpack(Player player, ItemStack backpack) {
        ICuriosItemHandler curiosInv;
        Optional stacksHandler;
        if (player == null || backpack.isEmpty()) {
            return false;
        }
        if (!FXNTStorage.curiosLoaded) {
            return BackpackHelper.equipInChestSlot(player, backpack);
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curios.isPresent() && (stacksHandler = (curiosInv = (ICuriosItemHandler)curios.get()).getStacksHandler("back")).isPresent()) {
            IDynamicStackHandler stacks = ((ICurioStacksHandler)stacksHandler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!stacks.getStackInSlot(i).isEmpty()) continue;
                curiosInv.setEquippedCurio("back", i, backpack);
                return true;
            }
        }
        return BackpackHelper.equipInChestSlot(player, backpack);
    }

    private static boolean equipInChestSlot(@NotNull Player player, ItemStack backpack) {
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chestStack.isEmpty()) {
            player.setItemSlot(EquipmentSlot.CHEST, backpack);
            return true;
        }
        return BackpackHelper.equipInPlayerInventory(player, backpack);
    }

    private static boolean equipInPlayerInventory(@NotNull Player player, ItemStack backpack) {
        int freeInventorySlot = player.getInventory().getFreeSlot();
        if (freeInventorySlot > -1) {
            player.getInventory().setItem(freeInventorySlot, backpack);
            return true;
        }
        return false;
    }

    public int getItemSlotFromContainer(@NotNull IBackpackContainer container, Item itemToFind) {
        for (int i = 0; i < container.getItemHandler().getSlots(); ++i) {
            ItemStack slotItem = container.getItemHandler().getStackInSlot(i);
            if (!slotItem.is(itemToFind)) continue;
            return i;
        }
        return -1;
    }

    public boolean itemEntityToBackpack(@NotNull IBackpackContainer container, @NotNull ItemEntity itemEntity, int startIndex, int endIndex) {
        ItemStack itemStack;
        int i;
        ItemStack newStack = itemEntity.getItem();
        ItemStackHandler itemHandler = container.getItemHandler();
        if (endIndex == -1) {
            endIndex = itemHandler.getSlots();
        }
        boolean success = false;
        if (!newStack.isDamageableItem() && newStack.getComponentsPatch().isEmpty() && !newStack.isBarVisible()) {
            for (i = startIndex; !newStack.isEmpty() && i < endIndex; ++i) {
                itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)itemStack)) continue;
                int totalCount = itemStack.getCount() + newStack.getCount();
                int maxPutSize = Math.max(newStack.getMaxStackSize(), container.getStackMultiplier() * newStack.getMaxStackSize());
                int availableSpace = maxPutSize - itemStack.getCount();
                if (totalCount <= maxPutSize) {
                    newStack.setCount(0);
                    itemStack.setCount(totalCount);
                    success = true;
                    continue;
                }
                if (availableSpace >= newStack.getMaxStackSize()) continue;
                newStack.shrink(availableSpace);
                itemStack.setCount(maxPutSize);
                success = true;
            }
        }
        if (!newStack.isEmpty()) {
            for (i = startIndex; i < endIndex; ++i) {
                itemStack = container.getItemHandler().getStackInSlot(i);
                if (!itemStack.isEmpty()) continue;
                int maxPutSize = Math.max(newStack.getMaxStackSize(), container.getStackMultiplier() * newStack.getMaxStackSize());
                int availableSpace = maxPutSize - itemStack.getCount();
                if (newStack.getCount() > availableSpace) {
                    ItemStack inputStack = newStack.split(container.getStackMultiplier() * newStack.getMaxStackSize());
                    itemHandler.setStackInSlot(i, inputStack);
                } else {
                    ItemStack inputStack = newStack.split(newStack.getCount());
                    itemHandler.setStackInSlot(i, inputStack);
                }
                success = true;
                break;
            }
        }
        container.setDataChanged();
        return success;
    }
}

