/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.cache;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PasserShapeCache {
    private static final Map<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);

    public static void clearCache() {
        shapes.clear();
        PasserShapeCache.initializeShapes();
    }

    private static void initializeShapes() {
        shapes.put(Direction.UP, PasserShapeCache.createShapeForDirection(Direction.UP));
        shapes.put(Direction.DOWN, PasserShapeCache.createShapeForDirection(Direction.DOWN));
        shapes.put(Direction.NORTH, PasserShapeCache.createShapeForDirection(Direction.NORTH));
        shapes.put(Direction.SOUTH, PasserShapeCache.createShapeForDirection(Direction.SOUTH));
        shapes.put(Direction.EAST, PasserShapeCache.createShapeForDirection(Direction.EAST));
        shapes.put(Direction.WEST, PasserShapeCache.createShapeForDirection(Direction.WEST));
    }

    private static VoxelShape createShapeForDirection(Direction direction) {
        VoxelShape finalShape = Shapes.empty();
        List<VoxelShape> parts = Arrays.asList(Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)5.0), Block.box((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0, (double)9.0), Block.box((double)3.0, (double)3.0, (double)9.0, (double)13.0, (double)13.0, (double)15.0), Block.box((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0));
        for (VoxelShape part : parts) {
            VoxelShape rotatedPart = PasserShapeCache.rotate(part, direction);
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)rotatedPart);
        }
        return finalShape.optimize();
    }

    public static VoxelShape getShape(Direction direction) {
        return shapes.get(direction);
    }

    private static VoxelShape rotate(VoxelShape shape, Direction dir) {
        return switch (dir) {
            case Direction.UP -> Shapes.create((double)shape.min(Direction.Axis.X), (double)(1.0 - shape.max(Direction.Axis.Z)), (double)shape.min(Direction.Axis.Y), (double)shape.max(Direction.Axis.X), (double)(1.0 - shape.min(Direction.Axis.Z)), (double)shape.max(Direction.Axis.Y));
            case Direction.DOWN -> Shapes.create((double)shape.min(Direction.Axis.X), (double)shape.min(Direction.Axis.Z), (double)shape.min(Direction.Axis.Y), (double)shape.max(Direction.Axis.X), (double)shape.max(Direction.Axis.Z), (double)shape.max(Direction.Axis.Y));
            case Direction.SOUTH -> Shapes.create((double)(1.0 - shape.max(Direction.Axis.X)), (double)shape.min(Direction.Axis.Y), (double)(1.0 - shape.max(Direction.Axis.Z)), (double)(1.0 - shape.min(Direction.Axis.X)), (double)shape.max(Direction.Axis.Y), (double)(1.0 - shape.min(Direction.Axis.Z)));
            case Direction.WEST -> Shapes.create((double)shape.min(Direction.Axis.Z), (double)shape.min(Direction.Axis.Y), (double)(1.0 - shape.max(Direction.Axis.X)), (double)shape.max(Direction.Axis.Z), (double)shape.max(Direction.Axis.Y), (double)(1.0 - shape.min(Direction.Axis.X)));
            case Direction.EAST -> Shapes.create((double)(1.0 - shape.max(Direction.Axis.Z)), (double)shape.min(Direction.Axis.Y), (double)shape.min(Direction.Axis.X), (double)(1.0 - shape.min(Direction.Axis.Z)), (double)shape.max(Direction.Axis.Y), (double)shape.max(Direction.Axis.X));
            default -> shape;
        };
    }

    static {
        PasserShapeCache.initializeShapes();
    }
}

