/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat;

import java.util.Optional;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosCompat {
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new BackpackCurio((ItemStack)stack), new ItemLike[]{((BackpackBlock)((Object)ModBlocks.BACKPACK.get())).asItem(), ((BackpackBlock)((Object)ModBlocks.ANDESITE_BACKPACK.get())).asItem(), ((BackpackBlock)((Object)ModBlocks.COPPER_BACKPACK.get())).asItem(), ((BackpackBlock)((Object)ModBlocks.BRASS_BACKPACK.get())).asItem(), ((BackpackBlock)((Object)ModBlocks.HARDENED_BACKPACK.get())).asItem()});
    }

    public static void keepBackpack(DropRulesEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (((Boolean)ConfigManager.CommonConfig.CURIOS_KEEP_BACKPACK.get()).booleanValue()) {
                CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInv -> curiosInv.getStacksHandler("back")).ifPresent(stacksHandler -> {
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        if (!(stacksHandler.getStacks().getStackInSlot(i).getItem() instanceof BackpackItem)) continue;
                        int finalI = i;
                        event.addOverride(itemStack -> itemStack == stacksHandler.getStacks().getStackInSlot(finalI), ICurio.DropRule.ALWAYS_KEEP);
                    }
                });
            }
        }
    }

    public static class BackpackCurio
    implements ICurio {
        private final ItemStack stack;

        private BackpackCurio(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        @NotNull
        public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
            return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
        }

        public boolean canEquip(SlotContext slotContext) {
            if (slotContext.entity().getItemBySlot(EquipmentSlot.CHEST).getItem().asItem() instanceof BackpackItem) {
                return false;
            }
            Optional curios = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity());
            if (curios.isPresent()) {
                ICuriosItemHandler curiosInv = (ICuriosItemHandler)curios.get();
                Optional backpackSlot = curiosInv.findFirstCurio(stack -> stack.getItem() instanceof BackpackItem);
                return backpackSlot.isEmpty();
            }
            return false;
        }

        public boolean canSync(SlotContext slotContext) {
            return true;
        }
    }
}

