/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.constructionstick;

import mrbysco.constructionstick.api.IContainerHandler;
import mrbysco.constructionstick.basics.StickUtil;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;

public class HandlerStorageBox
implements IContainerHandler {
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCount() == 1 && (Block.byItem((Item)inventoryStack.getItem()) instanceof StorageBox || Block.byItem((Item)inventoryStack.getItem()) instanceof SimpleStorageBox);
    }

    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        int count = 0;
        for (ItemStack stack : this.getItemList(inventoryStack)) {
            if (!StickUtil.stackEquals((ItemStack)stack, (ItemStack)itemStack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        NonNullList<ItemStack> itemList = this.getItemList(inventoryStack);
        boolean changed = false;
        for (ItemStack stack : itemList) {
            if (!StickUtil.stackEquals((ItemStack)stack, (ItemStack)itemStack)) continue;
            int toTake = Math.min(count, stack.getCount());
            stack.shrink(toTake);
            changed = true;
            if ((count -= toTake) != 0) continue;
            break;
        }
        if (changed) {
            this.setItemList(inventoryStack, itemList);
            player.getInventory().setChanged();
        }
        return count;
    }

    private NonNullList<ItemStack> getItemList(ItemStack itemStack) {
        ItemContainerContents contents = (ItemContainerContents)itemStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        NonNullList itemStacks = NonNullList.withSize((int)contents.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack stack = contents.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            itemStacks.set(i, (Object)stack);
        }
        return itemStacks;
    }

    private void setItemList(ItemStack itemStack, NonNullList<ItemStack> itemStacks) {
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(itemStacks));
    }
}

