/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.handler.StonecuttingRecipeHandler;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiRecipeFiller;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class EMIStonecuttingRecipeHandler
extends StonecuttingRecipeHandler {
    private final Player player;

    public EMIStonecuttingRecipeHandler() {
        this.player = Minecraft.getInstance().player;
    }

    public List<Slot> getInputSources(StonecutterMenu handler) {
        ArrayList<Slot> slots = new ArrayList<Slot>(handler.slots.stream().filter(slot -> slot.mayPickup(this.player)).toList());
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)this.player);
        if (!backpack.isEmpty()) {
            BackpackContainer backpackContainer = new BackpackContainer(backpack, this.player);
            ItemStackHandler itemHandler = backpackContainer.getItemHandler();
            for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                SlotItemHandler fakeSlot = new SlotItemHandler((IItemHandler)itemHandler, i, 0, 0);
                fakeSlot.set(stack);
                slots.add((Slot)fakeSlot);
            }
        }
        return slots;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<StonecutterMenu> context) {
        List stacks = EmiRecipeFiller.getStacks((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (int)context.getAmount());
        if (stacks != null) {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen((Screen)context.getScreen());
            if (!EmiClient.onServer) {
                return EmiRecipeFiller.clientFill((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (List)stacks, (EmiCraftContext.Destination)context.getDestination());
            }
            ArrayList<Integer> recipeList = new ArrayList<Integer>();
            for (int i = 0; i < stacks.size(); ++i) {
                if (((ItemStack)stacks.get(i)).isEmpty()) continue;
                recipeList.add(i + 1);
            }
            ResourceLocation resourceLocation = recipe.getId();
            boolean bl = context.getAmount() > 1;
            PacketDistributor.sendToServer((CustomPacketPayload)new TransferRecipePacket(resourceLocation, recipeList, bl, switch (context.getDestination()) {
                default -> throw new MatchException(null, null);
                case EmiCraftContext.Destination.NONE -> 0;
                case EmiCraftContext.Destination.CURSOR -> 1;
                case EmiCraftContext.Destination.INVENTORY -> 2;
            }), (CustomPacketPayload[])new CustomPacketPayload[0]);
            EmiIngredient emiInput = (EmiIngredient)recipe.getInputs().getFirst();
            Ingredient ingredient = Ingredient.of((ItemStack[])((ItemStack[])emiInput.getEmiStacks().stream().map(emiStack -> emiStack.getItemStack().copy()).toArray(ItemStack[]::new)));
            HashSet allMatching = new HashSet();
            for (ItemStack stack : ingredient.getItems()) {
                SingleRecipeInput inv = new SingleRecipeInput(stack);
                List matches = mc.level.getRecipeManager().getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)inv, (Level)mc.level);
                allMatching.addAll(matches);
            }
            List<StonecutterRecipe> sorted = allMatching.stream().map(RecipeHolder::value).sorted(Comparator.comparing(r -> r.getResultItem((HolderLookup.Provider)mc.level.registryAccess()).getItem().getDescriptionId())).toList();
            for (int i = 0; i < sorted.size(); ++i) {
                if (EmiPort.getId((Recipe)((Recipe)sorted.get(i))) == null || !EmiPort.getId((Recipe)((Recipe)sorted.get(i))).equals((Object)recipe.getId())) continue;
                StonecutterMenu menu = (StonecutterMenu)context.getScreenHandler();
                mc.gameMode.handleInventoryButtonClick(menu.containerId, i);
                if (context.getDestination() == EmiCraftContext.Destination.CURSOR) {
                    mc.gameMode.handleInventoryMouseClick(menu.containerId, 1, 0, ClickType.PICKUP, (Player)mc.player);
                    break;
                }
                if (context.getDestination() != EmiCraftContext.Destination.INVENTORY) break;
                mc.gameMode.handleInventoryMouseClick(menu.containerId, 1, 0, ClickType.QUICK_MOVE, (Player)mc.player);
                break;
            }
            return true;
        }
        return false;
    }
}

