/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.jei;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.fxnt.fxntstorage.backpack.main.BackpackScreen;
import net.fxnt.fxntstorage.compat.jei.JEICraftingTransferHandler;
import net.fxnt.fxntstorage.compat.jei.JEIStonecuttingTransferHandler;
import net.fxnt.fxntstorage.container.StorageBoxScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEICompat
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"jei_compat");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(StorageBoxScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageBoxScreen>(this){

            @NotNull
            public List<Rect2i> getGuiExtraAreas(StorageBoxScreen screen) {
                return screen.getExclusionZones();
            }
        });
        registration.addGuiContainerHandler(BackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackScreen>(this){

            @NotNull
            public List<Rect2i> getGuiExtraAreas(BackpackScreen screen) {
                return screen.getExclusionZones();
            }
        });
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new JEICraftingTransferHandler(transferHelper, stackHelper), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new JEIStonecuttingTransferHandler(transferHelper, stackHelper), RecipeTypes.STONECUTTING);
    }
}

