/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class JEICraftingTransferHandler
implements IRecipeTransferHandler<CraftingMenu, RecipeHolder<CraftingRecipe>> {
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IStackHelper stackHelper;

    public JEICraftingTransferHandler(IRecipeTransferHandlerHelper transferHelper, IStackHelper stackHelper) {
        this.transferHelper = transferHelper;
        this.stackHelper = stackHelper;
    }

    public Class<? extends CraftingMenu> getContainerClass() {
        return CraftingMenu.class;
    }

    public Optional<MenuType<CraftingMenu>> getMenuType() {
        return Optional.of(MenuType.CRAFTING);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CraftingMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Inventory playerInventory = player.getInventory();
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        LinkedHashMap<Object, ItemStack> availableItemStacks = new LinkedHashMap<Object, ItemStack>();
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack stack2 = playerInventory.getItem(i);
            if (stack2.isEmpty()) continue;
            availableItemStacks.put(new Slot((Container)playerInventory, i, 0, 0), stack2);
        }
        if (!backpack.isEmpty()) {
            BackpackContainer backpackContainer = new BackpackContainer(backpack, player);
            ItemStackHandler itemHandler = backpackContainer.getItemHandler();
            for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
                ItemStack stack3 = itemHandler.getStackInSlot(i);
                if (stack3.isEmpty()) continue;
                availableItemStacks.put(new SlotItemHandler((IItemHandler)itemHandler, i, 0, 0), stack3);
            }
        }
        ArrayList<IRecipeSlotView> missingSlots = new ArrayList<IRecipeSlotView>();
        LinkedHashMap remainingStacks = new LinkedHashMap();
        availableItemStacks.forEach((slot, stack) -> remainingStacks.put(slot, stack.copy()));
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews()) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT || slotView.isEmpty()) continue;
            boolean matched = false;
            for (ItemStack displayed : slotView.getItemStacks().toList()) {
                if (displayed.isEmpty()) continue;
                Ingredient ingredient = Ingredient.of((ItemStack[])new ItemStack[]{displayed});
                for (Map.Entry entry : remainingStacks.entrySet()) {
                    ItemStack testStack = (ItemStack)entry.getValue();
                    if (testStack.isEmpty() || !ingredient.test(testStack)) continue;
                    testStack.shrink(1);
                    if (testStack.isEmpty()) {
                        entry.setValue(ItemStack.EMPTY);
                    }
                    matched = true;
                    break;
                }
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            missingSlots.add(slotView);
        }
        if (!missingSlots.isEmpty()) {
            MutableComponent message = Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.transferHelper.createUserErrorForMissingSlots((Component)message, missingSlots);
        }
        if (!doTransfer) {
            return null;
        }
        List craftingSlots = container.slots.subList(1, 10);
        RecipeTransferOperationsResult operations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.stackHelper, availableItemStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), (List)craftingSlots);
        if (!operations.missingItems.isEmpty()) {
            return this.transferHelper.createUserErrorForMissingSlots((Component)Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing"), (Collection)operations.missingItems);
        }
        ArrayList<Integer> recipeList = new ArrayList<Integer>(operations.results.stream().map(op -> op.craftingSlot((AbstractContainerMenu)container).index).toList());
        PacketDistributor.sendToServer((CustomPacketPayload)new TransferRecipePacket(recipe.id(), recipeList, maxTransfer, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return null;
    }
}

