/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.config;

import java.util.List;
import net.fxnt.fxntstorage.network.packet.SyncClientSettingsPacket;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfigManager {
    public static final String FXNTSTORAGE_SETTINGS_TAG = "fxntstorageSettings";

    private static boolean validateBlock(Object obj) {
        String block;
        if (!(obj instanceof String) || (block = (String)obj).isBlank()) {
            return false;
        }
        try {
            ResourceLocation id = ResourceLocation.parse((String)block);
            return BuiltInRegistries.BLOCK.containsKey(id);
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    private static boolean validateBlacklist(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String item = (String)obj;
        if (ConfigManager.validateBlock(obj)) {
            return true;
        }
        if (item.endsWith(":*")) {
            String namespace = item.substring(0, item.length() - 2);
            if (namespace.isEmpty()) {
                return false;
            }
            if (!namespace.matches("^[a-z0-9_.-]+$")) {
                return false;
            }
            return BuiltInRegistries.ITEM.keySet().stream().anyMatch(key -> key.getNamespace().equals(namespace));
        }
        return false;
    }

    public static class ClientConfig {
        public static final ModConfigSpec CLIENT_SPEC;
        public static final ModConfigSpec.Builder CLIENT_BUILDER;
        public static ModConfigSpec.BooleanValue DISPLAY_JETPACK_AIR_OVERLAY;
        public static ModConfigSpec.BooleanValue JETPACK_HOVER_BOBBING;
        public static ModConfigSpec.BooleanValue DISPLAY_FEEDER_MESSAGE;
        public static ModConfigSpec.BooleanValue ALLOW_CHORUS_FRUIT;
        public static ModConfigSpec.BooleanValue MAGNET_IGNORE_FAN_PROCESSING;
        public static ModConfigSpec.BooleanValue TOOLSWAP_PREFER_SILK_TOUCH;
        public static ModConfigSpec.ConfigValue<List<? extends String>> TOOLSWAP_PREFERS_SILK_TOUCH_LIST;
        public static ModConfigSpec.IntValue TORCH_DEPLOYER_COOLDOWN;
        public static ModConfigSpec.IntValue TORCH_DEPLOYER_LIGHT_LEVEL;
        public static ModConfigSpec.EnumValue<TorchDeployerLightSource> TORCH_DEPLOYER_LIGHT_SOURCE;
        public static ModConfigSpec.BooleanValue CHECK_BACKPACK_FOR_PROJECTILES;
        public static ModConfigSpec.BooleanValue CHECK_BACKPACK_FOR_TOOLBOX_ITEMS;
        public static ModConfigSpec.IntValue FEEDER_HUNGER_LEVEL;
        public static ModConfigSpec.IntValue FEEDER_HEALTH_THRESHOLD;
        public static ModConfigSpec.EnumValue<SimpleStorageGoggleOverlay> SIMPLE_STORAGE_GOGGLE_INFO;

        public static void sendSettings(Player player) {
            CompoundTag playerData = player.getPersistentData();
            CompoundTag fxntSettingsTag = Util.getOrCreateSubTag(playerData, ConfigManager.FXNTSTORAGE_SETTINGS_TAG);
            fxntSettingsTag.putBoolean("JetpackHoverBobbing", ((Boolean)JETPACK_HOVER_BOBBING.get()).booleanValue());
            ListTag listTag = new ListTag();
            for (String entry : (List)TOOLSWAP_PREFERS_SILK_TOUCH_LIST.get()) {
                listTag.add((Object)StringTag.valueOf((String)entry));
            }
            CompoundTag settings = new CompoundTag();
            settings.put("PrefersSilkTouchList", (Tag)listTag);
            settings.putBoolean("PreferSilkTouch", ((Boolean)TOOLSWAP_PREFER_SILK_TOUCH.get()).booleanValue());
            settings.putBoolean("IgnoreFanProcessing", ((Boolean)MAGNET_IGNORE_FAN_PROCESSING.get()).booleanValue());
            settings.putBoolean("DisplayFeederMessage", ((Boolean)DISPLAY_FEEDER_MESSAGE.get()).booleanValue());
            settings.putBoolean("AllowChorusFruit", ((Boolean)ALLOW_CHORUS_FRUIT.get()).booleanValue());
            settings.putInt("TorchDeployerCooldown", ((Integer)TORCH_DEPLOYER_COOLDOWN.get()).intValue());
            settings.putInt("TorchDeployerLightLevel", ((Integer)TORCH_DEPLOYER_LIGHT_LEVEL.get()).intValue());
            settings.putString("TorchDeployerLightSource", ((TorchDeployerLightSource)((Object)TORCH_DEPLOYER_LIGHT_SOURCE.get())).name());
            settings.putBoolean("JetpackHoverBobbing", ((Boolean)JETPACK_HOVER_BOBBING.get()).booleanValue());
            settings.putBoolean("CheckBackpackForProjectiles", ((Boolean)CHECK_BACKPACK_FOR_PROJECTILES.get()).booleanValue());
            settings.putBoolean("CheckBackpackForToolboxItems", ((Boolean)CHECK_BACKPACK_FOR_TOOLBOX_ITEMS.get()).booleanValue());
            settings.putInt("FeederHungerLevel", ((Integer)FEEDER_HUNGER_LEVEL.get()).intValue());
            settings.putInt("FeederHealthThreshold", ((Integer)FEEDER_HEALTH_THRESHOLD.get()).intValue());
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncClientSettingsPacket(settings), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        static {
            CLIENT_BUILDER = new ModConfigSpec.Builder();
            CLIENT_BUILDER.comment("Feeder Upgrade").push("feeder_upgrade");
            DISPLAY_FEEDER_MESSAGE = CLIENT_BUILDER.comment("Display a message on screen when the Feeder Upgrade automatically feeds the player.").translation("fxntstorage.configuration.displayFeederMessage").define("displayFeederMessage", true);
            ALLOW_CHORUS_FRUIT = CLIENT_BUILDER.comment("Allow the Feeder Upgrade to use Chorus Fruit when feeding the player.").translation("fxntstorage.configuration.allowChorusFruit").define("allowChorusFruit", false);
            FEEDER_HEALTH_THRESHOLD = CLIENT_BUILDER.comment("Feeder Upgrade activates when health percentage falls below this value, regardless of Hunger Level.").translation("fxntstorage.configuration.feederHealthThreshold").defineInRange("feederHealthThreshold", 80, 1, 100);
            FEEDER_HUNGER_LEVEL = CLIENT_BUILDER.comment("Feeder Upgrade activates when hunger falls below this value. One point = half a drumstick").translation("fxntstorage.configuration.feederHungerLevel").defineInRange("feederHungerLevel", 18, 1, 20);
            CLIENT_BUILDER.pop();
            CLIENT_BUILDER.comment("Flight Upgrade").push("flight_upgrade");
            DISPLAY_JETPACK_AIR_OVERLAY = CLIENT_BUILDER.comment("Display how much air is left in the jetpack on the HUD.").translation("fxntstorage.configuration.displayJetpackAirOverlay").define("displayJetpackAirOverlay", true);
            JETPACK_HOVER_BOBBING = CLIENT_BUILDER.comment("Add a gentle up-and-down motion while hovering with the jetpack.").translation("fxntstorage.configuration.jetpackHoverBobbing").define("jetpackHoverBobbing", true);
            CLIENT_BUILDER.pop();
            CLIENT_BUILDER.comment("Magnet Upgrade").push("magnet_upgrade");
            MAGNET_IGNORE_FAN_PROCESSING = CLIENT_BUILDER.comment("Prevent the Magnet Upgrade from pulling items that are being processed by a Create Encased Fan.").translation("fxntstorage.configuration.ignoreFanProcessing").define("ignoreFanProcessing", true);
            CLIENT_BUILDER.pop();
            CLIENT_BUILDER.comment("Tool Swap Upgrade").push("tool_swap_upgrade");
            TOOLSWAP_PREFER_SILK_TOUCH = CLIENT_BUILDER.comment("Prefer tools with Silk Touch when breaking blocks from the prefers Silk Touch list.").translation("fxntstorage.configuration.preferSilkTouch").define("preferSilkTouch", false);
            TOOLSWAP_PREFERS_SILK_TOUCH_LIST = CLIENT_BUILDER.comment("Blocks in this list will drop the block when broken with a Silk Touch tool.").translation("fxntstorage.configuration.prefersSilkTouchList").defineListAllowEmpty("prefersSilkTouchList", List.of("minecraft:grass_block", "minecraft:mycelium", "minecraft:podzol", "minecraft:clay", "minecraft:gravel", "minecraft:snow", "minecraft:glowstone", "minecraft:stone", "minecraft:sea_lantern", "minecraft:coal_ore", "minecraft:deepslate_coal_ore", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore", "minecraft:gilded_blackstone", "minecraft:iron_ore", "minecraft:deepslate_iron_ore", "minecraft:lapis_ore", "minecraft:deepslate_lapis_ore", "minecraft:gold_ore", "minecraft:deepslate_gold_ore", "minecraft:emerald_ore", "minecraft:deepslate_emerald_ore", "minecraft:diamond_ore", "minecraft:deepslate_diamond_ore", "minecraft:redstone_ore", "minecraft:deepslate_redstone_ore"), () -> "", ConfigManager::validateBlock);
            CLIENT_BUILDER.pop();
            CLIENT_BUILDER.comment("Torch Deployer Upgrade").push("torch_deployer_upgrade");
            TORCH_DEPLOYER_LIGHT_LEVEL = CLIENT_BUILDER.comment("Deploys a torch when light level is at or below this level. 0 = very dark, 15 = daylight").translation("fxntstorage.configuration.torchDeployerLightLevel").defineInRange("torchDeployerLightLevel", 2, 0, 15);
            TORCH_DEPLOYER_COOLDOWN = CLIENT_BUILDER.comment("Delay between each torch placement attempt (in ticks). 20 ticks = 1 second.").translation("fxntstorage.configuration.torchDeployerCooldown").defineInRange("torchDeployerCooldown", 20, 0, Integer.MAX_VALUE);
            TORCH_DEPLOYER_LIGHT_SOURCE = CLIENT_BUILDER.comment("Choose the light source to check when determining block light levels.").translation("fxntstorage.configuration.torchDeployerLightSource").defineEnum("torchDeployerLightSource", (Enum)TorchDeployerLightSource.BLOCK_LIGHT);
            CLIENT_BUILDER.pop();
            CHECK_BACKPACK_FOR_PROJECTILES = CLIENT_BUILDER.comment("Ranged weapons can use arrows and other ammo stored in equipped backpack.").translation("fxntstorage.configuration.checkBackpackForProjectiles").define("checkBackpackForProjectiles", true);
            CHECK_BACKPACK_FOR_TOOLBOX_ITEMS = CLIENT_BUILDER.comment("Toolbox integration, allowing items to be transferred directly from equipped backpack.").translation("fxntstorage.configuration.checkBackpackForToolboxItems").define("checkBackpackForToolboxItems", true);
            SIMPLE_STORAGE_GOGGLE_INFO = CLIENT_BUILDER.comment("Display goggle overlay for items with tag data in Simple Storage Boxes. (e.g. enchanted items, potions, tipped arrows or trimmed armor)").translation("fxntstorage.configuration.simpleStorageGoggleInfo").defineEnum("simpleStorageGoggleInfo", (Enum)SimpleStorageGoggleOverlay.ONLY_TAGGED);
            CLIENT_SPEC = CLIENT_BUILDER.build();
        }

        public static enum TorchDeployerLightSource {
            BLOCK_LIGHT,
            SKY_LIGHT;

        }

        public static enum SimpleStorageGoggleOverlay {
            OFF,
            ONLY_TAGGED,
            ALL_ITEMS;

        }
    }

    public static class CommonConfig {
        public static final ModConfigSpec COMMON_SPEC;
        public static final ModConfigSpec.Builder COMMON_BUILDER;
        public static ModConfigSpec.ConfigValue<Integer> STORAGE_BOX_UPDATE_TIME;
        public static ModConfigSpec.BooleanValue SIMPLE_STORAGE_NETWORK_FILL_EMPTY;
        public static ModConfigSpec.ConfigValue<Integer> SIMPLE_STORAGE_NETWORK_RANGE;
        public static ModConfigSpec.ConfigValue<Integer> SIMPLE_STORAGE_NETWORK_UPDATE_TIME;
        public static ModConfigSpec.BooleanValue CURIOS_KEEP_BACKPACK;
        public static ModConfigSpec.ConfigValue<Integer> BACKPACK_MAGNET_RANGE;
        public static ModConfigSpec.BooleanValue ELYTRA_BOOST_ENABLED;
        public static ModConfigSpec.IntValue ELYTRA_BOOST_MULTIPLIER;
        public static ModConfigSpec.DoubleValue ELYTRA_BOOST_SPEED_MULTIPLIER;
        public static ModConfigSpec.BooleanValue OREMINE_ORES_ONLY;
        public static ModConfigSpec.BooleanValue JETPACK_MINING_PENALTY;
        public static ModConfigSpec.BooleanValue JETPACK_ALLOW_VOID_FLIGHT;
        public static ModConfigSpec.ConfigValue<List<? extends String>> REFILL_BLACKLIST;

        static {
            COMMON_BUILDER = new ModConfigSpec.Builder();
            COMMON_BUILDER.comment("Backpack Upgrades").translation("fxntstorage.configuration.backpack").push("backpack");
            COMMON_BUILDER.comment("Magnet Upgrade").push("magnet_upgrade");
            BACKPACK_MAGNET_RANGE = COMMON_BUILDER.comment("The range (in blocks) around the backpack within which the Magnet Upgrade will pull items.").translation("fxntstorage.configuration.backpackMagnetRange").defineInRange("backpackMagnetRange", 5, 2, 16);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.comment("Ore Mining Upgrade").push("ore_mining_upgrade");
            OREMINE_ORES_ONLY = COMMON_BUILDER.comment("Limits the Ore Mining Upgrade to mine ores only. Disable to allow any block (up to 64).").translation("fxntstorage.configuration.mineOresOnly").define("mineOresOnly", true);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.comment("Flight Upgrade").push("flight_upgrade");
            JETPACK_ALLOW_VOID_FLIGHT = COMMON_BUILDER.comment("Allow the use of the flight upgrade over the void in The End dimension.").translation("fxntstorage.configuration.jetpackAllowVoidFlight").define("jetpackAllowVoidFlight", false);
            ELYTRA_BOOST_ENABLED = COMMON_BUILDER.comment("Enable Jetpack boosting while gliding with an Elytra equipped.").translation("fxntstorage.configuration.elytraBoostEnabled").define("elytraBoostEnabled", true);
            ELYTRA_BOOST_MULTIPLIER = COMMON_BUILDER.comment("Multiplier for Jetpack fuel consumption while Elytra boosting.").translation("fxntstorage.configuration.elytraBoostMultiplier").defineInRange("elytraBoostMultiplier", 4, 1, 10);
            ELYTRA_BOOST_SPEED_MULTIPLIER = COMMON_BUILDER.comment("Multiplier for Jetpack speed while Elytra boosting.").translation("fxntstorage.configuration.elytraBoostSpeedMultiplier").defineInRange("elytraBoostSpeedMultiplier", 1.5, 1.0, 5.0);
            JETPACK_MINING_PENALTY = COMMON_BUILDER.comment("Apply mining speed penalty when flying with the Jetpack.").translation("fxntstorage.configuration.jetpackMiningPenalty").define("jetpackMiningPenalty", true);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.comment("Refill Upgrade").push("refill_upgrade");
            REFILL_BLACKLIST = COMMON_BUILDER.comment("Blocks in this list will be ignored by the Refill Upgrade. A wildcard (*) can be used to blacklist all blocks within a namespace. (e.g. minecraft:*)").translation("fxntstorage.configuration.refillBlacklist").defineListAllowEmpty("refillBlacklist", List.of(), () -> "", ConfigManager::validateBlacklist);
            COMMON_BUILDER.pop();
            CURIOS_KEEP_BACKPACK = COMMON_BUILDER.comment("Keep Backpack equipped in Curios slot upon death.").translation("fxntstorage.configuration.keepBackpackOnDeath").define("keepBackpackOnDeath", true);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.comment("Storage Box").push("storage_box");
            STORAGE_BOX_UPDATE_TIME = COMMON_BUILDER.comment("The number of ticks before Storage Boxes update their block count and block states. Higher value = better performance.").translation("fxntstorage.configuration.storageBoxUpdateTime").define("storageBoxUpdateTime", (Object)20);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.comment("Storage Network").push("storage_network");
            SIMPLE_STORAGE_NETWORK_FILL_EMPTY = COMMON_BUILDER.comment("When all existing boxes with matching filters are full, allow the Storage Network to insert into empty boxes instead.").translation("fxntstorage.configuration.allowInsertIntoEmptyBoxes").define("allowInsertIntoEmptyBoxes", true);
            SIMPLE_STORAGE_NETWORK_RANGE = COMMON_BUILDER.comment("The maximum number of blocks the storage network will search from the controller to find connected components.").translation("fxntstorage.configuration.simpleStorageNetworkRange").defineInRange("simpleStorageNetworkRange", 32, 8, 64);
            SIMPLE_STORAGE_NETWORK_UPDATE_TIME = COMMON_BUILDER.comment("The number of ticks between each update check for controllers and interfaces to refresh their connection to the storage network.").translation("fxntstorage.configuration.simpleStorageNetworkUpdateTime").define("simpleStorageNetworkUpdateTime", (Object)20);
            COMMON_BUILDER.pop();
            COMMON_SPEC = COMMON_BUILDER.build();
        }
    }
}

