/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.block.IBE;
import java.util.Optional;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBox
extends BaseEntityBlock
implements IBE<StorageBoxEntity> {
    public static final MapCodec<StorageBox> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockBehaviour.propertiesCodec(), (App)Codec.INT.fieldOf("slot_count").forGetter(StorageBox::getSlotCount)).apply((Applicative)instance, StorageBox::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<EnumProperties.StorageUsed> STORAGE_USED = EnumProperty.create((String)"storage_used", EnumProperties.StorageUsed.class);
    public static final BooleanProperty VOID_UPGRADE = BooleanProperty.create((String)"void_upgrade");
    private final int slotCount;

    public StorageBox(BlockBehaviour.Properties pProperties, int slotCount) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STORAGE_USED, (Comparable)((Object)EnumProperties.StorageUsed.EMPTY))).setValue((Property)VOID_UPGRADE, (Comparable)Boolean.valueOf(false)));
        this.slotCount = slotCount;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public Class<StorageBoxEntity> getBlockEntityClass() {
        return StorageBoxEntity.class;
    }

    public BlockEntityType<? extends StorageBoxEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        StorageBoxEntity storageBoxEntity = new StorageBoxEntity((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get(), blockPos, blockState);
        storageBoxEntity.initializeEntity(this.slotCount);
        return storageBoxEntity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return StorageBox.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StorageBoxEntity) {
            StorageBoxEntity be = (StorageBoxEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.setCustomName(stack.getHoverName());
            }
            SortOrder order = Optional.ofNullable((SortOrder)((Object)stack.get(ModDataComponents.INVENTORY_SORT_ORDER))).orElse(SortOrder.COUNT);
            be.setSortOrder(order);
            be.forceNextTick();
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (!state.is(newState.getBlock())) {
            level.invalidateCapabilities(pos);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack item = new ItemStack((ItemLike)this);
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof StorageBoxEntity) {
            StorageBoxEntity sbe = (StorageBoxEntity)be;
            item.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(sbe.getStacks()));
        }
        return item;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    private boolean hitFront(BlockState blockState, BlockHitResult hit) {
        Direction side = hit.getDirection();
        return blockState.getValue((Property)FACING) == side;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isSpectator() || !this.hitFront(state, hitResult)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof StorageBoxEntity) {
            CompoundTag pd;
            boolean isDoubleClick;
            StorageBoxEntity storageBoxEntity = (StorageBoxEntity)entity;
            ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
            long currentTime = player.level().getGameTime();
            boolean bl = isDoubleClick = currentTime - (pd = player.getPersistentData()).getLong("fxntstorage:last_click_time") < 10L && pd.getInt("fxntstorage:last_click_type") == 1;
            if (isDoubleClick) {
                pd.putInt("fxntstorage:last_click_type", 0);
                if (itemInHand.isEmpty() && !storageBoxEntity.getFilter().getFilter().isEmpty()) {
                    storageBoxEntity.transferToStorage(state, player, true);
                }
            } else {
                pd.putLong("fxntstorage:last_click_time", currentTime);
                pd.putInt("fxntstorage:last_click_type", 1);
                if (itemInHand.is(Tags.Items.TOOLS_WRENCH)) {
                    storageBoxEntity.toggleVoidUpgrade();
                    return InteractionResult.SUCCESS;
                }
                if (player.isShiftKeyDown()) {
                    player.openMenu((MenuProvider)storageBoxEntity, pos);
                    return InteractionResult.CONSUME;
                }
                if (!itemInHand.isEmpty()) {
                    storageBoxEntity.transferToStorage(state, player, false);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)false);
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockHitResult hit = StorageBox.rayTraceEyes(pLevel, pPlayer, pPos);
        if (hit.getType() != HitResult.Type.BLOCK || !hit.getBlockPos().equals((Object)pPos) || !this.hitFront(pState, hit)) {
            return;
        }
        StorageBoxEntity blockEntity = (StorageBoxEntity)pLevel.getBlockEntity(pPos);
        Item item = pPlayer.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (blockEntity != null && !(item instanceof PickaxeItem) && !(item instanceof AxeItem)) {
            blockEntity.transferFromStorage(pPlayer);
        }
    }

    @Nullable
    public static Direction getDirectionFacing(BlockState state) {
        if (!(state.getBlock() instanceof StorageBox)) {
            return null;
        }
        return ((StorageBox)state.getBlock()).getFacing(state);
    }

    protected Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean voidUpgrade = pContext.getItemInHand().getComponents().has(ModDataComponents.VOID_UPGRADE);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)VOID_UPGRADE, (Comparable)Boolean.valueOf(voidUpgrade));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, STORAGE_USED, VOID_UPGRADE});
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof StorageBoxEntity) {
            StorageBoxEntity entity = (StorageBoxEntity)blockEntity;
            float percentFull = entity.calculatePercentageUsed() / 100.0f;
            return (int)Math.min(percentFull * 15.0f, 15.0f);
        }
        return 0;
    }

    public static BlockHitResult rayTraceEyes(Level level, Player player, BlockPos blockPos) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVector = player.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(lookVector.scale(eyePos.distanceTo(Vec3.atCenterOf((Vec3i)blockPos)) + 1.0));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return level.clip(context);
    }
}

