/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.container.util.StorageBoxFilteringBox;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class StorageBoxEntity
extends SmartBlockEntity
implements Container,
MenuProvider,
Nameable,
ThresholdSwitchObservable {
    public int slotCount = 0;
    private int tickCount = 0;
    private Component customName;
    private int storedAmount = -1;
    private float percentageUsed = 0.0f;
    boolean voidUpgrade;
    private FilteringBehaviour filtering;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final Lazy<IItemHandlerModifiable> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    private SortOrder sortOrder;

    public StorageBoxEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.voidUpgrade = (Boolean)state.getValue((Property)StorageBox.VOID_UPGRADE);
        this.sortOrder = SortOrder.COUNT;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                StorageBoxEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return StorageBoxEntity.this.level != null && StorageBoxEntity.this.filterTest(stack);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ItemStack amount = super.insertItem(slot, stack, simulate);
                if (StorageBoxEntity.this.percentageUsed == 100.0f && StorageBoxEntity.this.voidUpgrade) {
                    return ItemStack.EMPTY;
                }
                return amount;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stackToExtract = this.getStackInSlot(slot);
                if (!StorageBoxEntity.this.filterTest(stackToExtract)) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.lazyItemHandler.get();
    }

    public void initializeEntity(int slotCount) {
        this.slotCount = slotCount;
        this.itemHandler.setSize(this.slotCount);
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new StorageBoxFilteringBox()).withCallback($ -> this.invVersionTracker.reset());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public void setChanged() {
        super.setChanged();
        BlockPos pos = this.getBlockPos();
        Level level = this.getLevel();
        if (level != null) {
            level.updateNeighborsAt(pos, this.getBlockState().getBlock());
        }
    }

    public Component getName() {
        return this.customName;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component getDisplayName() {
        return this.customName != null ? this.customName : this.getBlockState().getBlock().getName();
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
        if (this.level != null && this.level.isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSortOrderPacket(this.sortOrder), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (pPlayer.isSpectator()) {
            return null;
        }
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraData.writeBlockPos(this.worldPosition);
        return new StorageBoxMenu(pContainerId, pPlayerInventory, extraData);
    }

    public void readInventory(ItemContainerContents contents) {
        List itemStacks = contents.stream().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemStacks.get(i));
        }
    }

    private void writeStoredData(CompoundTag tag) {
        tag.putInt("SlotCount", this.slotCount);
        tag.putInt("StoredAmount", this.calculateStoredAmount());
        tag.putFloat("PercentageUsed", this.calculatePercentageUsed());
        tag.putBoolean("VoidUpgrade", this.voidUpgrade);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.writeStoredData(tag);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        this.writeStoredData(tag);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        tag.putString("SortOrder", this.sortOrder.name());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("Items"));
        this.slotCount = tag.getInt("SlotCount");
        this.storedAmount = tag.getInt("StoredAmount");
        this.percentageUsed = tag.getFloat("PercentageUsed");
        this.voidUpgrade = tag.getBoolean("VoidUpgrade");
        if (tag.contains("CustomName", 8)) {
            this.customName = StorageBoxEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        SortOrder sortOrder = this.sortOrder = tag.contains("SortOrder", 8) ? SortOrder.valueOf(tag.getString("SortOrder")) : SortOrder.COUNT;
        if (this.slotCount == 0) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Storage Box @ {}", (Object)this.worldPosition);
            this.slotCount = tag.getInt("slotCount");
            this.storedAmount = tag.getInt("storedAmount");
            this.percentageUsed = tag.getInt("percentageUsed");
            this.voidUpgrade = tag.getBoolean("voidUpgrade");
            if (this.slotCount == 0 && tag.contains("Items") && tag.getCompound("Items").contains("Size")) {
                this.slotCount = tag.getCompound("Items").getInt("Size");
            }
        }
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.sortOrder = (SortOrder)((Object)componentInput.getOrDefault(ModDataComponents.INVENTORY_SORT_ORDER, (Object)SortOrder.COUNT));
        this.setVoidUpgrade((Boolean)componentInput.getOrDefault(ModDataComponents.VOID_UPGRADE, (Object)false));
        this.readInventory((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ModDataComponents.VOID_UPGRADE, (Object)this.voidUpgrade);
        components.set(ModDataComponents.INVENTORY_SORT_ORDER, (Object)this.sortOrder);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getStacks()));
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        return this.storedAmount < 1;
    }

    public ItemStack getItem(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        this.itemHandler.extractItem(pSlot, pAmount, false);
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        this.itemHandler.insertItem(pSlot, ItemStack.EMPTY, false);
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.itemHandler.setStackInSlot(pSlot, pStack);
    }

    public boolean stillValid(Player pPlayer) {
        return !this.isRemoved() && Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer, (float)0.0f);
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public int getStoredAmount() {
        return this.calculateStoredAmount();
    }

    public int getPercentageUsed() {
        return Math.round(this.calculatePercentageUsed());
    }

    private int calculateStoredAmount() {
        int storedAmount = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            storedAmount += this.itemHandler.getStackInSlot(i).getCount();
        }
        return storedAmount;
    }

    private int calculateMaxValue() {
        int totalSpace = 0;
        int maxItemStackSize = this.getMaxStackSize();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).isEmpty()) {
                maxItemStackSize = this.itemHandler.getStackInSlot(i).getMaxStackSize();
            }
            totalSpace += maxItemStackSize;
        }
        return totalSpace;
    }

    private int calculateCurrentValue() {
        int usedSpace = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            usedSpace += this.itemHandler.getStackInSlot(i).getCount();
        }
        return usedSpace;
    }

    public float calculatePercentageUsed() {
        int totalSpace = 0;
        int usedSpace = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            int maxStackSize = stack.isEmpty() ? 64 : stack.getMaxStackSize();
            totalSpace += maxStackSize;
            usedSpace += stack.getCount();
        }
        if (totalSpace == 0) {
            return 0.0f;
        }
        return (float)usedSpace / (float)totalSpace * 100.0f;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putString("SortOrder", this.sortOrder.name());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("Items"));
        if (tag.contains("SortOrder", 8)) {
            this.sortOrder = SortOrder.valueOf(tag.getString("SortOrder"));
        }
    }

    public void forceNextTick() {
        this.tickCount = 999;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.isClientSide) {
            if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.STORAGE_BOX_UPDATE_TIME.get()) {
                return;
            }
            this.tickCount = 0;
            BlockState currentState = this.getBlockState();
            int oldStoredAmount = this.storedAmount;
            float oldPercentageUsed = this.percentageUsed;
            this.storedAmount = this.calculateStoredAmount();
            this.percentageUsed = this.calculatePercentageUsed();
            if (this.storedAmount != oldStoredAmount || this.percentageUsed != oldPercentageUsed) {
                this.setChanged();
                pLevel.sendBlockUpdated(pPos, pState, currentState, 2);
            }
            int totalSlots = this.itemHandler.getSlots();
            boolean allSlotsFull = true;
            int filledSlots = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                ItemStack slot = this.itemHandler.getStackInSlot(i);
                if (!slot.isEmpty()) {
                    ++filledSlots;
                    if (slot.getCount() >= slot.getMaxStackSize()) continue;
                    allSlotsFull = false;
                    continue;
                }
                allSlotsFull = false;
            }
            int emptySlots = totalSlots - filledSlots;
            EnumProperties.StorageUsed newStorageUsed = EnumProperties.StorageUsed.EMPTY;
            if (allSlotsFull) {
                newStorageUsed = EnumProperties.StorageUsed.FULL;
            } else if (emptySlots == 0) {
                newStorageUsed = EnumProperties.StorageUsed.SLOTS_FILLED;
            } else if (filledSlots > 0) {
                newStorageUsed = EnumProperties.StorageUsed.HAS_ITEMS;
            }
            if (currentState.getValue(StorageBox.STORAGE_USED) != newStorageUsed) {
                pLevel.setBlock(pPos, (BlockState)currentState.setValue(StorageBox.STORAGE_USED, (Comparable)((Object)newStorageUsed)), 2);
            }
        }
        super.tick();
    }

    public void transferToStorage(BlockState pState, Player pPlayer, Boolean transferAll) {
        ItemStack itemInHand = pPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        boolean isVoidEnabled = (Boolean)pState.getValue((Property)StorageBox.VOID_UPGRADE);
        if (transferAll.booleanValue()) {
            for (int i = 0; i < pPlayer.getInventory().items.size(); ++i) {
                ItemStack playerStack = pPlayer.getInventory().getItem(i);
                if (playerStack.isEmpty() || !this.filtering.test(playerStack)) continue;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)playerStack, (boolean)false);
                if (remainder.getCount() > 0 && isVoidEnabled) {
                    remainder = ItemStack.EMPTY;
                }
                pPlayer.getInventory().setItem(i, remainder);
            }
        } else {
            if (itemInHand.isEmpty() || !this.filterTest(itemInHand)) {
                return;
            }
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)itemInHand, (boolean)false);
            if (remainder.getCount() > 0 && isVoidEnabled) {
                remainder = ItemStack.EMPTY;
            }
            if (remainder.getCount() <= itemInHand.getCount()) {
                pPlayer.setItemInHand(InteractionHand.MAIN_HAND, remainder);
            } else {
                pPlayer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
        }
        this.setChanged();
    }

    public void transferFromStorage(Player pPlayer) {
        ItemStack filterItem = this.filtering.getFilter();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)filterItem)) continue;
            int maxStack = Math.min(this.itemHandler.getStackInSlot(i).getMaxStackSize(), this.itemHandler.getStackInSlot(i).getCount());
            int amountToExtract = pPlayer.isShiftKeyDown() ? maxStack : 1;
            ItemStack toExtract = stackInSlot.copyWithCount(amountToExtract);
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)toExtract);
            this.itemHandler.extractItem(i, amountToExtract, false);
            break;
        }
        this.setChanged();
    }

    private boolean filterTest(ItemStack stack) {
        if (stack.is(ModTags.Items.STORAGE_BOX_ITEM)) {
            return false;
        }
        return this.filtering.test(stack);
    }

    public void toggleVoidUpgrade() {
        BlockState blockState = this.getBlockState();
        Level level = this.getLevel();
        if (level != null) {
            this.voidUpgrade = (Boolean)blockState.getValue((Property)StorageBox.VOID_UPGRADE) == false;
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(this.voidUpgrade)));
            this.setChanged();
        }
    }

    public void setVoidUpgrade(Boolean bool) {
        if (this.voidUpgrade != bool) {
            this.toggleVoidUpgrade();
        }
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getMaxValue() {
        return this.calculateMaxValue();
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        return this.calculateCurrentValue();
    }

    public MutableComponent format(int i) {
        return CreateLang.translateDirect((String)"create.gui.threshold_switch.currently", (Object[])new Object[]{i});
    }

    public void applyInventoryToBlock(ItemStackHandler wrapped) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, i < wrapped.getSlots() ? wrapped.getStackInSlot(i) : ItemStack.EMPTY);
        }
    }
}

