/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import java.util.List;
import java.util.Optional;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StorageBoxItem
extends BlockItem {
    public StorageBoxItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.fxntstorage.holdForContents", (Object[])new Object[]{Screen.hasControlDown() ? "\u00a7fCtrl" : "\u00a77Ctrl"}).withStyle(ChatFormatting.DARK_GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (Screen.hasControlDown() && !Screen.hasShiftDown()) {
            return Optional.of(new BackpackTooltip(stack));
        }
        return Optional.empty();
    }
}

