/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class StorageBoxScreen
extends AbstractContainerScreen<StorageBoxMenu> {
    private final int CONTAINER_SLOTS;
    private final int CONTAINER_COLS = 12;
    private int CONTAINER_ROWS;
    private final int totalRows;
    private final int containerSlotsMinX = 29;
    private final int containerSlotsMaxX = 245;
    private final int containerSlotsMinZ = 17;
    private int containerSlotsMaxZ;
    private int containerSlotsHeight;
    private final int scrollBarMinX = 249;
    private final int scrollBarMaxX = 263;
    private final int scrollBarMinZ = 17;
    private int scrollBarMaxZ;
    private final int inventorySlotsMinX = 60;
    private final int inventorySlotsMaxX = 222;
    private int inventorySlotsMinZ;
    private int inventorySlotsMaxZ;
    private final int hotbarSlotsMinX = 60;
    private int hotbarSlotsMinZ;
    private int hotbarSlotsMaxZ;
    private final int scrollThumbMinX = 270;
    private final int scrollThumbMaxX = 282;
    private final int scrollThumbMinZ = 0;
    private final int scrollThumbMaxZ = 15;
    private int scrollThumbY;
    private int topVisibleRow;
    private int scrollYOffset;
    private final int scrollThumbWidth = 12;
    private final int scrollThumbHeight = 15;
    private boolean isDragging;
    private int inventoryTextOffset;
    private int containerExclusionZoneMinX;
    private int containerExclusionZoneMaxX;
    private int containerExclusionZoneMinZ;
    private int containerExclusionZoneMaxZ;
    private int containerExclusionZoneWidth;
    private int containerExclusionZoneHeight;
    private int inventoryExclusionZoneMinX;
    private int inventoryExclusionZoneMaxX;
    private int inventoryExclusionZoneMinZ;
    private int inventoryExclusionZoneMaxZ;
    private int inventoryExclusionZoneWidth;
    private int inventoryExclusionZoneHeight;
    private static final ResourceLocation GUI_TEXTURE_4 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/storage_box_screen_4.png");
    private static final ResourceLocation GUI_TEXTURE_5 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/storage_box_screen_5.png");
    private static final ResourceLocation GUI_TEXTURE_7 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/storage_box_screen_7.png");
    private static final ResourceLocation GUI_TEXTURE_9 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/storage_box_screen_9.png");
    private static final ResourceLocation GUI_TEXTURE_11 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/storage_box_screen_11.png");
    private final int guiTexture4Height = 187;
    private final int guiTexture4Rows = 4;
    private final int guiTexture5Height = 205;
    private final int guiTexture5Rows = 5;
    private final int guiTexture7Height = 241;
    private final int guiTexture7Rows = 7;
    private final int guiTexture9Height = 277;
    private final int guiTexture9Rows = 9;
    private final int guiTexture11Height = 313;
    private final int guiTexture11Rows = 11;
    private ResourceLocation guiTexture;
    private int textureHeight;
    private final int textureWidth = 282;
    private boolean atBottom;
    private SortOrder currentSortOrder;

    @NotNull
    public static StorageBoxScreen createScreen(StorageBoxMenu menu, Inventory playerInventory, Component title) {
        return new StorageBoxScreen(menu, playerInventory, title);
    }

    public StorageBoxScreen(StorageBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.CONTAINER_SLOTS = ((StorageBoxMenu)this.menu).getContainerSize();
        this.CONTAINER_COLS = 12;
        this.CONTAINER_ROWS = 5;
        this.totalRows = (int)Math.ceil((double)this.CONTAINER_SLOTS / 12.0);
        this.containerSlotsMinX = 29;
        this.containerSlotsMaxX = 245;
        this.containerSlotsMinZ = 17;
        this.containerSlotsMaxZ = 29 + 18 * this.CONTAINER_ROWS;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 17;
        this.scrollBarMinX = 249;
        this.scrollBarMaxX = 263;
        this.scrollBarMinZ = 17;
        this.scrollBarMaxZ = this.containerSlotsMaxZ;
        this.inventorySlotsMinX = 60;
        this.inventorySlotsMaxX = 222;
        this.inventorySlotsMinZ = this.containerSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinX = 60;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.scrollThumbMinX = 270;
        this.scrollThumbMaxX = 282;
        this.scrollThumbMinZ = 0;
        this.scrollThumbMaxZ = 15;
        this.scrollThumbY = 0;
        this.scrollThumbWidth = 12;
        this.scrollThumbHeight = 15;
        this.inventoryTextOffset = 11;
        this.guiTexture4Height = 187;
        this.guiTexture4Rows = 4;
        this.guiTexture5Height = 205;
        this.guiTexture5Rows = 5;
        this.guiTexture7Height = 241;
        this.guiTexture7Rows = 7;
        this.guiTexture9Height = 277;
        this.guiTexture9Rows = 9;
        this.guiTexture11Height = 313;
        this.guiTexture11Rows = 11;
        this.guiTexture = GUI_TEXTURE_5;
        this.textureHeight = 205;
        this.textureWidth = 282;
        this.atBottom = false;
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.updateGuiTextureSize(this.width, this.height);
    }

    public void resize(@NotNull Minecraft minecraft, int winWidth, int winHeight) {
        this.updateGuiTextureSize(winWidth, winHeight);
        this.setTopRowAndMoveThumb(this.topVisibleRow, 0);
        super.resize(minecraft, winWidth, winHeight);
    }

    private void updateGuiTextureSize(int winWidth, int winHeight) {
        this.width = winWidth;
        this.height = winHeight;
        this.imageWidth = 270;
        if (winHeight >= 313 && this.CONTAINER_SLOTS >= 132) {
            this.guiTexture = GUI_TEXTURE_11;
            this.textureHeight = 313;
            this.CONTAINER_ROWS = 11;
        } else if (winHeight >= 277 && this.CONTAINER_SLOTS >= 108) {
            this.guiTexture = GUI_TEXTURE_9;
            this.textureHeight = 277;
            this.CONTAINER_ROWS = 9;
        } else if (winHeight >= 241 && this.CONTAINER_SLOTS >= 84) {
            this.guiTexture = GUI_TEXTURE_7;
            this.textureHeight = 241;
            this.CONTAINER_ROWS = 7;
        } else if (winHeight >= 205 && this.CONTAINER_SLOTS >= 60) {
            this.guiTexture = GUI_TEXTURE_5;
            this.textureHeight = 205;
            this.CONTAINER_ROWS = 5;
        } else {
            this.guiTexture = GUI_TEXTURE_4;
            this.textureHeight = 187;
            this.CONTAINER_ROWS = 4;
        }
        this.imageHeight = this.textureHeight;
        this.scrollBarMaxZ = this.containerSlotsMaxZ = 17 + 18 * this.CONTAINER_ROWS;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 29;
        this.inventorySlotsMinZ = this.containerSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.inventoryTextOffset = 11;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.containerExclusionZoneMinX = this.leftPos + 22;
        this.containerExclusionZoneMinZ = this.topPos;
        this.containerExclusionZoneWidth = 248;
        this.containerExclusionZoneHeight = this.containerSlotsMaxZ + 12;
        this.containerExclusionZoneMaxX = this.containerExclusionZoneMinX + this.containerExclusionZoneWidth;
        this.containerExclusionZoneMaxZ = this.containerExclusionZoneMinZ + this.containerExclusionZoneHeight;
        this.inventoryExclusionZoneMinX = this.leftPos + 60 - 6;
        this.inventoryExclusionZoneMinZ = this.topPos + this.inventorySlotsMinZ - 6;
        this.inventoryExclusionZoneWidth = 174;
        this.inventoryExclusionZoneHeight = this.hotbarSlotsMaxZ - this.inventorySlotsMinZ + 12;
        this.inventoryExclusionZoneMaxX = this.inventoryExclusionZoneMinX + this.inventoryExclusionZoneWidth;
        this.inventoryExclusionZoneMaxZ = this.inventoryExclusionZoneMinZ + this.inventoryExclusionZoneHeight;
        this.initializeSlots();
    }

    protected void init() {
        super.init();
        this.isDragging = false;
        this.currentSortOrder = ((StorageBoxMenu)this.menu).getSortOrder();
        Button sortOrder = Button.builder((Component)this.currentSortOrder.getDisplayName(), button -> {
            this.currentSortOrder = this.currentSortOrder.next();
            button.setMessage(this.currentSortOrder.getDisplayName());
            button.setTooltip(Tooltip.create((Component)Component.literal((String)"Sort by ").append(this.currentSortOrder.name().toUpperCase(Locale.ROOT))));
            ((StorageBoxMenu)this.menu).setSortOrder(this.currentSortOrder);
        }).tooltip(Tooltip.create((Component)Component.literal((String)"Sort by ").append(this.currentSortOrder.name().toUpperCase(Locale.ROOT)))).size(16, 12).pos(this.leftPos + this.imageWidth - 42, this.topPos + 4).build();
        this.addRenderableWidget((GuiEventListener)sortOrder);
    }

    private void initializeSlots() {
        int yOffset;
        int y;
        int index = 0;
        block0: for (y = 0; y < this.totalRows; ++y) {
            yOffset = 17 + y * 18 + 1;
            int scrollSlotYOffset = y >= this.CONTAINER_ROWS ? -2000 : yOffset;
            for (int x = 0; x < 12; ++x) {
                int xOffset = 29 + x * 18 + 1;
                Slot slot = ((StorageBoxMenu)this.menu).getSlot(index);
                slot.x = xOffset;
                slot.y = scrollSlotYOffset;
                if (++index == this.CONTAINER_SLOTS) continue block0;
            }
        }
        index = 0;
        for (y = 0; y < 3; ++y) {
            yOffset = this.inventorySlotsMinZ + y * 18 + 1;
            for (int x = 0; x < 9; ++x) {
                int xOffset = 60 + x * 18 + 1;
                Slot slot = ((StorageBoxMenu)this.menu).getPlayerSlot(index);
                slot.x = xOffset;
                slot.y = yOffset;
                ++index;
            }
        }
        index = 0;
        for (int x = 0; x < 9; ++x) {
            int xOffset = 60 + x * 18 + 1;
            Slot slot = ((StorageBoxMenu)this.menu).getHotbarSlot(index);
            slot.x = xOffset;
            slot.y = this.hotbarSlotsMinZ + 1;
            ++index;
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.guiTexture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 282, this.textureHeight);
        int thumbYOffset = this.isScrollbarRequired() ? 0 : 15;
        graphics.blit(this.guiTexture, this.leftPos + 249 + 1, this.getScrollThumbY(), 270.0f, (float)(0 + thumbYOffset), 12, 15, 282, this.textureHeight);
    }

    private boolean isScrollbarRequired() {
        return this.CONTAINER_ROWS < this.totalRows;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 30, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 60, this.inventorySlotsMinZ - this.inventoryTextOffset, 0x404040, false);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        boolean clickedInside = false;
        double containerLeft = this.containerExclusionZoneMinX;
        double containerRight = this.containerExclusionZoneMaxX;
        double containerTop = this.containerExclusionZoneMinZ;
        double containerBottom = this.containerExclusionZoneMaxZ;
        if (mouseX > containerLeft && mouseX < containerRight && mouseY > containerTop && mouseY < containerBottom) {
            clickedInside = true;
        }
        double inventoryLeft = this.inventoryExclusionZoneMinX;
        double inventoryRight = this.inventoryExclusionZoneMaxX;
        double inventoryTop = this.inventoryExclusionZoneMinZ;
        double inventoryBottom = this.inventoryExclusionZoneMaxZ;
        if (mouseX > inventoryLeft && mouseX < inventoryRight && mouseY > inventoryTop && mouseY < inventoryBottom) {
            clickedInside = true;
        }
        if (!clickedInside) {
            return true;
        }
        return super.hasClickedOutside(mouseX, mouseY, left, top, button);
    }

    private int getScrollThumbY() {
        return this.topPos + 17 + 1 + this.scrollThumbY;
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.scrollThumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.containerSlotsHeight - 15 - 2));
        int row = (int)Math.round((double)this.scrollThumbY / (double)(this.containerSlotsHeight - 15 - 2) * (double)(this.totalRows - this.CONTAINER_ROWS));
        this.setTopRow(this.topVisibleRow, row);
    }

    private void snapThumbToGradation() {
        this.scrollThumbY = (int)((double)this.topVisibleRow / (double)(this.totalRows - this.CONTAINER_ROWS) * (double)(this.CONTAINER_ROWS * 18 - 2 - 15));
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topVisibleRow = newTopRow;
        this.atBottom = newTopRow + this.CONTAINER_ROWS >= this.totalRows;
        int yOffsetBase = 18;
        int numSlotsToUpdate = 12 * this.CONTAINER_ROWS;
        int oldStartIndex = oldTopRow * 12;
        int newStartIndex = newTopRow * 12;
        for (int index = oldStartIndex; index < oldStartIndex + numSlotsToUpdate; ++index) {
            ((Slot)((StorageBoxMenu)this.menu).slots.get((int)index)).y = -2000;
        }
        int newRangeEnd = newStartIndex + numSlotsToUpdate;
        if (this.atBottom) {
            newRangeEnd = Math.min(newRangeEnd, this.CONTAINER_SLOTS);
        }
        for (int index = newStartIndex; index < newRangeEnd; ++index) {
            int row = index / 12 - newTopRow;
            ((Slot)((StorageBoxMenu)this.menu).slots.get((int)index)).y = yOffsetBase + row * 18;
        }
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private boolean isMouseOverScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + 29) && mouseX <= (double)(this.leftPos + 263) && mouseY >= (double)(this.topPos + 17) && mouseY <= (double)(this.topPos + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + 249) && mouseX <= (double)(this.leftPos + 263) && mouseY >= (double)(this.topPos + 17) && mouseY <= (double)(this.topPos + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollThumb(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + 249) && mouseX <= (double)(this.leftPos + 263) && mouseY >= (double)this.getScrollThumbY() && mouseY <= (double)(this.getScrollThumbY() + 15);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverScrollThumb(mouseX, mouseY) && button == 0 && this.isScrollbarRequired()) {
            this.scrollYOffset = (int)mouseY - this.scrollThumbY;
            this.isDragging = true;
        } else if (this.isMouseOverScrollBar(mouseX, mouseY) && button == 0 && this.isScrollbarRequired()) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.topPos);
            this.snapThumbToGradation();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(@NotNull Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
        super.slotClicked(pSlot, pSlotId, pMouseButton, pType);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (!this.isScrollbarRequired()) {
            return false;
        }
        if (this.isMouseOverScrollArea(mouseX, mouseY)) {
            int newTop = scrollY < 0.0 ? Math.min(this.topVisibleRow + (StorageBoxScreen.hasShiftDown() ? this.CONTAINER_ROWS : 1), this.totalRows - this.CONTAINER_ROWS) : Math.max(this.topVisibleRow - (StorageBoxScreen.hasShiftDown() ? this.CONTAINER_ROWS : 1), 0);
            this.setTopRowAndMoveThumb(this.topVisibleRow, newTop);
            return true;
        }
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<Rect2i> getExclusionZones() {
        return Arrays.asList(new Rect2i(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new Rect2i(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }
}

