/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.item.upgrades;

import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.util.KeybindHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UpgradeItem
extends Item {
    public final String name;

    public UpgradeItem(Item.Properties pProperties, String name) {
        super(pProperties);
        this.name = name;
    }

    public String getUpgradeName() {
        String name = this.getDescriptionId();
        String replaceTarget = "item.fxntstorage.";
        return name.replace(replaceTarget, "");
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        switch (this.name) {
            case "backpack_magnet_upgrade_deactivated": 
            case "backpack_pickblock_upgrade_deactivated": 
            case "backpack_itempickup_upgrade_deactivated": 
            case "backpack_flight_upgrade_deactivated": 
            case "backpack_refill_upgrade_deactivated": 
            case "backpack_feeder_upgrade_deactivated": 
            case "backpack_toolswap_upgrade_deactivated": 
            case "backpack_falldamage_upgrade_deactivated": 
            case "backpack_oremining_upgrade_deactivated": 
            case "backpack_torchdeployer_upgrade_deactivated": {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.fxntstorage.upgrade_deactivated").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
            }
            case "backpack_magnet_upgrade": 
            case "backpack_pickblock_upgrade": 
            case "backpack_itempickup_upgrade": 
            case "backpack_refill_upgrade": 
            case "backpack_feeder_upgrade": 
            case "backpack_toolswap_upgrade": 
            case "backpack_falldamage_upgrade": 
            case "backpack_oremining_upgrade": 
            case "backpack_torchdeployer_upgrade": 
            case "storage_box_void_upgrade": 
            case "storage_box_capacity_upgrade": {
                this.addUpgradeDetails(pTooltipComponents);
                break;
            }
            case "backpack_flight_upgrade": {
                this.addFlightUpgradeDetails(pTooltipComponents);
            }
        }
    }

    private void addUpgradeDetails(List<Component> tooltipComponents) {
        if (Objects.equals(this.name, "backpack_flight_upgrade_deactivated")) {
            this.addFlightUpgradeDetails(tooltipComponents);
            return;
        }
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        String placeholder = "";
        String translateKey = ("tooltip.fxntstorage." + this.name).replaceAll("_deactivated$", "");
        text.add(Component.translatable((String)"tooltip.fxntstorage.holdForDescription", (Object[])new Object[]{Screen.hasShiftDown() ? "\u00a7fShift" : "\u00a77Shift"}).withStyle(ChatFormatting.DARK_GRAY));
        if (Screen.hasShiftDown()) {
            text.add(Component.empty());
            text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".summary")), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
            text.add(Component.empty());
            if (Objects.equals(this.name.replaceAll("_deactivated$", ""), "backpack_magnet_upgrade") || Objects.equals(this.name.replaceAll("_deactivated$", ""), "backpack_itempickup_upgrade")) {
                placeholder = ((Integer)ConfigManager.CommonConfig.BACKPACK_MAGNET_RANGE.get()).toString();
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".exclusion")), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
                text.add(Component.empty());
            }
            if (Objects.equals(this.name.replaceAll("_deactivated$", ""), "backpack_oremining_upgrade")) {
                placeholder = KeybindHandler.OREMINE_ANY_BLOCK.getKey().getDisplayName().getString();
            }
            for (int i = 1; i < 10 && I18n.exists((String)(translateKey + ".condition" + i)); ++i) {
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".condition" + i)), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".behaviour" + i), (Object[])new Object[]{placeholder}), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
            }
            if (!this.name.equals("storage_box_capacity_upgrade") && !this.name.equals("storage_box_void_upgrade")) {
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)"tooltip.fxntstorage.upgrade_item_toggle.condition"), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)"tooltip.fxntstorage.upgrade_item_toggle.behaviour"), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
                text.add(Component.empty());
            }
            text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".subtext")), (Style)FontHelper.Palette.GRAY_AND_GOLD.highlight(), (Style)FontHelper.Palette.GRAY_AND_GOLD.highlight()));
        }
        tooltipComponents.addAll(text);
    }

    private void addFlightUpgradeDetails(List<Component> tooltipComponents) {
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        String translateKey = ("tooltip.fxntstorage." + this.name).replaceAll("_deactivated$", "");
        text.add(Component.translatable((String)"tooltip.fxntstorage.holdForDescription", (Object[])new Object[]{Screen.hasShiftDown() ? "\u00a7fShift" : "\u00a77Shift"}).withStyle(ChatFormatting.DARK_GRAY));
        text.add(Component.translatable((String)"tooltip.fxntstorage.holdForControls", (Object[])new Object[]{Screen.hasControlDown() ? "\u00a7fCtrl" : "\u00a77Ctrl"}).withStyle(ChatFormatting.DARK_GRAY));
        if (Screen.hasShiftDown()) {
            text.add(Component.empty());
            text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".summary")), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
            text.add(Component.empty());
            text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)"tooltip.fxntstorage.upgrade_item_toggle.condition"), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
            text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)"tooltip.fxntstorage.upgrade_item_toggle.behaviour"), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
            if (!Screen.hasControlDown()) {
                text.add(Component.empty());
            }
        }
        if (Screen.hasControlDown()) {
            String placeholder = KeybindHandler.TOGGLE_JETPACK_HOVER_KEY.getKey().getDisplayName().getString();
            text.add(Component.empty());
            for (int i = 1; i < 10 && I18n.exists((String)(translateKey + ".condition" + i)); ++i) {
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".condition" + i)), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
                text.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translateKey + ".behaviour" + i), (Object[])new Object[]{placeholder, placeholder}), (Style)FontHelper.Palette.PURPLE.primary(), (Style)FontHelper.Palette.PURPLE.highlight(), (int)1));
            }
        }
        tooltipComponents.addAll(text);
    }
}

