/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.network.handler;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.util.BackpackClientHelper;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.network.packet.SyncContainerPacket;
import net.fxnt.fxntstorage.network.packet.SyncDataComponentPacket;
import net.fxnt.fxntstorage.network.packet.SyncItemStackPacket;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.network.packet.SyncSlotCountPacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedMenu;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSetCarriedPacket(SetCarriedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            context.player().containerMenu.setCarried(packet.stack());
        });
    }

    public void handleSyncNBTDataPacket(SyncDataComponentPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            ItemStack selectedItem = context.player().getMainHandItem();
            if (selectedItem.getItem() instanceof BackpackItem) {
                selectedItem.applyComponents(packet.component());
            }
        });
    }

    public void handleSyncContainerPacket(SyncContainerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            if (context.player().containerMenu instanceof BackpackMenu && context.player().containerMenu.containerId == packet.containerId()) {
                ItemStackHandler itemHandler = ((BackpackMenu)context.player().containerMenu).container.getItemHandler();
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    itemHandler.setStackInSlot(i, packet.items().get(i));
                }
            }
        });
    }

    public void handleSyncSlotCountPacket(SyncSlotCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            if (context.player().containerMenu instanceof BackpackMenu && context.player().containerMenu.containerId == packet.containerId()) {
                ItemStackHandler itemHandler = ((BackpackMenu)context.player().containerMenu).container.getItemHandler();
                itemHandler.setStackInSlot(packet.slot(), packet.stack());
            }
        });
    }

    public void handleVisualJetpackAirPacket(VisualJetpackAirPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            if (packet.airRemaining() < 0) {
                context.player().getPersistentData().remove("VisualJetpackAir");
            } else {
                context.player().getPersistentData().putInt("VisualJetpackAir", packet.airRemaining());
            }
        });
    }

    public void handleSyncMountedStoragePacket(SyncMountedStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            Level level = context.player().level();
            Entity entity = level.getEntity(packet.contraptionId());
            if (entity instanceof AbstractContraptionEntity) {
                SimpleStorageBoxMountedMenu menu;
                BlockState newState;
                AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
                StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraptionEntity.getContraption().getBlocks().get(packet.localPos());
                CompoundTag newNbt = blockInfo.nbt();
                CompoundTag nbt = packet.nbt();
                BlockState oldState = blockInfo.state();
                newNbt.putInt("StoredAmount", nbt.getInt("StoredAmount"));
                newNbt.putBoolean("VoidUpgrade", nbt.getBoolean("VoidUpgrade"));
                newNbt.putInt("MaxItemCapacity", nbt.getInt("MaxItemCapacity"));
                if (oldState.getBlock() instanceof SimpleStorageBox) {
                    if (nbt.contains("FilterItem", 10)) {
                        newNbt.put("FilterItem", (Tag)nbt.getCompound("FilterItem"));
                    }
                    newState = (BlockState)oldState.setValue(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)packet.fillLevel()));
                } else {
                    newNbt.putFloat("PercentageUsed", nbt.getFloat("PercentageUsed"));
                    newState = (BlockState)((BlockState)oldState.setValue(StorageBox.STORAGE_USED, (Comparable)((Object)packet.fillLevel()))).setValue((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(nbt.getBoolean("VoidUpgrade")));
                }
                AbstractContainerMenu patt0$temp = context.player().containerMenu;
                if (patt0$temp instanceof SimpleStorageBoxMountedMenu && (menu = (SimpleStorageBoxMountedMenu)patt0$temp).getLocalPos().equals((Object)packet.localPos())) {
                    menu.setFilterItem(ItemStack.parse((HolderLookup.Provider)context.player().registryAccess(), (Tag)newNbt.getCompound("FilterItem")).orElse(ItemStack.EMPTY));
                }
                StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(blockInfo.pos(), newState, newNbt);
                contraptionEntity.getContraption().getBlocks().put(packet.localPos(), newInfo);
                contraptionEntity.getContraption().resetClientContraption();
            }
        });
    }

    public void handleSyncItemStackPacket(SyncItemStackPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            ItemStack backpack = BackpackClientHelper.getEquippedBackpackStack((LocalPlayer)context.player());
            backpack.applyComponents(packet.dataMap());
        });
    }

    public void handleJetpackFuelSyncPacket(JetpackFuelSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player();
            JetpackHandler handler = JetpackManager.getJetpackHandler(context.player());
            if (handler != null) {
                handler.onFuelSync(packet.fuelRemaining(), packet.serverTime());
            }
        });
    }
}

