/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.registry;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ContraptionStorageFilters {
    private static final Map<Contraption, ContraptionStorageFilters> CONTRAPTION_REGISTRY = Collections.synchronizedMap(new WeakHashMap());
    private final Map<FilterItemStack, Set<FilteredMountedStorage>> filters = new HashMap<FilterItemStack, Set<FilteredMountedStorage>>();

    public static ContraptionStorageFilters getOrCreate(Contraption contraption) {
        return CONTRAPTION_REGISTRY.computeIfAbsent(contraption, c -> new ContraptionStorageFilters());
    }

    public static void cleanupContraption(Contraption contraption) {
        CONTRAPTION_REGISTRY.remove(contraption);
    }

    public void register(FilteredMountedStorage storage, ItemStack filterItem) {
        if (filterItem.isEmpty()) {
            return;
        }
        this.register(storage, FilterItemStack.of((ItemStack)filterItem));
    }

    public void register(FilteredMountedStorage storage, FilterItemStack filterItemStack) {
        if (filterItemStack == null || filterItemStack.isEmpty()) {
            return;
        }
        this.filters.computeIfAbsent(filterItemStack, k -> new HashSet()).add(storage);
    }

    public void unregister(FilteredMountedStorage storage) {
        Iterator<Map.Entry<FilterItemStack, Set<FilteredMountedStorage>>> it = this.filters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FilterItemStack, Set<FilteredMountedStorage>> entry = it.next();
            entry.getValue().remove(storage);
            if (!entry.getValue().isEmpty()) continue;
            it.remove();
        }
    }

    public boolean matches(Level level, ItemStack stack) {
        for (FilterItemStack filter : this.filters.keySet()) {
            if (!filter.test(level, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public static interface FilteredMountedStorage {
    }
}

