/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageBox
extends BaseEntityBlock {
    public static final MapCodec<SimpleStorageBox> CODEC = SimpleStorageBox.simpleCodec(SimpleStorageBox::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<EnumProperties.StorageUsed> STORAGE_USED = EnumProperty.create((String)"storage_used", EnumProperties.StorageUsed.class);

    public SimpleStorageBox(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STORAGE_USED, (Comparable)((Object)EnumProperties.StorageUsed.EMPTY)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        BlockEntityType type = (BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get();
        return new SimpleStorageBoxEntity(type, pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SimpleStorageBox.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get()), (type, world, pos, entity) -> {
            if (entity instanceof SimpleStorageBoxEntity) {
                entity.serverTick(type);
            }
        });
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!oldState.is((Block)this)) {
            level.invalidateCapabilities(pos);
        }
        ((SimpleStorageBoxEntity)Objects.requireNonNull(level.getBlockEntity(pos))).forceTick();
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (!state.is(newState.getBlock())) {
            level.invalidateCapabilities(pos);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleStorageBoxEntity) {
            SimpleStorageBoxEntity be = (SimpleStorageBoxEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.getDisplayName();
            }
            be.forceTick();
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isSpectator() || !this.hitFront(state, hitResult)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof SimpleStorageBoxEntity) {
            CompoundTag pd;
            boolean isDoubleClick;
            SimpleStorageBoxEntity simpleStorageBoxEntity = (SimpleStorageBoxEntity)entity;
            ItemStack handItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            long currentTime = player.level().getGameTime();
            boolean bl = isDoubleClick = currentTime - (pd = player.getPersistentData()).getLong("fxntstorage:last_click_time") < 10L && pd.getInt("fxntstorage:last_click_type") == 1;
            if (isDoubleClick) {
                pd.putInt("fxntstorage:last_click_type", 0);
                if (handItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)handItem, (ItemStack)simpleStorageBoxEntity.filterItem)) {
                    simpleStorageBoxEntity.transferToStorage(player, true);
                }
            } else {
                pd.putLong("fxntstorage:last_click_time", currentTime);
                pd.putInt("fxntstorage:last_click_type", 1);
                if (handItem.isEmpty()) {
                    if (player.isShiftKeyDown()) {
                        player.openMenu((MenuProvider)simpleStorageBoxEntity, pos);
                        return InteractionResult.CONSUME;
                    }
                } else if (handItem.is(Tags.Items.TOOLS_WRENCH) && simpleStorageBoxEntity.getStoredAmount() == 0 && !simpleStorageBoxEntity.filterItem.isEmpty()) {
                    simpleStorageBoxEntity.removeFilter();
                } else if (!handItem.is(Tags.Items.TOOLS_WRENCH)) {
                    if (!handItem.isEmpty() && !handItem.is(ModTags.Items.STORAGE_BOX_UPGRADE) && simpleStorageBoxEntity.getStoredAmount() == 0 && simpleStorageBoxEntity.filterItem.isEmpty()) {
                        simpleStorageBoxEntity.setFilter(handItem);
                    }
                    simpleStorageBoxEntity.transferToStorage(player, false);
                    return InteractionResult.CONSUME;
                }
            }
            simpleStorageBoxEntity.setChanged();
        }
        return InteractionResult.PASS;
    }

    public void attack(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (player.isSpectator() || level.isClientSide) {
            return;
        }
        BlockHitResult hit = SimpleStorageBox.rayTraceEyes(level, player, blockPos);
        if (hit.getType() != HitResult.Type.BLOCK || !hit.getBlockPos().equals((Object)blockPos)) {
            return;
        }
        if (!this.hitFront(blockState, hit)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (blockEntity instanceof SimpleStorageBoxEntity) {
            SimpleStorageBoxEntity storageBoxEntity = (SimpleStorageBoxEntity)blockEntity;
            if (!(item instanceof AxeItem)) {
                CompoundTag pd = player.getPersistentData();
                long lastAttackTime = pd.getLong("fxntstorage:last_attack_time");
                if (level.getGameTime() - lastAttackTime > 1L) {
                    storageBoxEntity.transferFromStorage(player);
                    pd.putLong("fxntstorage:last_attack_time", level.getGameTime());
                }
            }
        }
    }

    private boolean hitFront(BlockState blockState, BlockHitResult hit) {
        Direction side = hit.getDirection();
        return blockState.getValue((Property)FACING) == side;
    }

    public static BlockHitResult rayTraceEyes(Level level, Player player, BlockPos blockPos) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVector = player.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(lookVector.scale(eyePos.distanceTo(Vec3.atCenterOf((Vec3i)blockPos)) + 1.0));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return level.clip(context);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, STORAGE_USED});
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof SimpleStorageBoxEntity) {
            SimpleStorageBoxEntity entity = (SimpleStorageBoxEntity)blockEntity;
            double percentage = (double)entity.storedAmount / (double)entity.maxItemCapacity;
            return (int)Math.min(percentage * 15.0, 15.0);
        }
        return 0;
    }
}

