/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.util.RendererHelper;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SimpleStorageBoxEntityRenderer
implements BlockEntityRenderer<SimpleStorageBoxEntity> {
    protected final BlockEntityRendererProvider.Context context;

    public SimpleStorageBoxEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public static void renderFromContraptionContext(MovementContext context, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double distance;
        BlockState state = context.state;
        CompoundTag tag = context.blockEntityData;
        if (tag == null || state == null) {
            return;
        }
        boolean hasVoidUpgrade = tag.getBoolean("VoidUpgrade");
        int amount = tag.getInt("StoredAmount");
        int totalSpace = tag.getInt("MaxItemCapacity");
        int percentUsed = (int)Math.round((double)amount / (double)totalSpace * 100.0);
        String line1 = Util.formatNumber(amount);
        String line2 = percentUsed + "% Used";
        Direction side = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        PoseStack poseStack = matrices.getModelViewProjection();
        poseStack.pushPose();
        poseStack.translate((float)context.localPos.getX() + 0.5f, (float)context.localPos.getY() + 0.5f, (float)context.localPos.getZ() + 0.5f);
        poseStack.mulPose(Axis.YP.rotation(RendererHelper.SIDE_ROT_Y[side.ordinal()]));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        double d = distance = context.position != null ? Math.sqrt(player.distanceToSqr(context.position)) : Math.sqrt(player.distanceToSqr(context.contraption.entity.toGlobalVector(Vec3.atCenterOf((Vec3i)context.localPos), 1.0f)));
        if (distance >= 10.0) {
            poseStack.popPose();
            return;
        }
        ItemRenderer itemRenderer = mc.getItemRenderer();
        int color = RendererHelper.getColorForDistance(distance);
        BlockPos lightPos = context.contraption.entity.blockPosition().offset((Vec3i)context.localPos).relative(side);
        int blockLight = context.world.getBrightness(LightLayer.BLOCK, lightPos);
        int skyLight = context.world.getBrightness(LightLayer.SKY, lightPos);
        int lightLevel = LightTexture.pack((int)blockLight, (int)skyLight);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color, lightLevel);
        RendererHelper.renderLine(line2, -4.0f, poseStack, buffer, color, lightLevel);
        if (tag.contains("FilterItem")) {
            ItemStack filterItem;
            ItemStack itemStack = filterItem = tag.getCompound("FilterItem").isEmpty() ? ItemStack.EMPTY : ItemStack.parseOptional((HolderLookup.Provider)context.contraption.entity.level().registryAccess(), (CompoundTag)tag.getCompound("FilterItem"));
            if (!filterItem.isEmpty() || hasVoidUpgrade) {
                RendererHelper.renderItem(itemRenderer, filterItem, poseStack, buffer, lightLevel, hasVoidUpgrade);
            }
        }
        poseStack.popPose();
    }

    public void render(SimpleStorageBoxEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        Screen currentScreen = mc.screen;
        boolean isPonderScene = currentScreen instanceof AbstractSimiScreen;
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        int amount = blockEntity.getStoredAmount();
        int totalSpace = blockEntity.getMaxItemCapacity();
        int percentUsed = (int)Math.round((double)amount / (double)totalSpace * 100.0);
        String line1 = Util.formatNumber(amount);
        String line2 = percentUsed + "% Used";
        float distance = (float)Math.sqrt(blockEntity.getBlockPos().distToCenterSqr((Position)player.position()));
        if (distance > 10.0f && !isPonderScene) {
            return;
        }
        if (isPonderScene) {
            distance = 3.0f;
        }
        BlockState blockState = blockEntity.getBlockState();
        Direction side = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(new Matrix4f().rotateYXZ(RendererHelper.SIDE_ROT_Y[side.ordinal()], 0.0f, 0.0f));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        int color = RendererHelper.getColorForDistance(distance);
        BlockPos lightPos = blockEntity.getBlockPos().relative(side);
        int blockLight = level.getBrightness(LightLayer.BLOCK, lightPos);
        int skyLight = level.getBrightness(LightLayer.SKY, lightPos);
        int lightLevel = LightTexture.pack((int)blockLight, (int)skyLight);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color, lightLevel);
        RendererHelper.renderLine(line2, -4.0f, poseStack, buffer, color, lightLevel);
        ItemStack filterItem = blockEntity.getFilterItem();
        if (!filterItem.isEmpty() || blockEntity.voidUpgrade) {
            RendererHelper.renderItem(Minecraft.getInstance().getItemRenderer(), filterItem, poseStack, buffer, lightLevel, blockEntity.voidUpgrade);
        }
    }
}

