/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import java.util.Objects;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxUpgradeSlot;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxVoidSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class SimpleStorageBoxMenu
extends AbstractContainerMenu {
    public final SimpleStorageBoxEntity blockEntity;
    public final Player player;

    public SimpleStorageBoxMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, Objects.requireNonNull(inventory.player.level().getBlockEntity(buf.readBlockPos())));
    }

    public SimpleStorageBoxMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MENU.get(), containerId);
        this.player = inventory.player;
        this.blockEntity = (SimpleStorageBoxEntity)entity;
        this.initSlots();
    }

    public void initSlots() {
        IItemHandlerModifiable itemHandler = this.blockEntity.getItemHandler();
        this.addSlot((Slot)new SimpleStorageBoxVoidSlot((IItemHandler)itemHandler, 1, 8, 20));
        for (int i = 0; i < 9; ++i) {
            int slot = i + 2;
            int y = 58;
            int x = 8;
            this.addSlot((Slot)new SimpleStorageBoxUpgradeSlot((IItemHandler)itemHandler, slot, x + 18 * i, y));
        }
        Inventory playerInventory = this.player.getInventory();
        int xOffset = 8;
        int yOffset = 94;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset = yOffset + 54 + 4;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean stillValid(Player player) {
        return !this.blockEntity.isRemoved() && Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)player, (float)0.0f);
    }

    public void removed(Player player) {
        super.removed(player);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        ItemStack itemStack;
        this.blockEntity.setPlayerInteraction(true);
        int playerStartSlot = 10;
        if (slotId >= 0 && slotId < playerStartSlot && (itemStack = ((Slot)this.slots.get(slotId)).getItem()).is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            int upgrades = this.blockEntity.getCapacityUpgrades();
            if (upgrades > 0) {
                int capacityCheck;
                int storedAmount = this.blockEntity.getStoredAmount();
                int stackSize = 64;
                if (!this.blockEntity.filterItem.isEmpty()) {
                    stackSize = this.blockEntity.filterItem.getMaxStackSize();
                }
                if ((capacityCheck = (32 << upgrades - 1) * stackSize) < storedAmount) {
                    return;
                }
            }
            this.blockEntity.setUpgradeSlotChanged(true);
        }
        super.clicked(slotId, button, clickType, player);
        this.blockEntity.setPlayerInteraction(false);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStack = ((Slot)this.slots.get(index)).getItem();
        int playerStartSlot = 10;
        if (index < playerStartSlot) {
            int playerSlot = player.getInventory().getSlotWithRemainingSpace(slotStack);
            if (playerSlot == -1) {
                playerSlot = player.getInventory().getFreeSlot();
            }
            if (playerSlot > -1) {
                ItemStack playerStack = player.getInventory().getItem(playerSlot);
                if (playerStack.isEmpty()) {
                    player.getInventory().setItem(playerSlot, slotStack.copyWithCount(1));
                } else {
                    playerStack.grow(1);
                }
                slotStack.shrink(1);
                this.blockEntity.setChanged();
                player.getInventory().setChanged();
                return ItemStack.EMPTY;
            }
        } else if (slotStack.is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
            if (!((Slot)this.slots.getFirst()).hasItem()) {
                ((Slot)this.slots.getFirst()).set(slotStack.copyWithCount(1));
                slotStack.shrink(1);
                this.blockEntity.setChanged();
                player.getInventory().setChanged();
                return slotStack;
            }
        } else if (slotStack.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            for (int i = 1; i <= 9; ++i) {
                if (((Slot)this.slots.get(i)).hasItem()) continue;
                ((Slot)this.slots.get(i)).set(slotStack.copyWithCount(1));
                slotStack.shrink(1);
                this.blockEntity.setChanged();
                player.getInventory().setChanged();
                return slotStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        int playerStartSlot = 10;
        if (slot.index < playerStartSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }
}

