/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxMenu;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class SimpleStorageBoxScreen
extends AbstractContainerScreen<SimpleStorageBoxMenu> {
    private final ResourceLocation guiTexture = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/simple_storage_box_screen.png");
    private final int guiTextureWidth = 176;
    private final int guiTextureHeight = 176;

    public static SimpleStorageBoxScreen createScreen(SimpleStorageBoxMenu menu, Inventory playerInventory, Component title) {
        return new SimpleStorageBoxScreen(menu, playerInventory, title);
    }

    public SimpleStorageBoxScreen(SimpleStorageBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 176;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderFilterItem(graphics, this.leftPos + 30, this.topPos + 20);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.guiTexture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 176);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 7, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 7, 82, 0x404040, false);
        graphics.drawString(this.font, "Stored: " + ((SimpleStorageBoxMenu)this.menu).blockEntity.getStoredAmount(), 66, 20, 0x404040, false);
        graphics.drawString(this.font, "Capacity: " + ((SimpleStorageBoxMenu)this.menu).blockEntity.getMaxItemCapacity(), 66, 32, 0x404040, false);
        graphics.drawString(this.font, "Void Mode: " + (((SimpleStorageBoxMenu)this.menu).blockEntity.hasVoidUpgrade() ? "Enabled" : "Disabled"), 66, 44, 0x404040, false);
    }

    private void renderFilterItem(GuiGraphics graphics, int x, int y) {
        ItemStack itemStack = ((SimpleStorageBoxMenu)this.menu).blockEntity.filterItem;
        graphics.pose().pushPose();
        if (!itemStack.isEmpty()) {
            this.renderFilterItemStack(graphics, itemStack, (float)x + 8.0f, (float)y + 8.0f);
        }
        this.renderFilterItemDecoration(graphics, this.font, itemStack, x, y, ((SimpleStorageBoxMenu)this.menu).blockEntity.getStoredAmount());
        graphics.pose().popPose();
    }

    private void renderFilterItemStack(GuiGraphics graphics, ItemStack stack, float x, float y) {
        if (!stack.isEmpty()) {
            PoseStack poseStack = graphics.pose();
            MultiBufferSource.BufferSource buffer = graphics.bufferSource();
            BakedModel bakedModel = this.minecraft.getItemRenderer().getModel(stack, null, null, 0);
            poseStack.pushPose();
            poseStack.translate(x + 8.0f, y + 8.0f, 150.0f);
            try {
                boolean bl;
                poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                poseStack.scale(24.0f, 24.0f, 24.0f);
                boolean bl2 = bl = !bakedModel.usesBlockLight();
                if (bl) {
                    Lighting.setupForFlatItems();
                }
                this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                graphics.flush();
                if (bl) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable var12) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)var12, (String)"Rendering item");
                CrashReportCategory crashReportCategory = crashReport.addCategory("Item being rendered");
                crashReportCategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashReportCategory.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
                crashReportCategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashReport);
            }
            poseStack.popPose();
        }
    }

    public void renderFilterItemDecoration(GuiGraphics graphics, Font font, ItemStack stack, int x, int y, int amount) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        if (!stack.isEmpty() && stack.isBarVisible()) {
            int i = stack.getBarWidth();
            int j = stack.getBarColor();
            int xOffset = x + 3;
            int yOffset = y + 28;
            int width = 26;
            int height = 2;
            graphics.fill(RenderType.guiOverlay(), xOffset, yOffset, xOffset + width, yOffset + height, -16777216);
            graphics.fill(RenderType.guiOverlay(), xOffset, yOffset, xOffset + i * 2, yOffset + height / 2, j | 0xFF000000);
        }
        String string = Util.formatNumber(amount);
        poseStack.translate(0.0f, 0.0f, 200.0f);
        graphics.drawString(font, string, x + 33 - font.width(string), y + 25, 0xFFFFFF, true);
        poseStack.popPose();
    }
}

