/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage.mounted;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Objects;
import java.util.function.Consumer;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.network.PacketDistributor;

public class SimpleStorageBoxMountedMenu
extends AbstractContainerMenu {
    private final Container container;
    private final CompoundTag nbt;
    private final Player player;
    private final int contraptionId;
    private final BlockPos localPos;

    public SimpleStorageBoxMountedMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(containerId, playerInventory, (Container)new SimpleContainer(SimpleStorageBoxEntity.SLOT_COUNT), buf.readInt(), buf.readBlockPos(), Objects.requireNonNull(buf.readNbt()));
    }

    public SimpleStorageBoxMountedMenu(int containerId, Inventory playerInventory, Container container, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        super((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MOUNTED_MENU.get(), containerId);
        int x;
        int y;
        this.nbt = nbt;
        this.container = container;
        this.player = playerInventory.player;
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        container.startOpen(playerInventory.player);
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SimpleStorageBoxMountedMenu.this.getStoredAmount();
            }

            public void set(int i) {
                SimpleStorageBoxMountedMenu.this.setStoredAmount(i);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SimpleStorageBoxMountedMenu.this.getMaxItemCapacity();
            }

            public void set(int i) {
                SimpleStorageBoxMountedMenu.this.setMaxItemCapacity(i);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return SimpleStorageBoxMountedMenu.this.getVoidUpgrade() ? 1 : 0;
            }

            public void set(int i) {
                SimpleStorageBoxMountedMenu.this.setVoidUpgrade(i);
            }
        });
        this.addSlot(new Slot(this, container, 1, 8, 20){

            public boolean mayPlace(ItemStack stack) {
                if (this.hasItem()) {
                    return false;
                }
                return stack.is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        for (int i = 0; i < 9; ++i) {
            int slot = i + 2;
            y = 58;
            x = 8;
            this.addSlot(new Slot(container, slot, x + 18 * i, y){

                public boolean mayPlace(ItemStack stack) {
                    if (this.hasItem()) {
                        return false;
                    }
                    return stack.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get());
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public int getMaxStackSize(ItemStack stack) {
                    return 1;
                }

                public void setChanged() {
                    super.setChanged();
                    SimpleStorageBoxMountedMenu.this.setStorageDirty();
                }
            });
        }
        int xOffset = 8;
        int yOffset = 94;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset = yOffset + 54 + 4;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        int upgrades;
        ItemStack itemStack;
        int playerStartSlot = 10;
        if (slotId >= 0 && slotId < playerStartSlot && (itemStack = ((Slot)this.slots.get(slotId)).getItem()).is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get()) && (upgrades = this.getCapacityUpgrades()) > 0) {
            int storedAmount = this.getStoredAmount();
            int stackSize = 64;
            if (!this.container.getItem(0).isEmpty()) {
                stackSize = this.container.getItem(0).getMaxStackSize();
            }
            int capacityCheck = 32;
            for (int i = 0; i < upgrades - 1; ++i) {
                capacityCheck *= 2;
            }
            if ((capacityCheck *= stackSize) < storedAmount) {
                return;
            }
        }
        super.clicked(slotId, button, clickType, player);
    }

    private int getCapacityUpgrades() {
        int count = 0;
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = ((Slot)this.slots.get(i)).getItem();
            if (stack.isEmpty() || !stack.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++count;
        }
        return count;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStack = ((Slot)this.slots.get(index)).getItem();
        int playerStartSlot = 10;
        if (index < playerStartSlot) {
            int playerSlot = player.getInventory().getSlotWithRemainingSpace(slotStack);
            if (playerSlot == -1) {
                playerSlot = player.getInventory().getFreeSlot();
            }
            if (playerSlot > -1) {
                ItemStack playerStack = player.getInventory().getItem(playerSlot);
                if (playerStack.isEmpty()) {
                    player.getInventory().setItem(playerSlot, slotStack.copyWithCount(1));
                } else {
                    playerStack.grow(1);
                }
                slotStack.shrink(1);
                this.container.setChanged();
                player.getInventory().setChanged();
                this.setStorageDirty();
                return ItemStack.EMPTY;
            }
        } else if (slotStack.is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
            if (!((Slot)this.slots.getFirst()).hasItem()) {
                ((Slot)this.slots.getFirst()).set(slotStack.copyWithCount(1));
                slotStack.shrink(1);
                this.container.setChanged();
                player.getInventory().setChanged();
                return slotStack;
            }
        } else if (slotStack.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            for (int i = 1; i <= 9; ++i) {
                if (((Slot)this.slots.get(i)).hasItem()) continue;
                ((Slot)this.slots.get(i)).set(slotStack.copyWithCount(1));
                slotStack.shrink(1);
                this.container.setChanged();
                player.getInventory().setChanged();
                return slotStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    public void setFilterItem(ItemStack stack) {
        this.nbt.put("FilterItem", stack.copyWithCount(1).save((HolderLookup.Provider)this.player.registryAccess()));
    }

    public ItemStack getFilterItem() {
        CompoundTag filterTag = this.nbt.getCompound("FilterItem");
        if (filterTag.isEmpty() || !filterTag.contains("id", 8)) {
            return ItemStack.EMPTY;
        }
        return ItemStack.parse((HolderLookup.Provider)this.player.registryAccess(), (Tag)filterTag).orElse(ItemStack.EMPTY);
    }

    public int getStoredAmount() {
        if (this.player.level().isClientSide) {
            return this.nbt.getInt("StoredAmount");
        }
        return this.container.getItem(0).getCount();
    }

    public void setStoredAmount(int value) {
        this.nbt.putInt("StoredAmount", value);
        this.updateContraptionNbt(tag -> tag.putInt("StoredAmount", value));
    }

    public int getMaxItemCapacity() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!this.container.getItem(i).is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        int maxCapacity = 32 << upgradeCount;
        int stackSize = this.getFilterItem().isEmpty() ? 64 : this.getFilterItem().getMaxStackSize();
        return maxCapacity * stackSize;
    }

    public void setMaxItemCapacity(int value) {
        this.nbt.putInt("MaxItemCapacity", value);
        this.updateContraptionNbt(tag -> tag.putInt("MaxItemCapacity", value));
    }

    public boolean getVoidUpgrade() {
        return !this.container.getItem(1).isEmpty();
    }

    public void setVoidUpgrade(int value) {
        this.nbt.putBoolean("VoidUpgrade", value != 0);
        this.updateContraptionNbt(tag -> tag.putBoolean("VoidUpgrade", value != 0));
    }

    public Container getContainer() {
        return this.container;
    }

    private void updateContraptionNbt(Consumer<CompoundTag> editor) {
        Entity entity = this.player.level().getEntity(this.contraptionId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
        if (info == null) {
            return;
        }
        CompoundTag tag = info.nbt();
        editor.accept(tag);
        contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(info.pos(), info.state(), tag));
    }

    private void setStorageDirty() {
        if (this.player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetMountedStorageDirtyPacket(this.contraptionId, this.localPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

