/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage.mounted;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.menu.StorageInteractionWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.codec.CreateCodecs;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMountedStorageTypes;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.registry.ContraptionStorageFilters;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageBoxMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler>
implements ContraptionStorageFilters.FilteredMountedStorage {
    public static final MapCodec<SimpleStorageBoxMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(SimpleStorageBoxMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped).fieldOf("value");
    public boolean initialized = false;
    private boolean dirty = false;
    private ItemStack filterItem = ItemStack.EMPTY;
    @Nullable
    private FilterItemStack lastRegisteredFilter = null;
    @Nullable
    private Contraption currentContraption = null;

    protected SimpleStorageBoxMountedStorage(MountedItemStorageType<?> type, ItemStackHandler handler) {
        super(type, (IItemHandlerModifiable)handler);
    }

    protected SimpleStorageBoxMountedStorage(ItemStackHandler handler) {
        this((MountedItemStorageType)ModMountedStorageTypes.SIMPLE_STORAGE_BOX_MOUNTED.get(), handler);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        if (player.isSpectator()) {
            return false;
        }
        ItemStack itemInHand = player.getMainHandItem();
        if (itemInHand.isEmpty()) {
            return this.openStorageMenu(player, contraption, info);
        }
        if (this.canInsertItem(itemInHand)) {
            ItemStack remaining = this.insertItem(0, itemInHand, false);
            player.setItemInHand(InteractionHand.MAIN_HAND, remaining);
            this.markDirty();
            return true;
        }
        if (itemInHand.is(ModTags.Items.STORAGE_BOX_UPGRADE)) {
            this.handleUpgradeInteraction(player, itemInHand);
        }
        return true;
    }

    private boolean canInsertItem(ItemStack itemInHand) {
        return !itemInHand.is(Tags.Items.TOOLS_WRENCH) && !itemInHand.is(ModTags.Items.STORAGE_BOX_UPGRADE) && (this.filterItem.isEmpty() || itemInHand.getItem().equals(this.filterItem.getItem()));
    }

    private void handleUpgradeInteraction(ServerPlayer player, ItemStack itemInHand) {
        if (itemInHand.is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
            this.handleVoidUpgrade(player, itemInHand);
        } else if (itemInHand.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            this.handleCapacityUpgrade(player, itemInHand);
        }
    }

    private void handleVoidUpgrade(ServerPlayer player, ItemStack itemInHand) {
        if (!this.hasVoidUpgrade()) {
            this.setStackInSlot(1, itemInHand.copyWithCount(1));
            if (!player.isCreative()) {
                itemInHand.shrink(1);
                player.getInventory().setChanged();
            }
        } else {
            ItemStack voidStack = this.getStackInSlot(1);
            if (!player.isCreative()) {
                this.giveItemToPlayer(player, voidStack);
            }
            this.setStackInSlot(1, ItemStack.EMPTY);
        }
        this.markDirty();
    }

    private void handleCapacityUpgrade(ServerPlayer player, ItemStack itemInHand) {
        for (int i = 2; i < 11; ++i) {
            if (!this.getStackInSlot(i).isEmpty()) continue;
            this.setStackInSlot(i, itemInHand.copyWithCount(1));
            if (!player.isCreative()) {
                itemInHand.shrink(1);
                player.getInventory().setChanged();
            }
            this.markDirty();
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)"fxntstorage.storage_box_capacity_upgrade_max"), true);
    }

    private void giveItemToPlayer(ServerPlayer player, ItemStack stack) {
        int slot = player.getInventory().getSlotWithRemainingSpace(stack);
        if (slot > -1) {
            player.getInventory().getItem(slot).grow(1);
            player.getInventory().setChanged();
            return;
        }
        slot = player.getInventory().getFreeSlot();
        if (slot > -1) {
            player.getInventory().setItem(slot, stack);
            player.getInventory().setChanged();
            return;
        }
        player.drop(stack, false);
    }

    private boolean openStorageMenu(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        ServerLevel level = player.serverLevel();
        BlockPos localPos = info.pos();
        Vec3 localPosVec = Vec3.atCenterOf((Vec3i)localPos);
        Predicate<Player> stillValid = p -> {
            Vec3 currentPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            return this.isMenuValid(player, contraption, currentPos);
        };
        MutableComponent blockName = Component.translatable((String)"container.fxntstorage.simple_storage_box_title");
        MutableComponent menuName = CreateLang.translateDirect((String)"contraptions.moving_container", (Object[])new Object[]{blockName});
        Consumer<Player> onClose = p -> {
            Vec3 newPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.playClosingSound(level, newPos);
        };
        OptionalInt id = player.openMenu(this.createMenu((Component)menuName, this.wrapped, stillValid, onClose, contraption.entity.getId(), localPos, info.nbt()), buf -> buf.writeInt(contraption.entity.getId()).writeBlockPos(localPos).writeNbt((Tag)info.nbt()));
        return id.isPresent();
    }

    private boolean hasVoidUpgrade() {
        return this.getStackInSlot(1).is(ModItems.STORAGE_BOX_VOID_UPGRADE);
    }

    private int getMaxItemCapacity() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!this.getStackInSlot(i).is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        int maxCapacity = 32 << upgradeCount;
        int stackSize = this.filterItem.isEmpty() ? 64 : this.filterItem.getMaxStackSize();
        return maxCapacity * stackSize;
    }

    @Nullable
    protected MenuProvider createMenu(Component name, IItemHandlerModifiable handler, Predicate<Player> stillValid, Consumer<Player> onClose, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        StorageInteractionWrapper wrapper = new StorageInteractionWrapper(handler, stillValid, onClose);
        return new SimpleMenuProvider((arg_0, arg_1, arg_2) -> SimpleStorageBoxMountedStorage.lambda$createMenu$4((Container)wrapper, contraptionId, localPos, nbt, arg_0, arg_1, arg_2), name);
    }

    public static SimpleStorageBoxMountedStorage fromStorage(SimpleStorageBoxEntity simpleStorageBox) {
        return new SimpleStorageBoxMountedStorage(SimpleStorageBoxMountedStorage.copyToItemStackHandler((IItemHandler)simpleStorageBox.getItemHandler()));
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof SimpleStorageBoxEntity) {
            SimpleStorageBoxEntity simpleStorageBox = (SimpleStorageBoxEntity)be;
            simpleStorageBox.applyInventoryToBlock((ItemStackHandler)this.wrapped, this.filterItem);
        }
        this.currentContraption = null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot > 0) {
            return stack;
        }
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = ((ItemStackHandler)this.wrapped).getStackInSlot(slot);
        int limit = this.getMaxItemCapacity();
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return this.hasVoidUpgrade() ? ItemStack.EMPTY : stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                ((ItemStackHandler)this.wrapped).setStackInSlot(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
        }
        if (this.filterItem.isEmpty()) {
            this.filterItem = stack.copyWithCount(1);
        }
        this.markDirty();
        if (reachedLimit) {
            return this.hasVoidUpgrade() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - limit);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = super.extractItem(slot, amount, simulate);
        if (!stack.isEmpty() && !simulate) {
            this.markDirty();
        }
        return stack;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        ContraptionStorageFilters registry;
        if (this.currentContraption != null && (registry = ContraptionStorageFilters.getOrCreate(this.currentContraption)).matches(this.currentContraption.entity.level(), stack) && this.filterItem.isEmpty()) {
            return false;
        }
        if (this.filterTest(stack)) {
            boolean voidUpgrade = this.hasVoidUpgrade();
            if (slot > 0) {
                return false;
            }
            if (voidUpgrade) {
                return true;
            }
            return this.getStackInSlot(0).getCount() < this.getMaxItemCapacity();
        }
        return false;
    }

    private float getPercent() {
        return (float)this.getStackInSlot(0).getCount() / (float)this.getMaxItemCapacity() * 100.0f;
    }

    private boolean filterTest(ItemStack stack) {
        return this.filterItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.filterItem);
    }

    private EnumProperties.StorageUsed calculateFillLevel() {
        EnumProperties.StorageUsed fillLevel = EnumProperties.StorageUsed.EMPTY;
        int stored = this.getStackInSlot(0).getCount();
        if (stored >= this.getMaxItemCapacity()) {
            fillLevel = EnumProperties.StorageUsed.FULL;
        } else if (stored > 0) {
            fillLevel = EnumProperties.StorageUsed.HAS_ITEMS;
        }
        return fillLevel;
    }

    public void updateClientStorageData(MovementContext context) {
        boolean voidUpgrade;
        int amount = this.getStackInSlot(0).getCount();
        int maxCapacity = this.getMaxItemCapacity();
        boolean bl = voidUpgrade = !this.getStackInSlot(1).isEmpty();
        if (!this.getStackInSlot(0).isEmpty() && this.filterItem.isEmpty()) {
            this.filterItem = this.getStackInSlot(0).copyWithCount(1);
        }
        context.blockEntityData.put("FilterItem", this.filterItem.saveOptional((HolderLookup.Provider)context.contraption.entity.level().registryAccess()));
        EnumProperties.StorageUsed fillLevel = this.calculateFillLevel();
        context.blockEntityData.putInt("StoredAmount", amount);
        context.blockEntityData.putBoolean("VoidUpgrade", voidUpgrade);
        context.blockEntityData.putInt("MaxItemCapacity", maxCapacity);
        context.blockEntityData.putFloat("PercentageUsed", this.getPercent());
        if (!((EnumProperties.StorageUsed)((Object)context.state.getValue(SimpleStorageBox.STORAGE_USED))).equals((Object)fillLevel)) {
            BlockState updatedState = (BlockState)context.state.setValue(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)fillLevel));
            StructureTemplate.StructureBlockInfo updatedInfo = new StructureTemplate.StructureBlockInfo(context.localPos, updatedState, context.blockEntityData);
            context.contraption.getBlocks().put(context.localPos, updatedInfo);
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)context.contraption.entity, (CustomPacketPayload)new SyncMountedStoragePacket(context.contraption.entity.getId(), context.localPos, fillLevel, context.blockEntityData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.markClean();
    }

    public void initBlockEntityData(MovementContext context) {
        if (this.initialized) {
            return;
        }
        CompoundTag itemsTag = context.blockEntityData.getCompound("Items");
        int oldSize = itemsTag.getInt("Size");
        if (oldSize != SimpleStorageBoxEntity.SLOT_COUNT) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Simple Storage Box mounted on contraption {} at {}", (Object)context.contraption.entity.getId(), (Object)context.localPos);
            ItemStackHandler migratedHandler = this.migrateSlotItems((ItemStackHandler)this.wrapped);
            context.blockEntityData.put("Items", (Tag)migratedHandler.serializeNBT((HolderLookup.Provider)context.world.registryAccess()));
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i < migratedHandler.getSlots()) {
                    this.setStackInSlot(i, migratedHandler.getStackInSlot(i));
                    continue;
                }
                this.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
        this.filterItem = ItemStack.parseOptional((HolderLookup.Provider)context.contraption.entity.level().registryAccess(), (CompoundTag)(context.blockEntityData.getCompound("FilterItem").getString("id").equals("minecraft:air") ? new CompoundTag() : context.blockEntityData.getCompound("FilterItem"))).copyWithCount(1);
        this.currentContraption = context.contraption.entity.getContraption();
        if (this.currentContraption != null && !this.filterItem.isEmpty()) {
            FilterItemStack filterWrapper = FilterItemStack.of((ItemStack)this.filterItem);
            ContraptionStorageFilters registry = ContraptionStorageFilters.getOrCreate(this.currentContraption);
            registry.register((ContraptionStorageFilters.FilteredMountedStorage)this, filterWrapper);
            this.lastRegisteredFilter = filterWrapper;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)context.contraption.entity, (CustomPacketPayload)new SyncMountedStoragePacket(context.contraption.entity.getId(), context.localPos, this.calculateFillLevel(), context.blockEntityData.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.markDirty();
        this.initialized = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void markDirty() {
        FilterItemStack newFilter;
        this.dirty = true;
        if (this.currentContraption == null) {
            return;
        }
        ContraptionStorageFilters registry = ContraptionStorageFilters.getOrCreate(this.currentContraption);
        ItemStack candidate = this.getStackInSlot(0).isEmpty() ? this.filterItem : this.getStackInSlot(0).copyWithCount(1);
        FilterItemStack filterItemStack = newFilter = candidate.isEmpty() ? null : FilterItemStack.of((ItemStack)candidate);
        if (this.lastRegisteredFilter != null && newFilter != null && ItemStack.isSameItemSameComponents((ItemStack)this.lastRegisteredFilter.item(), (ItemStack)newFilter.item())) {
            return;
        }
        if (this.lastRegisteredFilter != null) {
            registry.unregister(this);
        }
        if (newFilter != null) {
            registry.register((ContraptionStorageFilters.FilteredMountedStorage)this, this.filterItem);
        }
        this.lastRegisteredFilter = newFilter;
    }

    private ItemStackHandler migrateSlotItems(ItemStackHandler oldHandler) {
        ItemStackHandler newHandler = new ItemStackHandler(SimpleStorageBoxEntity.SLOT_COUNT);
        ItemStack slot0 = oldHandler.getStackInSlot(0);
        ItemStack slot1 = oldHandler.getStackInSlot(1);
        if (!slot0.isEmpty() || !slot1.isEmpty()) {
            ItemStack merged = slot0.copy();
            int totalCount = slot0.getCount() + slot1.getCount();
            merged.setCount(Math.min(totalCount, this.getMaxItemCapacity()));
            newHandler.setStackInSlot(0, merged);
        }
        newHandler.setStackInSlot(1, oldHandler.getStackInSlot(3).copy());
        for (int oldSlot = 4; oldSlot <= 12; ++oldSlot) {
            int newSlot = oldSlot - 4 + 2;
            if (newSlot >= newHandler.getSlots()) continue;
            newHandler.setStackInSlot(newSlot, oldHandler.getStackInSlot(oldSlot).copy());
        }
        return newHandler;
    }

    private static /* synthetic */ AbstractContainerMenu lambda$createMenu$4(Container wrapper, int contraptionId, BlockPos localPos, CompoundTag nbt, int id, Inventory inv, Player player) {
        return new SimpleStorageBoxMountedMenu(id, inv, wrapper, contraptionId, localPos, nbt);
    }
}

