/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.storage_network;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageControllerEntity;
import net.fxnt.fxntstorage.controller.StorageInterfaceEntity;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StorageNetwork {
    private final StorageControllerEntity controller;
    @Nullable
    private Level level;
    private BlockPos controllerPos;
    private final int searchRange = (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_RANGE.get();
    private Set<BlockPos> components = new HashSet<BlockPos>();
    public NonNullList<StorageNetworkItem> boxes = NonNullList.create();
    private int networkVersion = 0;
    private int tickCount = 0;
    private Set<ItemStack> filterItems = new HashSet<ItemStack>();
    private final IItemHandlerModifiable itemHandler = new NetworkItemHandler();

    public StorageNetwork(StorageControllerEntity controller) {
        this.controller = controller;
        this.level = controller.getLevel();
        this.controllerPos = controller.getBlockPos();
        this.components = this.getConnectedComponents(this.level, this.controllerPos);
        this.getBoxes(this.level, this.components);
    }

    public void tick() {
        this.checkBoxes();
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        this.refreshStorageNetwork();
    }

    private void refreshStorageNetwork() {
        this.level = this.controller.getLevel();
        this.controllerPos = this.controller.getBlockPos();
        Set<BlockPos> newComponents = this.getConnectedComponents(this.level, this.controllerPos);
        if (!newComponents.equals(this.components)) {
            HashSet<BlockPos> oldComponents = new HashSet<BlockPos>(this.components);
            oldComponents.removeAll(newComponents);
            for (BlockPos removedPos : oldComponents) {
                BlockEntity blockEntity = this.level.getBlockEntity(removedPos);
                if (!(blockEntity instanceof StorageInterfaceEntity)) continue;
                StorageInterfaceEntity storageInterface = (StorageInterfaceEntity)blockEntity;
                storageInterface.forgetController();
            }
            this.components = newComponents;
            this.networkVersion = (this.networkVersion + 1) % 1000;
        }
        this.getBoxes(this.level, this.components);
        Set<ItemStack> newFilterItems = this.getCurrentFilters();
        if (!this.areFilterSetsEqual(this.filterItems, newFilterItems)) {
            this.filterItems = newFilterItems;
        }
    }

    private boolean areFilterSetsEqual(Set<ItemStack> oldSet, Set<ItemStack> newSet) {
        if (oldSet.size() != newSet.size()) {
            return false;
        }
        for (ItemStack oldStack : oldSet) {
            boolean found = false;
            for (ItemStack newStack : newSet) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)oldStack, (ItemStack)newStack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void checkBoxes() {
        if (this.level == null) {
            return;
        }
        boolean networkChanged = false;
        for (StorageNetworkItem networkItem : this.boxes) {
            SimpleStorageBoxEntity boxEntity;
            BlockEntity blockEntity = this.level.getBlockEntity(networkItem.blockPos);
            if (blockEntity instanceof SimpleStorageBoxEntity && ((Object)((Object)(boxEntity = (SimpleStorageBoxEntity)blockEntity))).equals((Object)networkItem.simpleStorageBoxEntity)) continue;
            networkChanged = true;
            break;
        }
        if (networkChanged) {
            this.refreshStorageNetwork();
        }
    }

    private Set<ItemStack> getCurrentFilters() {
        HashSet<ItemStack> items = new HashSet<ItemStack>();
        for (StorageNetworkItem box : this.boxes) {
            ItemStack filterItem = box.simpleStorageBoxEntity.getFilterItem();
            if (filterItem.isEmpty()) continue;
            items.add(filterItem.copy());
        }
        return items;
    }

    private Set<BlockPos> getConnectedComponents(@Nullable Level level, BlockPos origin) {
        if (level == null) {
            return new HashSet<BlockPos>();
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(origin);
        int lastCheckedPos = 0;
        for (int distanceToController = 0; distanceToController < this.searchRange && lastCheckedPos < positions.size(); ++lastCheckedPos, ++distanceToController) {
            int i = lastCheckedPos;
            while (i < positions.size()) {
                BlockPos checkPos = (BlockPos)positions.get(i);
                for (Direction direction : Direction.values()) {
                    BlockPos pos = checkPos.relative(direction);
                    if (!this.isNetworkComponent(level.getBlockState(pos)) || this.squaredDistance(this.controllerPos, pos) > this.searchRange * this.searchRange || positions.contains(pos)) continue;
                    positions.add(pos);
                }
                lastCheckedPos = i++;
            }
        }
        return new HashSet<BlockPos>(positions);
    }

    private int squaredDistance(BlockPos pos1, BlockPos pos2) {
        int dx = pos1.getX() - pos2.getX();
        int dy = pos1.getY() - pos2.getY();
        int dz = pos1.getZ() - pos2.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    private void getBoxes(Level level, Set<BlockPos> components) {
        this.boxes.clear();
        int b = 0;
        for (BlockPos blockPos : components) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof SimpleStorageBoxEntity) {
                SimpleStorageBoxEntity boxEntity = (SimpleStorageBoxEntity)blockEntity;
                StorageNetworkItem networkItem = new StorageNetworkItem(boxEntity);
                this.boxes.add(b, (Object)networkItem);
                ++b;
                continue;
            }
            if (!(blockEntity instanceof StorageInterfaceEntity)) continue;
            StorageInterfaceEntity interfaceEntity = (StorageInterfaceEntity)blockEntity;
            interfaceEntity.setController(this.controller);
        }
    }

    public void insertItems(ItemStack itemStack) {
        SimpleStorageBoxEntity targetBox;
        ItemStack remaining = itemStack.copy();
        while (!remaining.isEmpty() && (targetBox = this.findBestTargetBox(itemStack)) != null) {
            ItemStack beforeInsertion = remaining.copy();
            remaining = this.insertIntoBox(targetBox, itemStack, 0, false);
            if (remaining.getCount() < beforeInsertion.getCount()) continue;
            break;
        }
        itemStack.setCount(remaining.getCount());
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    private boolean isNetworkComponent(BlockState blockState) {
        return blockState.is(ModTags.Blocks.STORAGE_NETWORK_BLOCK);
    }

    public boolean isItemInNetwork(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack filterStack : this.filterItems) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        if (slot > this.boxes.size()) {
            return false;
        }
        return ((StorageNetworkItem)this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().insertItem(0, itemStack, true).getCount() < itemStack.getCount();
    }

    public boolean canTakeItem(int slot, ItemStack itemStack) {
        return slot <= this.boxes.size() && !itemStack.isEmpty();
    }

    @Nullable
    private SimpleStorageBoxEntity findBestTargetBox(ItemStack itemStack) {
        SimpleStorageBoxEntity emptyBox = null;
        Predicate<SimpleStorageBoxEntity> canAccept = box -> {
            int available = box.getMaxItemCapacity() - box.getStoredAmount();
            return available > 0 || box.hasVoidUpgrade();
        };
        for (StorageNetworkItem networkItem : this.boxes) {
            SimpleStorageBoxEntity box2 = networkItem.simpleStorageBoxEntity;
            if (ItemStack.isSameItemSameComponents((ItemStack)box2.getFilterItem(), (ItemStack)itemStack) && canAccept.test(box2)) {
                return box2;
            }
            if (!box2.getFilterItem().isEmpty() || !canAccept.test(box2) || emptyBox != null) continue;
            emptyBox = box2;
        }
        return (Boolean)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_FILL_EMPTY.get() != false ? emptyBox : null;
    }

    private ItemStack insertIntoBox(SimpleStorageBoxEntity targetBox, ItemStack itemStack, int boxSlot, boolean simulate) {
        int space;
        int toInsert;
        ItemStack remaining = itemStack.copy();
        ItemStack current = targetBox.getItemHandler().getStackInSlot(boxSlot);
        int available = targetBox.maxItemCapacity - targetBox.getStoredAmount();
        if (available <= 0 && targetBox.hasVoidUpgrade()) {
            return ItemStack.EMPTY;
        }
        if (available <= 0 && !targetBox.hasVoidUpgrade()) {
            return itemStack;
        }
        if (current.isEmpty()) {
            int toInsert2 = Math.min(available, remaining.getCount());
            if (toInsert2 > 0 && !simulate) {
                ItemStack copy = remaining.copy();
                copy.setCount(toInsert2);
                targetBox.getItemHandler().setStackInSlot(boxSlot, copy);
                targetBox.setFilter(copy);
                targetBox.setChanged();
            }
            remaining.shrink(toInsert2);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)remaining) && (toInsert = Math.min(space = Math.min(available, targetBox.maxItemCapacity - current.getCount()), remaining.getCount())) > 0) {
            if (!simulate) {
                current.grow(toInsert);
                targetBox.setChanged();
            }
            remaining.shrink(toInsert);
        }
        return remaining.isEmpty() ? ItemStack.EMPTY : remaining;
    }

    private class NetworkItemHandler
    implements IItemHandlerModifiable {
        private NetworkItemHandler() {
        }

        public int getSlots() {
            return StorageNetwork.this.boxes.size();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot > StorageNetwork.this.boxes.size()) {
                return ItemStack.EMPTY;
            }
            return ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().getStackInSlot(0);
        }

        public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
            if (itemStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!StorageNetwork.this.canPlaceItem(slot, itemStack)) {
                return itemStack;
            }
            int boxSlot = 0;
            SimpleStorageBoxEntity targetBox = StorageNetwork.this.findBestTargetBox(itemStack);
            if (targetBox == null) {
                return itemStack;
            }
            return StorageNetwork.this.insertIntoBox(targetBox, itemStack, boxSlot, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int boxSlot = 0;
            if (slot > StorageNetwork.this.boxes.size()) {
                return ItemStack.EMPTY;
            }
            SimpleStorageBoxEntity box = ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity;
            ItemStack current = box.getItemHandler().getStackInSlot(boxSlot);
            if (current.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!StorageNetwork.this.canTakeItem(slot, current)) {
                return ItemStack.EMPTY;
            }
            int toExtract = Math.min(current.getCount(), amount);
            if (simulate) {
                if (toExtract == 0) {
                    return ItemStack.EMPTY;
                }
                ItemStack copy = current.copy();
                copy.setCount(toExtract);
                return copy;
            }
            return box.getItemHandler().extractItem(boxSlot, toExtract, false);
        }

        public int getSlotLimit(int slot) {
            if (slot <= StorageNetwork.this.boxes.size()) {
                return ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.maxItemCapacity;
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return StorageNetwork.this.canPlaceItem(slot, stack);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= StorageNetwork.this.boxes.size()) {
                return;
            }
            ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().setStackInSlot(0, stack);
        }
    }

    public static class StorageNetworkItem {
        public final SimpleStorageBoxEntity simpleStorageBoxEntity;
        public final BlockPos blockPos;

        public StorageNetworkItem(SimpleStorageBoxEntity entity) {
            this.simpleStorageBoxEntity = entity;
            this.blockPos = entity.getBlockPos();
        }
    }
}

