/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackOnBackUpgradeHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.upgrade.TorchDeployerManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageController;
import net.fxnt.fxntstorage.controller.StorageControllerEntity;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.network.packet.CrossbowChargedPacket;
import net.fxnt.fxntstorage.registry.ContraptionStorageFilters;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fxntstorage")
public class EventHandler {
    private static int slowTick = 0;
    private static int mediumTick = 0;
    private static final int slowTicks = 30;
    private static final int mediumTicks = 15;
    private static final Set<UUID> playersUsingBackpackArrows = new HashSet<UUID>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos = event.getPos());
        Block block = state.getBlock();
        if (block instanceof StorageController) {
            StorageController controller = (StorageController)block;
            if (!controller.hitFront(state, event.getHitVec())) {
                return;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof StorageControllerEntity)) {
                return;
            }
            StorageControllerEntity controllerEntity = (StorageControllerEntity)be;
            if (((Boolean)state.getValue((Property)StorageController.CONNECTED)).booleanValue()) {
                if (!level.isClientSide) {
                    controllerEntity.transferItemsFromPlayer(player);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player.isCreative() || player.level().isClientSide || !event.getAction().equals((Object)PlayerInteractEvent.LeftClickBlock.Action.START)) {
            return;
        }
        Level world = event.getLevel();
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        ItemStack tool = player.getMainHandItem();
        if (tool.is(Tags.Items.TOOLS) || tool.is(Tags.Items.TOOLS_SHEAR)) {
            new BackpackOnBackUpgradeHandler(player).fromAttackBlockEvent(player, world, hand, pos);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        Level world = event.getEntity().getCommandSenderWorld();
        InteractionHand hand = event.getEntity().getUsedItemHand();
        ItemStack weapon = player.getMainHandItem().copy();
        Entity target = event.getTarget();
        if ((weapon.is(Tags.Items.TOOLS) || weapon.is(Tags.Items.TOOLS_SHEAR)) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            new BackpackOnBackUpgradeHandler(player).fromAttackEntityEvent(player, world, hand, livingEntity);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!BackpackHelper.isWearingBackpack(player)) {
            return;
        }
        BackpackOnBackUpgradeHandler handler = new BackpackOnBackUpgradeHandler(player);
        JetpackHandler jetpackHandler = JetpackManager.getJetpackHandler(player);
        if (handler.hasUpgrade("backpack_flight_upgrade")) {
            jetpackHandler.execute();
        } else {
            jetpackHandler.endHovering(false);
            jetpackHandler.fadeOutVisualAirOverlay();
        }
        if (player.level().isClientSide || player.isSpectator() || !player.isAlive() || player.isSleeping() || player.isDeadOrDying()) {
            return;
        }
        if (handler.hasUpgrade("backpack_torchdeployer_upgrade")) {
            handler.applyTorchDeployerUpgrade(player);
        }
        ++slowTick;
        if (++mediumTick >= 15) {
            handler.applyRefillUpgrade();
            handler.applyFeederUpgrade();
            mediumTick = 0;
        }
        if (slowTick >= 30) {
            handler.applyMagnetUpgrade();
            slowTick = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        CompoundTag oldData = event.getOriginal().getPersistentData();
        CompoundTag newData = event.getEntity().getPersistentData();
        if (oldData.contains("fxntstorageSettings")) {
            newData.put("fxntstorageSettings", Objects.requireNonNull(oldData.get("fxntstorageSettings")));
        }
        JetpackManager.addPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isSpectator() || player.level().isClientSide || !player.isAlive() || player.isSleeping() || player.isDeadOrDying()) {
                return;
            }
            if (!BackpackHelper.isWearingBackpack(player)) {
                return;
            }
            if (new BackpackOnBackUpgradeHandler(player).applyFallDamageUpgrade()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            JetpackManager.addPlayer((Player)player2);
            if (player2.getPersistentData().getCompound("fxntstorageSettings").isEmpty()) {
                player2.getPersistentData().put("fxntstorageSettings", (Tag)new CompoundTag());
            }
        }
    }

    @SubscribeEvent
    public static void onServerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            JetpackManager.removePlayer((Player)player2);
            TorchDeployerManager.removePlayer(player2);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        Level level = player.level();
        if (level.isClientSide && player.isCreative()) {
            return;
        }
        BackpackOnBackUpgradeHandler handler = new BackpackOnBackUpgradeHandler(player);
        if (event.getState().is(Blocks.TORCH) && handler.hasUpgrade("backpack_torchdeployer_upgrade")) {
            TorchDeployerManager.resetCooldown(player);
        }
        if (!handler.hasUpgrade("backpack_oremining_upgrade")) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (tool.isCorrectToolForDrops(event.getState()) || event.getState().is(ModTags.Blocks.BREAKABLE_WITH_ANY_TOOL)) {
            if (((Boolean)ConfigManager.CommonConfig.OREMINE_ORES_ONLY.get()).booleanValue() && !event.getState().is(ModTags.Blocks.ORE_MINING_BLOCK)) {
                return;
            }
            boolean mineAllBlocks = player.getPersistentData().getCompound("fxntstorageSettings").getBoolean("MineAllBlocks");
            handler.applyOreMiningUpgrade(level, event.getPos(), player, mineAllBlocks, 64);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileEvent(LivingGetProjectileEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getProjectileWeaponItemStack().getItem();
            if (livingEntity instanceof ProjectileWeaponItem) {
                boolean checkBackpack;
                ProjectileWeaponItem weapon = (ProjectileWeaponItem)livingEntity;
                if (!event.getProjectileItemStack().isEmpty()) {
                    return;
                }
                boolean bl = checkBackpack = player.level().isClientSide ? ((Boolean)ConfigManager.ClientConfig.CHECK_BACKPACK_FOR_PROJECTILES.get()).booleanValue() : player.getPersistentData().getCompound("fxntstorageSettings").getBoolean("CheckBackpackForProjectiles");
                if (!checkBackpack || !BackpackHelper.isWearingBackpack(player)) {
                    return;
                }
                ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
                BackpackContainer backpackContainer = new BackpackContainer(backpack, player);
                ItemStackHandler itemHandler = backpackContainer.getItemHandler();
                ItemStack shootable = event.getProjectileWeaponItemStack();
                Predicate predicate = weapon.getAllSupportedProjectiles(shootable);
                boolean hasArrowsInInventory = false;
                for (ItemStack invStack : player.getInventory().items) {
                    if (!predicate.test(invStack)) continue;
                    hasArrowsInInventory = true;
                    break;
                }
                if (!hasArrowsInInventory) {
                    for (int i = 0; i < Util.TOOL_SLOT_END_RANGE; ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (!predicate.test(stack)) continue;
                        event.setProjectileItemStack(stack.copy());
                        if (player.level().isClientSide) break;
                        playersUsingBackpackArrows.add(player.getUUID());
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        UUID playerUUID = player.getUUID();
        if (player.isCreative()) {
            playersUsingBackpackArrows.remove(playerUUID);
            return;
        }
        if (!playersUsingBackpackArrows.remove(playerUUID)) {
            return;
        }
        if (event.getCharge() < 3) {
            return;
        }
        EventHandler.consumeArrowFromBackpack(player);
    }

    @SubscribeEvent
    public static void onCrossbowCharged(LivingEntityUseItemEvent.Stop event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = event.getItem();
        if (!(itemStack.getItem() instanceof CrossbowItem)) {
            return;
        }
        if (event.getDuration() >= 0) {
            return;
        }
        UUID playerUUID = player.getUUID();
        if (!playersUsingBackpackArrows.remove(playerUUID)) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        if (player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CrossbowChargedPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            EventHandler.consumeArrowFromBackpack(player);
        }
    }

    public static void consumeArrowFromBackpack(Player player) {
        if (!BackpackHelper.isWearingBackpack(player)) {
            return;
        }
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        BackpackContainer backpackContainer = new BackpackContainer(backpack, player);
        ItemStackHandler itemHandler = backpackContainer.getItemHandler();
        ItemStack heldItem = player.getMainHandItem();
        ProjectileWeaponItem weapon = null;
        Item item = heldItem.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem mainHand;
            weapon = mainHand = (ProjectileWeaponItem)item;
        } else {
            heldItem = player.getOffhandItem();
            Item item2 = heldItem.getItem();
            if (item2 instanceof ProjectileWeaponItem) {
                ProjectileWeaponItem offHand;
                weapon = offHand = (ProjectileWeaponItem)item2;
            }
        }
        if (weapon == null) {
            return;
        }
        Predicate predicate = weapon.getAllSupportedProjectiles(heldItem);
        for (int i = 0; i < Util.TOOL_SLOT_END_RANGE; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            stack.shrink(1);
            itemHandler.setStackInSlot(i, stack);
            if (player.level().isClientSide) break;
            backpackContainer.setDataChanged();
            break;
        }
    }

    @SubscribeEvent
    public static void onEntityRemoved(EntityLeaveLevelEvent event) {
        Entity entity;
        if (!event.getLevel().isClientSide && (entity = event.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
            ContraptionStorageFilters.cleanupContraption(contraption.getContraption());
        }
    }
}

