/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackEntity;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.cache.BackpackShapeCache;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BackpackBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public final int stackMultiplier;
    public static final int ITEM_SLOT_COUNT = 108;
    public static final int TOOL_SLOT_COUNT = 24;
    public static final int UPGRADE_SLOT_COUNT = 6;
    public static final int TOTAL_SLOT_COUNT = 138;

    public BackpackBlock(BlockBehaviour.Properties pProperties, int stackMultiplier) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.stackMultiplier = stackMultiplier;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        BlockEntityType type = (BlockEntityType)ModBlockEntities.BACKPACK_ENTITY.get();
        BackpackEntity blockEntity = new BackpackEntity(type, pPos, pState);
        blockEntity.setData(138, this.stackMultiplier);
        return blockEntity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BackpackBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BACKPACK_ENTITY.get()), (type, wor, pos, entity) -> entity.serverTick(type));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity be = (BackpackEntity)blockEntity;
            CompoundTag tag = pStack.m_41784_().m_128469_("BlockEntityTag");
            be.m_183515_(tag);
            if (pStack.m_41788_()) {
                be.setCustomName(pStack.m_41786_());
            }
            SortOrder order = tag.m_128441_("SortOrder") ? SortOrder.valueOf(tag.m_128461_("SortOrder")) : SortOrder.COUNT;
            be.setSortOrder(order);
        }
    }

    public static int getSlotCount() {
        return 138;
    }

    public static int getItemSlotCount() {
        return 108;
    }

    public static int getToolSlotCount() {
        return 24;
    }

    public static int getUpgradeSlotCount() {
        return 6;
    }

    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    public ItemStack saveEntityToStack(BackpackEntity blockEntity, ItemStack itemStack) {
        itemStack = blockEntity.saveToItemStack(itemStack);
        return itemStack;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_ || pHand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_6047_() && !BackpackHelper.isWearingBackpack(pPlayer)) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (!(blockEntity instanceof BackpackEntity)) {
                return InteractionResult.FAIL;
            }
            BackpackEntity backPackEntity = (BackpackEntity)blockEntity;
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 0.5f, 1.0f);
            ItemStack itemStack = new ItemStack((ItemLike)BackpackItem.m_41439_((Block)this));
            itemStack = this.saveEntityToStack(backPackEntity, itemStack);
            pLevel.m_7471_(pPos, false);
            boolean equipped = BackpackHelper.equipBackpack(pPlayer, itemStack);
            return equipped ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity backPackEntity = (BackpackEntity)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)backPackEntity, (BlockPos)pPos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BackpackShapeCache.getShape((Direction)state.m_61143_((Property)FACING));
    }

    @NotNull
    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return BackpackShapeCache.getShape((Direction)state.m_61143_((Property)FACING));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BackpackShapeCache.getShape((Direction)state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity backpackEntity = (BackpackEntity)blockEntity;
            return backpackEntity.calcRedstoneFromInventory();
        }
        return 0;
    }
}

