/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.fxnt.fxntstorage.backpack.util.BackpackHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.compat.CuriosCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;

@ParametersAreNonnullByDefault
public class BackpackItem
extends BlockItem {
    private final Block block;

    public BackpackItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties.m_41487_(1).m_41486_());
        this.block = pBlock;
    }

    protected boolean m_7274_(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        return super.m_7274_(pPos, pLevel, pPlayer, pStack, pState);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            final LazyOptional<?> curio = FXNTStorage.curiosLoaded ? LazyOptional.of(() -> new CuriosCompat(stack)) : LazyOptional.empty();
            final ItemStackHandler itemHandler = new ItemStackHandler(){

                public CompoundTag serializeNBT() {
                    ListTag nbtTagList = new ListTag();
                    for (int i = 0; i < this.stacks.size(); ++i) {
                        if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.m_128405_("Slot", i);
                        itemTag.m_128405_("ActualCount", ((ItemStack)this.stacks.get(i)).m_41613_());
                        ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
                        nbtTagList.add((Object)itemTag);
                    }
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("Items", (Tag)nbtTagList);
                    nbt.m_128405_("Size", this.stacks.size());
                    stack.m_41784_().m_128469_("BlockEntityTag").m_128365_("Items", (Tag)nbt);
                    return nbt;
                }

                public void deserializeNBT(CompoundTag nbt) {
                    this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
                    ListTag tagList = nbt.m_128437_("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundTag itemTags = tagList.m_128728_(i);
                        int slot = itemTags.m_128451_("Slot");
                        ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
                        if (itemTags.m_128425_("ActualCount", 3)) {
                            slotStack.m_41764_(itemTags.m_128451_("ActualCount"));
                        }
                        this.stacks.set(slot, (Object)slotStack);
                    }
                    this.onLoad();
                }
            };
            final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
            {
                CompoundTag beTag = stack.m_41784_().m_128469_("BlockEntityTag");
                if (beTag.m_128425_("Items", 10)) {
                    CompoundTag itemsTag = beTag.m_128469_("Items");
                    int size = itemsTag.m_128441_("Size") ? itemsTag.m_128451_("Size") : itemsTag.m_128440_();
                    this.itemHandler.setSize(size);
                    this.itemHandler.deserializeNBT(itemsTag);
                }
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (FXNTStorage.curiosLoaded && cap == CuriosCapability.ITEM) {
                    return this.curio.cast();
                }
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    return this.itemHandlerCap.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        if (armorType != EquipmentSlot.CHEST) {
            return false;
        }
        if (stack.m_41720_() instanceof BackpackItem && ((LivingEntity)entity).m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof BackpackItem) {
            return true;
        }
        if (FXNTStorage.curiosLoaded) {
            return !BackpackHelper.isWearingBackpack((Player)entity);
        }
        return super.canEquip(stack, armorType, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BackpackHandler.openBackpackFromInventory(serverPlayer, (byte)2);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @NotNull
    public String m_5524_() {
        return this.m_41467_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        MutableComponent CTRL_TO_VIEW_CONTENTS = Component.m_237110_((String)"tooltip.fxntstorage.holdForContents", (Object[])new Object[]{Screen.m_96637_() ? "\u00a7fCtrl" : "\u00a77Ctrl"}).m_130940_(ChatFormatting.DARK_GRAY);
        MutableComponent SHIFT_TO_VIEW_SUMMARY = Component.m_237110_((String)"tooltip.fxntstorage.holdForDescription", (Object[])new Object[]{Screen.m_96638_() ? "\u00a7fShift" : "\u00a77Shift"}).m_130940_(ChatFormatting.DARK_GRAY);
        String translationKey = "tooltip.fxntstorage.backpack";
        int placeholder = ((BackpackBlock)this.block).stackMultiplier;
        ArrayList<MutableComponent> summaryLines = new ArrayList<MutableComponent>();
        summaryLines.add(Component.m_237119_());
        summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)(translationKey + ".summary")), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
        summaryLines.add(Component.m_237119_());
        for (int i = 1; i < 10 && I18n.m_118936_((String)(translationKey + ".condition" + i)); ++i) {
            summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)(translationKey + ".condition" + i)), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
            summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237110_((String)(translationKey + ".behaviour" + i), (Object[])new Object[]{placeholder}), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
        }
        if (Screen.m_96638_() == Screen.m_96637_()) {
            tooltipComponents.add((Component)SHIFT_TO_VIEW_SUMMARY);
            tooltipComponents.add((Component)CTRL_TO_VIEW_CONTENTS);
        }
        if (Screen.m_96638_() && !Screen.m_96637_()) {
            tooltipComponents.add((Component)SHIFT_TO_VIEW_SUMMARY);
            tooltipComponents.addAll(summaryLines);
        }
        if (!Screen.m_96638_() && Screen.m_96637_()) {
            tooltipComponents.add((Component)CTRL_TO_VIEW_CONTENTS);
        }
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        if (Screen.m_96637_() && !Screen.m_96638_()) {
            return Optional.of(new BackpackTooltip(pStack));
        }
        return Optional.empty();
    }
}

