/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackSlot;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.main.ToolSlot;
import net.fxnt.fxntstorage.backpack.main.UpgradeSlot;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.HighStackCountSync;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BackpackMenu
extends AbstractContainerMenu {
    public IBackpackContainer container;
    public final Player player;
    public byte backpackType;
    public final int ITEM_SLOT_COUNT = BackpackBlock.getItemSlotCount();
    public final int TOOL_SLOT_COUNT = BackpackBlock.getToolSlotCount();
    public final int UPGRADE_SLOT_COUNT = BackpackBlock.getUpgradeSlotCount();
    public final int TOTAL_SLOT_COUNT = this.ITEM_SLOT_COUNT + this.TOOL_SLOT_COUNT + this.UPGRADE_SLOT_COUNT;
    public boolean ctrlKeyDown = false;

    public BackpackMenu(MenuType<?> type, int containerId, Inventory playerInventory, IBackpackContainer container, byte backpackType) {
        super(type, containerId);
        this.player = playerInventory.f_35978_;
        this.backpackType = backpackType;
        this.container = container;
        this.initSlots();
    }

    public void initSlots() {
        int i;
        Inventory playerInventory = this.player.m_150109_();
        final IBackpackContainer finalContainer = this.container;
        final ItemStackHandler itemHandler = this.container.getItemHandler();
        int index = 0;
        for (i = 0; i < this.ITEM_SLOT_COUNT; ++i) {
            this.m_38897_((Slot)new BackpackSlot((IItemHandler)itemHandler, index, index * 18, 0){

                public boolean m_5857_(ItemStack pStack) {
                    if (pStack.m_41720_() instanceof BackpackItem) {
                        return false;
                    }
                    return super.m_5857_(pStack);
                }

                public int m_6641_() {
                    return finalContainer.getStackMultiplier() * 64;
                }

                public int m_5866_(ItemStack stack) {
                    return Math.max(finalContainer.getStackMultiplier() * stack.m_41741_(), stack.m_41741_());
                }

                public void m_6654_() {
                    super.m_6654_();
                    finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        for (i = 0; i < this.TOOL_SLOT_COUNT; ++i) {
            this.m_38897_((Slot)new ToolSlot((IItemHandler)itemHandler, index, index * 18, 0){

                public boolean m_5857_(ItemStack pStack) {
                    if (pStack.m_41720_() instanceof BackpackItem) {
                        return false;
                    }
                    return super.m_5857_(pStack);
                }

                public void m_142406_(Player pPlayer, ItemStack pStack) {
                    super.m_142406_(pPlayer, pStack);
                }

                public int m_5866_(ItemStack stack) {
                    return Math.min(super.m_5866_(stack), stack.m_41741_());
                }

                public void m_6654_() {
                    super.m_6654_();
                    finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        for (i = 0; i < this.UPGRADE_SLOT_COUNT; ++i) {
            this.m_38897_((Slot)new UpgradeSlot((IItemHandler)itemHandler, index, index * 18, 0){

                @Override
                public boolean m_5857_(ItemStack pStack) {
                    if (pStack.m_204117_(ModTags.Items.BACKPACK_UPGRADE)) {
                        UpgradeItem item = (UpgradeItem)pStack.m_41720_();
                        return BackpackMenu.this.isUniqueUpgrade((IItemHandler)itemHandler, item);
                    }
                    return false;
                }

                public void m_6654_() {
                    super.m_6654_();
                    finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        int yOffset = 0;
        int xOffset = 61;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset += 58;
        for (int i2 = 0; i2 < 9; ++i2) {
            this.m_38897_(new Slot((Container)playerInventory, i2, xOffset + i2 * 18, yOffset));
        }
    }

    public void m_150416_(ContainerSynchronizer pSynchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new HighStackCountSync(serverPlayer));
        } else {
            super.m_150416_(pSynchronizer);
        }
    }

    public boolean m_6875_(Player player) {
        IBackpackContainer iBackpackContainer;
        if (this.backpackType == 2) {
            ItemStack selectedStack = player.m_150109_().m_36056_();
            return selectedStack.m_41720_() instanceof BackpackItem;
        }
        if (this.backpackType == 1) {
            return BackpackHelper.isWearingBackpack(player);
        }
        if (this.backpackType == 3 && (iBackpackContainer = this.container) instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iBackpackContainer;
            return !be.m_58901_() && Container.stillValidBlockEntity((BlockEntity)be, (Player)player, (double)(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) + 0.5));
        }
        return false;
    }

    private boolean isUniqueUpgrade(IItemHandler itemHandler, Item upgradeItem) {
        for (int i = Util.UPGRADE_SLOT_START_RANGE; i < Util.UPGRADE_SLOT_END_RANGE; ++i) {
            if (itemHandler.getStackInSlot(i).m_41720_() != upgradeItem) continue;
            return false;
        }
        return true;
    }

    public SortOrder getSortOrder() {
        return this.container.getSortOrder();
    }

    public void setSortOrder(SortOrder order) {
        this.container.setSortOrder(order);
    }

    public int getSlotsSize() {
        return this.f_38839_.size();
    }

    @NotNull
    public Slot m_38853_(int slotIndex) {
        return (Slot)this.f_38839_.get(slotIndex);
    }

    public Slot getPlayerSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + slotIndex);
    }

    public Slot getHotbarSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + 27 + slotIndex);
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 0 && this.backpackType == 2) {
            int selectedHotBarSlot = pPlayer.m_150109_().f_35977_;
            ItemStack selectedStack = pPlayer.m_150109_().m_36056_();
            if (pSlotId == this.getSlotsSize() - 36 + 27 + selectedHotBarSlot && selectedStack.m_41720_() instanceof BackpackItem) {
                return;
            }
        }
        if (pSlotId >= Util.UPGRADE_SLOT_START_RANGE && pSlotId < Util.UPGRADE_SLOT_END_RANGE) {
            this.toggleUpgrade(pSlotId, this.ctrlKeyDown);
            if (this.player.m_9236_().f_46443_ ? InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) : this.ctrlKeyDown) {
                return;
            }
        }
        this.container.setPlayerInteraction(true);
        if (pClickType == ClickType.PICKUP && pButton == 1 || pClickType == ClickType.QUICK_MOVE && pButton == 0) {
            ClickAction clickaction;
            ClickAction clickAction = clickaction = pButton == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            if (pSlotId == -999) {
                if (!this.m_142621_().m_41619_()) {
                    this.player.m_36176_(this.m_142621_().m_41620_(1), true);
                }
            } else if (pClickType == ClickType.QUICK_MOVE) {
                if (pSlotId < 0) {
                    return;
                }
                slot = (Slot)this.f_38839_.get(pSlotId);
                if (!slot.m_8010_(this.player)) {
                    return;
                }
                ItemStack stack2 = this.m_7648_(this.player, pSlotId);
                while (!stack2.m_41619_() && ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)stack2)) {
                    stack2 = ItemStack.f_41583_;
                }
            } else {
                if (pSlotId < 0) {
                    return;
                }
                slot = (Slot)this.f_38839_.get(pSlotId);
                ItemStack slotItem = slot.m_7993_();
                ItemStack carried = this.m_142621_();
                this.player.m_141945_(carried, slot.m_7993_(), clickaction);
                if (!super.m_246200_(this.player, clickaction, slot, slotItem, carried)) {
                    if (slotItem.m_41619_()) {
                        if (!carried.m_41619_()) {
                            this.m_142503_(slot.m_150656_(carried, 1));
                        }
                    } else if (slot.m_8010_(this.player)) {
                        if (carried.m_41619_()) {
                            Optional tryRemove = slot.m_150641_(slotItem.m_41613_() > slotItem.m_41741_() ? (slotItem.m_41741_() + 1) / 2 : (slotItem.m_41613_() + 1) / 2, Integer.MAX_VALUE, this.player);
                            tryRemove.ifPresent(stack -> {
                                this.m_142503_((ItemStack)stack);
                                slot.m_142406_(this.player, stack);
                            });
                        } else if (slot.m_5857_(carried)) {
                            if (ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)carried)) {
                                this.m_142503_(slot.m_150656_(carried, 1));
                            } else if (carried.m_41613_() <= slot.m_5866_(carried)) {
                                this.m_142503_(slotItem);
                                slot.m_269060_(carried);
                            }
                        } else if (ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)carried)) {
                            Optional tryRemove = slot.m_150641_(slotItem.m_41613_(), carried.m_41741_() - carried.m_41613_(), this.player);
                            tryRemove.ifPresent(stack -> {
                                carried.m_41769_(stack.m_41613_());
                                slot.m_142406_(this.player, stack);
                            });
                        }
                    }
                }
                slot.m_6654_();
            }
        } else {
            super.m_150399_(pSlotId, pButton, pClickType, this.player);
        }
        this.container.setPlayerInteraction(false);
    }

    private boolean isUpgradeItem(ItemStack itemStack) {
        return itemStack.m_204117_(ModTags.Items.BACKPACK_UPGRADE);
    }

    private boolean isToolItem(ItemStack itemStack) {
        return itemStack.m_204117_(Tags.Items.TOOLS) || itemStack.canPerformAction(ToolActions.SHEARS_HARVEST) || itemStack.m_150930_(Items.f_271356_) || itemStack.m_150930_(Items.f_42685_) || itemStack.m_150930_(Items.f_42684_) || itemStack.m_150930_(Items.f_42741_) || itemStack.m_204117_(AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag) || itemStack.m_204117_(AllTags.AllItemTags.WRENCH.tag) || itemStack.m_150930_(AllItems.CARDBOARD_SWORD.m_5456_()) || itemStack.m_150930_(AllItems.POTATO_CANNON.m_5456_());
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotItem = slot.m_7993_();
        if (this.isUpgradeItem(slotItem)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModNetwork.sendToPlayer(serverPlayer, new SetCarriedPacket(ItemStack.f_41583_));
            }
            if (index > Util.UPGRADE_SLOT_END_RANGE) {
                for (int i = Util.UPGRADE_SLOT_START_RANGE; i < Util.UPGRADE_SLOT_END_RANGE; ++i) {
                    if (!((Slot)this.f_38839_.get(i)).m_7993_().m_41619_()) continue;
                    ((Slot)this.f_38839_.get(i)).m_150659_(slotItem);
                    return ItemStack.f_41583_;
                }
            } else {
                this.toggleUpgrade(index, false);
            }
        }
        if (this.isToolItem(slotItem) && index >= Util.UPGRADE_SLOT_END_RANGE) {
            Map<TagKey, Integer> toolSlotMap = Map.of(ItemTags.f_271388_, 0, ItemTags.f_271360_, 1, ItemTags.f_271207_, 2, ItemTags.f_271138_, 3, ItemTags.f_271298_, 4);
            for (Map.Entry<TagKey, Integer> entry : toolSlotMap.entrySet()) {
                int slotIndex;
                if (!slotItem.m_204117_(entry.getKey()) || !((Slot)this.f_38839_.get(slotIndex = Util.TOOL_SLOT_START_RANGE + entry.getValue())).m_7993_().m_41619_()) continue;
                ((Slot)this.f_38839_.get(slotIndex)).m_150659_(slotItem);
                return ItemStack.f_41583_;
            }
            for (int i = Util.TOOL_SLOT_START_RANGE + toolSlotMap.size(); i < Util.TOOL_SLOT_END_RANGE; ++i) {
                if (!((Slot)this.f_38839_.get(i)).m_7993_().m_41619_()) continue;
                ((Slot)this.f_38839_.get(i)).m_150659_(slotItem);
                return ItemStack.f_41583_;
            }
        }
        if (index >= 0 && index < this.f_38839_.size()) {
            ItemStack itemStack = ItemStack.f_41583_;
            if (slot.m_6657_()) {
                ItemStack itemStack2 = slot.m_7993_();
                itemStack = itemStack2.m_41777_();
                if (index < Util.UPGRADE_SLOT_END_RANGE) {
                    if (!this.moveItemStack(itemStack2, Util.UPGRADE_SLOT_END_RANGE, Util.UPGRADE_SLOT_END_RANGE + 36, true)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    if (this.moveItemStack(itemStack2, 0, Util.ITEM_SLOT_END_RANGE, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (this.moveItemStack(itemStack2, Util.TOOL_SLOT_START_RANGE + 5, Util.TOOL_SLOT_END_RANGE, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (this.moveItemStack(itemStack2, Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                if (itemStack2.m_41619_()) {
                    slot.m_269060_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, itemStack2);
            }
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean moveItemStack(ItemStack newStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!newStack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)newStack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.m_41613_() + newStack.m_41613_();
                if (j <= (k = slot.m_5866_(itemstack))) {
                    newStack.m_41764_(0);
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    flag = true;
                } else if (itemstack.m_41613_() < k) {
                    newStack.m_41774_(k - itemstack.m_41613_());
                    itemstack.m_41764_(k);
                    slot.m_6654_();
                    flag = true;
                }
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        if (!newStack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(newStack)) {
                    int l = slot1.m_5866_(newStack);
                    slot1.m_269060_(newStack.m_41620_(Math.min(newStack.m_41613_(), l)));
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void toggleUpgrade(int slotId, boolean ctrlKeyDown) {
        Item item;
        ItemStackHandler itemStackHandler = this.container.getItemHandler();
        ItemStack itemStack = itemStackHandler.getStackInSlot(slotId);
        if (itemStack.m_41619_()) {
            return;
        }
        if (itemStack.m_204117_(ModTags.Items.BACKPACK_UPGRADE) && (item = itemStack.m_41720_()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            String itemName = upgradeItem.getUpgradeName();
            String baseItemName = itemName.replace("backpack_", "").replace("_upgrade", "").replace("_deactivated", "");
            if (ctrlKeyDown) {
                if (itemName.contains("_deactivated")) {
                    itemStackHandler.setStackInSlot(slotId, this.getActivatedItem(baseItemName));
                } else {
                    itemStackHandler.setStackInSlot(slotId, this.getDeactivatedItem(baseItemName));
                }
                this.container.setDataChanged();
            } else if (itemName.contains("_deactivated")) {
                ItemStack stack = this.getActivatedItem(baseItemName);
                itemStackHandler.setStackInSlot(slotId, stack);
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModNetwork.sendToPlayer(serverPlayer, new SetCarriedPacket(stack));
                }
            }
        }
    }

    private ItemStack getActivatedItem(String baseItemName) {
        return switch (baseItemName) {
            case "magnet" -> new ItemStack((ItemLike)ModItems.BACKPACK_MAGNET_UPGRADE.get());
            case "pickblock" -> new ItemStack((ItemLike)ModItems.BACKPACK_PICKBLOCK_UPGRADE.get());
            case "itempickup" -> new ItemStack((ItemLike)ModItems.BACKPACK_ITEMPICKUP_UPGRADE.get());
            case "flight" -> new ItemStack((ItemLike)ModItems.BACKPACK_FLIGHT_UPGRADE.get());
            case "refill" -> new ItemStack((ItemLike)ModItems.BACKPACK_REFILL_UPGRADE.get());
            case "feeder" -> new ItemStack((ItemLike)ModItems.BACKPACK_FEEDER_UPGRADE.get());
            case "toolswap" -> new ItemStack((ItemLike)ModItems.BACKPACK_TOOLSWAP_UPGRADE.get());
            case "falldamage" -> new ItemStack((ItemLike)ModItems.BACKPACK_FALLDAMAGE_UPGRADE.get());
            case "oremining" -> new ItemStack((ItemLike)ModItems.BACKPACK_OREMINING_UPGRADE.get());
            case "torchdeployer" -> new ItemStack((ItemLike)ModItems.BACKPACK_TORCHDEPLOYER_UPGRADE.get());
            default -> ItemStack.f_41583_;
        };
    }

    private ItemStack getDeactivatedItem(String baseItemName) {
        return switch (baseItemName) {
            case "magnet" -> new ItemStack((ItemLike)ModItems.BACKPACK_MAGNET_UPGRADE_DEACTIVATED.get());
            case "pickblock" -> new ItemStack((ItemLike)ModItems.BACKPACK_PICKBLOCK_UPGRADE_DEACTIVATED.get());
            case "itempickup" -> new ItemStack((ItemLike)ModItems.BACKPACK_ITEMPICKUP_UPGRADE_DEACTIVATED.get());
            case "flight" -> new ItemStack((ItemLike)ModItems.BACKPACK_FLIGHT_UPGRADE_DEACTIVATED.get());
            case "refill" -> new ItemStack((ItemLike)ModItems.BACKPACK_REFILL_UPGRADE_DEACTIVATED.get());
            case "feeder" -> new ItemStack((ItemLike)ModItems.BACKPACK_FEEDER_UPGRADE_DEACTIVATED.get());
            case "toolswap" -> new ItemStack((ItemLike)ModItems.BACKPACK_TOOLSWAP_UPGRADE_DEACTIVATED.get());
            case "falldamage" -> new ItemStack((ItemLike)ModItems.BACKPACK_FALLDAMAGE_UPGRADE_DEACTIVATED.get());
            case "oremining" -> new ItemStack((ItemLike)ModItems.BACKPACK_OREMINING_UPGRADE_DEACTIVATED.get());
            case "torchdeployer" -> new ItemStack((ItemLike)ModItems.BACKPACK_TORCHDEPLOYER_UPGRADE_DEACTIVATED.get());
            default -> ItemStack.f_41583_;
        };
    }

    public void sortBackpackItems(int startIndex, int endIndex, SortOrder sortOrder) {
        int stackMultiplier = this.container.getStackMultiplier();
        ServerPlayer sp = (ServerPlayer)this.player;
        HashMap<Util.ItemWithNBT, Integer> itemCompMap = new HashMap<Util.ItemWithNBT, Integer>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = this.m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            CompoundTag tag = stack.m_41783_();
            Util.ItemWithNBT key = new Util.ItemWithNBT(stack.m_41720_(), tag);
            itemCompMap.merge(key, stack.m_41613_(), Integer::sum);
        }
        ArrayList sortedItems = new ArrayList(itemCompMap.entrySet());
        switch (sortOrder) {
            case MOD: {
                sortedItems.sort(Comparator.comparing(entry -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Util.ItemWithNBT)entry.getKey()).item())).toString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            case NAME: {
                sortedItems.sort(Comparator.comparing(entry -> ((Util.ItemWithNBT)entry.getKey()).item().m_7626_(new ItemStack((ItemLike)((Util.ItemWithNBT)entry.getKey()).item())).getString()).thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).getDisplayNameString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            default: {
                sortedItems.sort(Map.Entry.comparingByValue().reversed().thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).toString()));
            }
        }
        NonNullList compactedList = NonNullList.m_122780_((int)(endIndex - startIndex), (Object)ItemStack.f_41583_);
        if (startIndex == Util.TOOL_SLOT_START_RANGE && endIndex == Util.TOOL_SLOT_END_RANGE) {
            List<Class<HoeItem>> toolOrder = List.of(SwordItem.class, PickaxeItem.class, AxeItem.class, ShovelItem.class, HoeItem.class);
            for (int t = 0; t < toolOrder.size(); ++t) {
                Class<HoeItem> clazz = toolOrder.get(t);
                Map.Entry best = sortedItems.stream().filter(e -> toolClass.isInstance(((Util.ItemWithNBT)e.getKey()).item())).max(Comparator.comparingInt(e -> BackpackMenu.getVanillaTierIndex(new ItemStack((ItemLike)((Util.ItemWithNBT)e.getKey()).item())))).orElse(null);
                if (best == null) continue;
                Util.ItemWithNBT key = (Util.ItemWithNBT)best.getKey();
                ItemStack stack = new ItemStack((ItemLike)key.item(), 1);
                CompoundTag tag = key.tag();
                if (tag != null && !tag.m_128456_()) {
                    stack.m_41751_(tag.m_6426_());
                }
                compactedList.set(t, (Object)stack);
                int remaining = (Integer)best.getValue() - 1;
                sortedItems.remove(best);
                if (remaining <= 0) continue;
                sortedItems.add(Map.entry(key, remaining));
            }
        }
        int idx = startIndex == Util.TOOL_SLOT_START_RANGE ? 5 : 0;
        for (Map.Entry entry2 : sortedItems) {
            int totalCount;
            int stackSize;
            int maxStackSize;
            Util.ItemWithNBT key = (Util.ItemWithNBT)entry2.getKey();
            Item item = key.item();
            CompoundTag tag = key.tag();
            ItemStack tempStack = new ItemStack((ItemLike)item, 1);
            int n = maxStackSize = endIndex == Util.ITEM_SLOT_END_RANGE ? stackMultiplier * tempStack.m_41741_() : tempStack.m_41741_();
            for (totalCount = ((Integer)entry2.getValue()).intValue(); totalCount > 0 && idx < compactedList.size(); totalCount -= stackSize) {
                stackSize = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (tag != null && !tag.m_128456_()) {
                    stack.m_41751_(tag.m_6426_());
                }
                compactedList.set(idx++, (Object)stack);
            }
            if (totalCount <= 0 || startIndex != Util.TOOL_SLOT_START_RANGE) continue;
            for (int t = 0; t < 5 && totalCount > 0; ++t) {
                if (!((ItemStack)compactedList.get(t)).m_41619_()) continue;
                int stackSize2 = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize2);
                if (tag != null && !tag.m_128456_()) {
                    stack.m_41751_(tag.m_6426_());
                }
                compactedList.set(t, (Object)stack);
                totalCount -= stackSize2;
            }
        }
        for (int i = 0; i < compactedList.size(); ++i) {
            ItemStack itemStack = (ItemStack)compactedList.get(i);
            Slot slot = this.player.f_36096_.m_38853_(i + startIndex);
            slot.m_5852_(itemStack);
            if (startIndex < Util.UPGRADE_SLOT_END_RANGE) continue;
            sp.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.player.f_36096_.f_38840_, this.m_182424_(), i + startIndex, itemStack));
        }
    }

    public void setTag(CompoundTag tag) {
        if (!this.player.m_9236_().f_46443_) {
            return;
        }
        this.container.setTag(tag);
    }

    public static int getVanillaTierIndex(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            String tier;
            TieredItem tiered = (TieredItem)item;
            return switch (tier = tiered.m_43314_().toString()) {
                case "WOOD" -> 0;
                case "STONE" -> 1;
                case "IRON" -> 2;
                case "GOLD" -> 3;
                case "DIAMOND" -> 4;
                case "NETHERITE" -> 5;
                default -> -1;
            };
        }
        return -1;
    }
}

