/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.KeyPressedPacket;
import net.fxnt.fxntstorage.util.KeybindHandler;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BackpackScreen
extends AbstractContainerScreen<BackpackMenu> {
    private static final int CONTAINER_COLUMNS = 12;
    private static final int TOOL_SLOT_COLUMNS = 12;
    private static final int TOOL_SLOT_ROWS = 2;
    private static final int UPGRADE_SLOT_COLUMNS = 1;
    private static final int UPGRADE_SLOT_ROWS = 6;
    private final int itemSlots;
    private final int toolSlots;
    private final int totalSlots;
    private final int totalRows;
    private int containerRows;
    private static final int containerSlotsMinX = 29;
    private static final int containerSlotsMaxX = 245;
    private static final int containerSlotsMinZ = 17;
    private int containerSlotsMaxZ;
    private int containerSlotsHeight;
    private static final int scrollBarMinX = 249;
    private static final int scrollBarMaxX = 263;
    private static final int scrollBarMinZ = 17;
    private int scrollBarMaxZ;
    private static final int upgradeSlotsMinX = 7;
    private static final int upgradeSlotsMinZ = 17;
    private static final int toolSlotsMinX = 29;
    private int toolSlotsMinZ;
    private int toolSlotsMaxZ;
    private final int inventorySlotsMinX = 60;
    private final int inventorySlotsMaxX = 222;
    private int inventorySlotsMinZ;
    private int inventorySlotsMaxZ;
    private final int hotbarSlotsMinX = 60;
    private int hotbarSlotsMinZ;
    private int hotbarSlotsMaxZ;
    private static final int scrollThumbMinX = 270;
    private static final int scrollThumbMaxX = 282;
    private static final int scrollThumbMinZ = 0;
    private static final int scrollThumbMaxZ = 15;
    private static final int scrollThumbWidth = 12;
    private static final int scrollThumbHeight = 15;
    private boolean isDragging;
    private int scrollThumbY;
    private int topVisibleRow;
    private int scrollYOffset;
    private int inventoryTextOffset;
    private int containerExclusionZoneMinX;
    private int containerExclusionZoneMaxX;
    private int containerExclusionZoneMinZ;
    private int containerExclusionZoneMaxZ;
    private int containerExclusionZoneWidth;
    private int containerExclusionZoneHeight;
    private int inventoryExclusionZoneMinX;
    private int inventoryExclusionZoneMaxX;
    private int inventoryExclusionZoneMinZ;
    private int inventoryExclusionZoneMaxZ;
    private int inventoryExclusionZoneWidth;
    private int inventoryExclusionZoneHeight;
    private static final ResourceLocation GUI_TEXTURE_4 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/backpack_screen_4.png");
    private static final ResourceLocation GUI_TEXTURE_7 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/backpack_screen_7.png");
    private static final ResourceLocation GUI_TEXTURE_9 = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/gui/container/backpack_screen_9.png");
    private static final int GUI_TEXTURE_4_HEIGHT = 225;
    private static final int GUI_TEXTURE_4_ROWS = 4;
    private static final int GUI_TEXTURE_7_HEIGHT = 281;
    private static final int GUI_TEXTURE_7_ROWS = 7;
    private static final int GUI_TEXTURE_9_HEIGHT = 317;
    private static final int GUI_TEXTURE_9_ROWS = 9;
    private static final int TEXTURE_WIDTH = 282;
    private ResourceLocation guiTexture;
    private int textureHeight;
    private SortOrder currentSortOrder;

    public BackpackScreen(BackpackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.itemSlots = ((BackpackMenu)this.f_97732_).ITEM_SLOT_COUNT;
        this.toolSlots = ((BackpackMenu)this.f_97732_).TOOL_SLOT_COUNT;
        this.totalSlots = ((BackpackMenu)this.f_97732_).TOTAL_SLOT_COUNT;
        this.totalRows = (int)Math.ceil((double)this.itemSlots / 12.0);
        this.containerRows = 5;
        this.containerSlotsMaxZ = 29 + 18 * this.containerRows;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 17;
        this.scrollBarMaxZ = this.containerSlotsMaxZ;
        this.toolSlotsMinZ = this.containerSlotsMaxZ + 4;
        this.toolSlotsMaxZ = this.toolSlotsMinZ + 36;
        this.inventorySlotsMinX = 60;
        this.inventorySlotsMaxX = 222;
        this.inventorySlotsMinZ = this.toolSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinX = 60;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.scrollThumbY = 0;
        this.inventoryTextOffset = 11;
        this.guiTexture = GUI_TEXTURE_4;
        this.textureHeight = 225;
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.updateGuiTextureSize(this.f_96543_, this.f_96544_);
    }

    public void m_6574_(Minecraft minecraft, int winWidth, int winHeight) {
        this.updateGuiTextureSize(winWidth, winHeight);
        this.setTopRowAndMoveThumb(this.topVisibleRow, 0);
        super.m_6574_(minecraft, winWidth, winHeight);
    }

    private void updateGuiTextureSize(int winWidth, int winHeight) {
        this.f_96543_ = winWidth;
        this.f_96544_ = winHeight;
        this.f_97726_ = 270;
        if (winHeight >= 317) {
            this.guiTexture = GUI_TEXTURE_9;
            this.textureHeight = 317;
            this.containerRows = 9;
        } else if (winHeight >= 281) {
            this.guiTexture = GUI_TEXTURE_7;
            this.textureHeight = 281;
            this.containerRows = 7;
        } else {
            this.guiTexture = GUI_TEXTURE_4;
            this.textureHeight = 225;
            this.containerRows = 4;
        }
        this.f_97727_ = this.textureHeight;
        this.scrollBarMaxZ = this.containerSlotsMaxZ = 17 + 18 * this.containerRows;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 29;
        this.toolSlotsMinZ = this.guiTexture == GUI_TEXTURE_4 ? this.containerSlotsMaxZ + 2 : this.containerSlotsMaxZ + 4;
        this.toolSlotsMaxZ = this.toolSlotsMinZ + 36;
        this.inventorySlotsMinZ = this.toolSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.inventoryTextOffset = 11;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.containerExclusionZoneMinX = this.f_97735_;
        this.containerExclusionZoneMinZ = this.f_97736_;
        this.containerExclusionZoneWidth = 270;
        this.containerExclusionZoneHeight = this.toolSlotsMaxZ + 12;
        this.containerExclusionZoneMaxX = this.containerExclusionZoneMinX + this.containerExclusionZoneWidth;
        this.containerExclusionZoneMaxZ = this.containerExclusionZoneMinZ + this.containerExclusionZoneHeight;
        this.inventoryExclusionZoneMinX = this.f_97735_ + 60 - 6;
        this.inventoryExclusionZoneMinZ = this.f_97736_ + this.inventorySlotsMinZ - 6;
        this.inventoryExclusionZoneWidth = 174;
        this.inventoryExclusionZoneHeight = this.hotbarSlotsMaxZ - this.inventorySlotsMinZ + 12;
        this.inventoryExclusionZoneMaxX = this.inventoryExclusionZoneMinX + this.inventoryExclusionZoneWidth;
        this.inventoryExclusionZoneMaxZ = this.inventoryExclusionZoneMinZ + this.inventoryExclusionZoneHeight;
        this.initializeSlots();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.isDragging = false;
        this.currentSortOrder = ((BackpackMenu)this.f_97732_).getSortOrder();
        Button sortOrder = Button.m_253074_((Component)this.currentSortOrder.getDisplayName(), button -> {
            this.currentSortOrder = this.currentSortOrder.next();
            button.m_93666_(this.currentSortOrder.getDisplayName());
            button.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Sort by ").m_130946_(this.currentSortOrder.name().toUpperCase(Locale.ROOT))));
            ((BackpackMenu)this.f_97732_).setSortOrder(this.currentSortOrder);
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Sort by ").m_130946_(this.currentSortOrder.name().toUpperCase(Locale.ROOT)))).m_253046_(16, 12).m_252794_(this.f_97735_ + this.f_97726_ - 42, this.f_97736_ + 4).m_253136_();
        this.m_142416_((GuiEventListener)sortOrder);
    }

    private void initializeSlots() {
        int xOffset;
        int x;
        int yOffset;
        int y;
        int index = 0;
        block0: for (y = 0; y < this.totalRows; ++y) {
            yOffset = 17 + y * 18 + 1;
            int scrollSlotYOffset = y >= this.containerRows ? -2000 : yOffset;
            for (int x2 = 0; x2 < 12; ++x2) {
                int xOffset2 = 29 + x2 * 18 + 1;
                Slot slot = ((BackpackMenu)this.f_97732_).m_38853_(index);
                slot.f_40220_ = xOffset2;
                slot.f_40221_ = scrollSlotYOffset;
                if (++index == this.itemSlots) continue block0;
            }
        }
        block2: for (y = 0; y < 2; ++y) {
            yOffset = this.toolSlotsMinZ + y * 18 + 1;
            for (x = 0; x < 12; ++x) {
                xOffset = 29 + x * 18 + 1;
                Slot slot = ((BackpackMenu)this.f_97732_).m_38853_(index);
                slot.f_40220_ = xOffset;
                slot.f_40221_ = yOffset;
                if (++index == this.itemSlots + this.toolSlots) continue block2;
            }
        }
        block4: for (y = 0; y < 6; ++y) {
            yOffset = 17 + y * 18 + 1;
            for (x = 0; x < 1; ++x) {
                xOffset = 7 + x * 18 + 1;
                Slot slot = ((BackpackMenu)this.f_97732_).m_38853_(index);
                slot.f_40220_ = xOffset;
                slot.f_40221_ = yOffset;
                if (++index == this.totalSlots) continue block4;
            }
        }
        index = 0;
        for (y = 0; y < 3; ++y) {
            yOffset = this.inventorySlotsMinZ + y * 18 + 1;
            for (x = 0; x < 9; ++x) {
                xOffset = 60 + x * 18 + 1;
                Slot slot = ((BackpackMenu)this.f_97732_).getPlayerSlot(index);
                slot.f_40220_ = xOffset;
                slot.f_40221_ = yOffset;
                ++index;
            }
        }
        index = 0;
        for (int x3 = 0; x3 < 9; ++x3) {
            int xOffset3 = 60 + x3 * 18 + 1;
            Slot slot = ((BackpackMenu)this.f_97732_).getHotbarSlot(index);
            slot.f_40220_ = xOffset3;
            slot.f_40221_ = this.hotbarSlotsMinZ + 1;
            ++index;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(this.guiTexture, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 282, this.textureHeight);
        int thumbYOffset = this.isScrollbarRequired() ? 0 : 15;
        graphics.m_280163_(this.guiTexture, this.f_97735_ + 249 + 1, this.getScrollThumbY(), 270.0f, (float)(0 + thumbYOffset), 12, 15, 282, this.textureHeight);
    }

    private boolean isScrollbarRequired() {
        return this.containerRows < 9;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, 60, this.inventorySlotsMinZ - this.inventoryTextOffset, 0x404040, false);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        boolean clickedInside = false;
        double containerLeft = this.containerExclusionZoneMinX;
        double containerRight = this.containerExclusionZoneMaxX;
        double containerTop = this.containerExclusionZoneMinZ;
        double containerBottom = this.containerExclusionZoneMaxZ;
        if (mouseX > containerLeft && mouseX < containerRight && mouseY > containerTop && mouseY < containerBottom) {
            clickedInside = true;
        }
        double inventoryLeft = this.inventoryExclusionZoneMinX;
        double inventoryRight = this.inventoryExclusionZoneMaxX;
        double inventoryTop = this.inventoryExclusionZoneMinZ;
        double inventoryBottom = this.inventoryExclusionZoneMaxZ;
        if (mouseX > inventoryLeft && mouseX < inventoryRight && mouseY > inventoryTop && mouseY < inventoryBottom) {
            clickedInside = true;
        }
        if (!clickedInside) {
            return true;
        }
        return super.m_7467_(mouseX, mouseY, left, top, button);
    }

    private int getScrollThumbY() {
        return this.f_97736_ + 17 + 1 + this.scrollThumbY;
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.scrollThumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.containerSlotsHeight - 15 - 2));
        int row = (int)Math.round((double)this.scrollThumbY / (double)(this.containerSlotsHeight - 15 - 2) * (double)(this.totalRows - this.containerRows));
        this.setTopRow(this.topVisibleRow, row);
    }

    private void snapThumbToGradation() {
        this.scrollThumbY = (int)((double)this.topVisibleRow / (double)(this.totalRows - this.containerRows) * (double)(this.containerRows * 18 - 2 - 15));
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topVisibleRow = newTopRow;
        boolean atBottom = newTopRow + this.containerRows >= this.totalRows;
        int yOffsetBase = 18;
        int numSlotsToUpdate = 12 * this.containerRows;
        int oldStartIndex = oldTopRow * 12;
        int newStartIndex = newTopRow * 12;
        for (int index = oldStartIndex; index < oldStartIndex + numSlotsToUpdate; ++index) {
            ((Slot)((BackpackMenu)this.f_97732_).f_38839_.get((int)index)).f_40221_ = -2000;
        }
        int newRangeEnd = newStartIndex + numSlotsToUpdate;
        if (atBottom) {
            newRangeEnd = Math.min(newRangeEnd, this.itemSlots);
        }
        for (int index = newStartIndex; index < newRangeEnd; ++index) {
            int row = index / 12 - newTopRow;
            ((Slot)((BackpackMenu)this.f_97732_).f_38839_.get((int)index)).f_40221_ = yOffsetBase + row * 18;
        }
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private boolean isMouseOverScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 29) && mouseX <= (double)(this.f_97735_ + 263) && mouseY >= (double)(this.f_97736_ + 17) && mouseY <= (double)(this.f_97736_ + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 249) && mouseX <= (double)(this.f_97735_ + 263) && mouseY >= (double)(this.f_97736_ + 17) && mouseY <= (double)(this.f_97736_ + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollThumb(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 249) && mouseX <= (double)(this.f_97735_ + 263) && mouseY >= (double)this.getScrollThumbY() && mouseY <= (double)(this.getScrollThumbY() + 15);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            ModNetwork.sendToServer(new KeyPressedPacket(4, true));
        }
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            ModNetwork.sendToServer(new KeyPressedPacket(4, false));
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264 || keyCode == 267) {
            if (this.topVisibleRow != this.totalRows - this.containerRows) {
                if (BackpackScreen.m_96638_()) {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, Math.min(this.topVisibleRow + this.containerRows, this.totalRows - this.containerRows));
                } else {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, this.topVisibleRow + 1);
                }
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 266) {
            if (this.topVisibleRow != 0) {
                if (BackpackScreen.m_96638_()) {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, Math.max(this.topVisibleRow - this.containerRows, 0));
                } else {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, this.topVisibleRow - 1);
                }
            }
            return true;
        }
        if (KeybindHandler.TOGGLE_BACKPACK_KEY.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            KeybindHandler.handleOpenCloseBackpack();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOverScrollThumb(mouseX, mouseY) && button == 0 && this.isScrollbarRequired()) {
            this.scrollYOffset = (int)mouseY - this.scrollThumbY;
            this.isDragging = true;
        } else if (this.isMouseOverScrollBar(mouseX, mouseY) && button == 0 && this.isScrollbarRequired()) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.f_97736_);
            this.snapThumbToGradation();
        }
        ((BackpackMenu)this.f_97732_).container.setPlayerInteraction(true);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        ((BackpackMenu)this.f_97732_).container.setPlayerInteraction(false);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (super.m_6050_(mouseX, mouseY, deltaY)) {
            return true;
        }
        if (!this.isScrollbarRequired()) {
            return false;
        }
        if (this.isMouseOverScrollArea(mouseX, mouseY)) {
            int newTop = deltaY < 0.0 ? Math.min(this.topVisibleRow + (BackpackScreen.m_96638_() ? this.containerRows : 1), this.totalRows - this.containerRows) : Math.max(this.topVisibleRow - (BackpackScreen.m_96638_() ? this.containerRows : 1), 0);
            this.setTopRowAndMoveThumb(this.topVisibleRow, newTop);
            return true;
        }
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<Rect2i> getExclusionZones() {
        return Arrays.asList(new Rect2i(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new Rect2i(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }

    protected void m_280092_(GuiGraphics pGuiGraphics, Slot pSlot) {
        if (pSlot.f_40219_ > Util.ITEM_SLOT_END_RANGE) {
            super.m_280092_(pGuiGraphics, pSlot);
        } else {
            int x = pSlot.f_40220_;
            int y = pSlot.f_40221_;
            ItemStack itemStack = pSlot.m_7993_();
            pGuiGraphics.m_280256_(itemStack, x, y, pSlot.f_40220_ + pSlot.f_40221_ * this.f_97726_);
            if (!itemStack.m_41619_()) {
                if (itemStack.m_41613_() != 1) {
                    String countText = String.valueOf(itemStack.m_41613_());
                    PoseStack poseStack = pGuiGraphics.m_280168_();
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, 0.0, 200.0);
                    float scale = Math.min(1.0f, 16.0f / (float)this.f_96547_.m_92895_(countText));
                    if (scale < 1.0f) {
                        poseStack.m_85841_(scale, scale, 1.0f);
                    }
                    pGuiGraphics.drawString(this.f_96547_, countText, ((float)(x + 19 - 2) - (float)this.f_96547_.m_92895_(countText) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true);
                    poseStack.m_85849_();
                }
                if (itemStack.m_150947_()) {
                    int l = itemStack.m_150948_();
                    int i = itemStack.m_150949_();
                    int j = x + 2;
                    int k = y + 13;
                    pGuiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + 13, k + 2, -16777216);
                    pGuiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + l, k + 1, i | 0xFF000000);
                }
            }
        }
    }
}

