/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.recipe;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BackpackRecipe
extends ShapedRecipe {
    private ItemStack craftingStack;

    public BackpackRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, CraftingBookCategory.MISC, width, height, recipeItems, result);
    }

    public boolean m_5818_(CraftingContainer inv, @NotNull Level level) {
        ItemStack[] items;
        for (ItemStack itemStack : items = inv.m_280657_().toArray(new ItemStack[0])) {
            if (!(itemStack.m_41720_() instanceof BackpackItem)) continue;
            this.craftingStack = itemStack;
            break;
        }
        return super.m_5818_(inv, level);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BACKPACK_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        ItemStack craftedStack = super.m_8043_(registryAccess);
        if (this.craftingStack == null) {
            return craftedStack;
        }
        if (this.craftingStack.m_41782_()) {
            craftedStack.m_41751_(this.craftingStack.m_41783_());
            CompoundTag entityTag = craftedStack.m_41698_("BlockEntityTag");
            if (entityTag.m_128441_("StackMultiplier")) {
                int newMaxStackSize = entityTag.m_128451_("StackMultiplier");
                if (craftedStack.m_41720_().equals(ModBlocks.ANDESITE_BACKPACK.m_5456_())) {
                    newMaxStackSize = 4;
                } else if (craftedStack.m_41720_().equals(ModBlocks.COPPER_BACKPACK.m_5456_())) {
                    newMaxStackSize = 8;
                } else if (craftedStack.m_41720_().equals(ModBlocks.BRASS_BACKPACK.m_5456_())) {
                    newMaxStackSize = 16;
                } else if (craftedStack.m_41720_().equals(ModBlocks.HARDENED_BACKPACK.m_5456_())) {
                    newMaxStackSize = 32;
                }
                entityTag.m_128405_("StackMultiplier", newMaxStackSize);
            }
        }
        return craftedStack;
    }

    private static BackpackRecipe fromShaped(ShapedRecipe recipe) {
        return new BackpackRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(null));
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        @NotNull
        public BackpackRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return BackpackRecipe.fromShaped(super.m_6729_(recipeId, json));
        }

        @NotNull
        public BackpackRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return BackpackRecipe.fromShaped(Objects.requireNonNull(super.m_8005_(recipeId, buffer)));
        }

        public void m_6178_(@NotNull FriendlyByteBuf pBuffer, @NotNull ShapedRecipe pRecipe) {
            super.m_6178_(pBuffer, pRecipe);
        }
    }
}

