/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.tooltip;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BackpackClientTooltip
implements ClientTooltipComponent {
    private static final int ICONS_PER_ROW = 9;
    private static final int ICON_SIZE = 18;
    private final BackpackTooltip component;
    private final int width;
    private final int height;

    public BackpackClientTooltip(BackpackTooltip tooltip) {
        this.component = tooltip;
        this.width = this.calculateWidth();
        this.height = this.calculateHeight();
    }

    private int calculateWidth() {
        Minecraft mc = Minecraft.m_91087_();
        int upgradesWidth = this.component.upgrades.size() * 18;
        int contentsWidth = this.component.storage.stream().limit(9L).mapToInt(stack -> Math.max(this.getStackCountWidth(mc.f_91062_, (ItemStack)stack), 18)).sum();
        int tooltipTextWidth = this.component.tooltipText.stream().mapToInt(text -> mc.f_91062_.m_92724_(text.m_7532_())).max().orElse(0);
        return Math.max(Math.max(upgradesWidth, contentsWidth), tooltipTextWidth);
    }

    private int calculateHeight() {
        int upgradesHeight = this.component.upgrades.isEmpty() ? 0 : 32;
        int storageRows = (this.component.storage.size() + 9 - 1) / 9;
        int inventoryHeight = this.component.storage.isEmpty() ? 0 : 12 + storageRows * 20;
        int textHeight = this.component.tooltipText.size() * 10;
        return Math.max(upgradesHeight + inventoryHeight + textHeight, 12);
    }

    public int m_142103_() {
        return this.height;
    }

    public int m_142069_(@NotNull Font font) {
        return this.width;
    }

    public void m_183452_(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
        for (Component line : this.component.tooltipText) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, line);
        }
        this.renderContents(pFont, pX, pY, pGuiGraphics);
    }

    private void renderContents(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        if (!this.component.upgrades.isEmpty()) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, (Component)Component.m_237113_((String)"Upgrades:").m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight()));
            pY = this.renderItemList(pFont, pX, pY, pGuiGraphics, this.component.upgrades, false);
        }
        if (!this.component.storage.isEmpty()) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, (Component)Component.m_237113_((String)"Inventory:").m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight()));
            this.renderItemList(pFont, pX, pY, pGuiGraphics, this.component.storage, true);
        }
    }

    private int renderItemList(Font font, int xStart, int yStart, GuiGraphics guiGraphics, List<ItemStack> items, boolean multiline) {
        int x = xStart;
        int y = yStart;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (multiline && i > 0 && i % 9 == 0) {
                x = xStart;
                y += 20;
            }
            int stackWidth = Math.max(this.getStackCountWidth(font, stack), 18);
            int xOffset = stackWidth - 18;
            guiGraphics.m_280480_(stack, x + xOffset, y);
            if (stack.m_41613_() > 1) {
                guiGraphics.m_280302_(font, stack, x + xOffset, y, this.formatNumber(stack.m_41613_()));
            }
            x += multiline ? stackWidth : 18;
        }
        return multiline ? y + 20 : y + (items.isEmpty() ? 0 : 20);
    }

    private int getStackCountWidth(Font font, ItemStack stack) {
        return font.m_92895_(this.formatNumber(stack.m_41613_())) + 2;
    }

    private int renderTooltipText(GuiGraphics guiGraphics, int x, int y, Font font, Component tooltip) {
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 200.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_(tooltip, (float)x, (float)y, 0xFFFFFF, true, pose.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        pose.m_85849_();
        return y + 10;
    }

    private String formatNumber(int number) {
        if (number < 1000) {
            return String.valueOf(number);
        }
        if (number < 1000000) {
            return String.format("%.1fk", (double)number / 1000.0);
        }
        return String.format("%.2fM", (double)number / 1000000.0);
    }
}

