/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.PickBlockHandler;
import net.fxnt.fxntstorage.backpack.upgrade.ToolSwapHandler;
import net.fxnt.fxntstorage.backpack.upgrade.TorchDeployerManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BackpackOnBackUpgradeHandler {
    public Player player;
    private final BackpackHelper helper;
    private final ItemStack itemStack;

    public BackpackOnBackUpgradeHandler(Player player) {
        this.player = player;
        this.helper = new BackpackHelper();
        this.itemStack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
    }

    public boolean hasUpgrade(String upgradeName) {
        if (this.itemStack.m_41619_()) {
            return false;
        }
        CompoundTag tag = this.itemStack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("Upgrades")) {
            ListTag upgradesList = tag.m_128437_("Upgrades", 8);
            for (Tag upgrade : upgradesList) {
                if (!upgrade.m_7916_().equals(upgradeName)) continue;
                return true;
            }
        }
        return false;
    }

    private IBackpackContainer getContainer() {
        AbstractContainerMenu abstractContainerMenu = this.player.f_36096_;
        if (abstractContainerMenu instanceof BackpackMenu) {
            BackpackMenu backPackMenu = (BackpackMenu)abstractContainerMenu;
            if (backPackMenu.backpackType == 1) {
                return backPackMenu.container;
            }
        }
        return new BackpackContainer(this.itemStack, this.player);
    }

    public void applyMagnetUpgrade() {
        if (this.itemStack.m_41619_() || this.player.m_9236_().f_46443_ || !this.hasUpgrade("backpack_magnet_upgrade")) {
            return;
        }
        AABB boundingBox = new AABB(this.player.m_20183_()).m_82400_((double)((Integer)ConfigManager.CommonConfig.BACKPACK_MAGNET_RANGE.get()).intValue());
        List nearbyItems = this.player.m_9236_().m_45976_(ItemEntity.class, boundingBox);
        if (!nearbyItems.isEmpty()) {
            for (ItemEntity itemEntity : nearbyItems) {
                CompoundTag processing;
                CompoundTag createData;
                CompoundTag nbt;
                CompoundTag pd;
                if (itemEntity.m_32055_().m_41720_() instanceof BackpackItem || (pd = this.player.getPersistentData().m_128469_("fxntstorageSettings")).m_128441_("IgnoreFanProcessing") && pd.m_128471_("IgnoreFanProcessing") && (nbt = itemEntity.getPersistentData().m_128469_("fxntstorageSettings")).m_128441_("CreateData") && (createData = nbt.m_128469_("CreateData")).m_128441_("Processing") && (processing = createData.m_128469_("Processing")).m_128441_("Time") && processing.m_128451_("Time") > 0) continue;
                this.helper.itemEntityToBackpack(this.getContainer(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE);
                this.player.m_7938_((Entity)itemEntity, itemEntity.m_32055_().m_41613_());
            }
        }
    }

    public boolean applyItemPickupUpgrade(ItemEntity itemEntity, UUID target, int pickupDelay) {
        if (this.itemStack.m_41619_() || this.player.m_9236_().f_46443_ || !this.hasUpgrade("backpack_itempickup_upgrade") || this.hasUpgrade("backpack_magnet_upgrade")) {
            return false;
        }
        ItemStack itemStack = itemEntity.m_32055_();
        Item item = itemStack.m_41720_();
        int i = itemStack.m_41613_();
        if (pickupDelay == 0 && (target == null || target.equals(this.player.m_20148_())) && this.helper.itemEntityToBackpack(this.getContainer(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE)) {
            this.player.m_7938_((Entity)itemEntity, i);
            if (itemStack.m_41619_()) {
                itemEntity.m_146870_();
                itemStack.m_41764_(i);
            }
            this.player.m_6278_(Stats.f_12984_.m_12902_((Object)item), i);
            this.player.m_21053_(itemEntity);
            return true;
        }
        return false;
    }

    public void applyPickBlockUpgrade(ItemStack pickedStack) {
        if (this.itemStack.m_41619_() || this.player.m_9236_().f_46443_ || !this.hasUpgrade("backpack_pickblock_upgrade")) {
            return;
        }
        PickBlockHandler.pickBlockHandler(this.player, this.getContainer(), pickedStack);
    }

    public void applyFeederUpgrade() {
        if (this.itemStack.m_41619_() || this.player.m_9236_().f_46443_ || !this.hasUpgrade("backpack_feeder_upgrade")) {
            return;
        }
        boolean doFeed = this.isDoFeed();
        if (doFeed) {
            IBackpackContainer container = this.getContainer();
            ItemStackHandler itemHandler = container.getItemHandler();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack food = itemHandler.getStackInSlot(i);
                if (!food.m_41614_() || this.hasNegativeEffects(food)) continue;
                String foodName = food.m_41720_().m_7626_(food).getString();
                ItemStack mainHandItem = this.player.m_21205_();
                this.player.m_150109_().f_35974_.set(this.player.m_150109_().f_35977_, (Object)food);
                ItemStack singleItem = food.m_255036_(1);
                if (singleItem.m_41682_(this.player.m_9236_(), this.player, InteractionHand.MAIN_HAND).m_19089_() == InteractionResult.CONSUME) {
                    this.player.m_150109_().f_35974_.set(this.player.m_150109_().f_35977_, (Object)mainHandItem);
                    food.m_41774_(1);
                    itemHandler.setStackInSlot(i, food);
                    ItemStack remainder = ForgeEventFactory.onItemUseFinish((LivingEntity)this.player, (ItemStack)singleItem.m_41777_(), (int)0, (ItemStack)singleItem.m_41720_().m_5922_(singleItem, this.player.m_9236_(), (LivingEntity)this.player));
                    if (!remainder.m_41619_()) {
                        boolean itemPlaced = false;
                        int firstEmptyStack = -1;
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            ItemStack stack = itemHandler.getStackInSlot(j);
                            if (stack.m_41619_() && firstEmptyStack < 0) {
                                firstEmptyStack = j;
                            }
                            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)remainder) || stack.m_41613_() >= container.getStackMultiplier() * remainder.m_41741_()) continue;
                            ItemStack insertResult = itemHandler.insertItem(j, remainder, false);
                            if (!insertResult.m_41619_()) {
                                this.player.m_36176_(remainder, true);
                            }
                            itemPlaced = true;
                            break;
                        }
                        if (!itemPlaced && firstEmptyStack > -1) {
                            itemHandler.insertItem(firstEmptyStack, remainder, false);
                        }
                    }
                    container.setDataChanged();
                    if (this.player.getPersistentData().m_128469_("fxntstorageSettings").m_128471_("DisplayFeederMessage")) {
                        String foodNameFormatted = (Util.isVowel(foodName.charAt(0)) ? "an" : "a") + " \u00a7a" + foodName + "\u00a7r";
                        this.player.m_5661_((Component)Component.m_237110_((String)"item.fxntstorage.backpack_feeder_upgrade.message", (Object[])new Object[]{foodNameFormatted}), true);
                    }
                } else {
                    this.player.m_150109_().f_35974_.set(this.player.m_150109_().f_35977_, (Object)mainHandItem);
                }
                return;
            }
        }
    }

    private boolean hasNegativeEffects(@NotNull ItemStack food) {
        Iterator iterator;
        FoodProperties foodProperties = food.getFoodProperties((LivingEntity)this.player);
        if (foodProperties == null) {
            return false;
        }
        if (food.m_150930_(Items.f_42730_) && !((Boolean)ConfigManager.ClientConfig.ALLOW_CHORUS_FRUIT.get()).booleanValue()) {
            return true;
        }
        CompoundTag tag = food.m_41783_();
        if (tag != null && tag.m_128425_("Effects", 9)) {
            ListTag effects = tag.m_128437_("Effects", 10);
            for (Tag entry : effects) {
                String effectString;
                ResourceLocation effectId;
                MobEffect effect;
                CompoundTag effectTag;
                if (!(entry instanceof CompoundTag) || !(effectTag = (CompoundTag)entry).m_128425_("forge:effect_id", 8) || (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId = ResourceLocation.parse((String)(effectString = effectTag.m_128461_("forge:effect_id"))))) == null) continue;
                return effect.m_19483_().equals((Object)MobEffectCategory.HARMFUL);
            }
        }
        if ((iterator = foodProperties.m_38749_().iterator()).hasNext()) {
            Pair effect = (Pair)iterator.next();
            return ((MobEffectInstance)effect.getFirst()).m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL);
        }
        return false;
    }

    private boolean isDoFeed() {
        boolean doFeed = false;
        int hunger = this.player.m_36324_().m_38702_();
        float saturation = this.player.m_36324_().m_38722_();
        float health = this.player.m_21223_();
        if (health < this.player.m_21233_() && hunger < 18 && saturation < 2.0f) {
            doFeed = true;
        }
        if (hunger < 6) {
            doFeed = true;
        }
        return doFeed;
    }

    public void applyRefillUpgrade() {
        if (this.itemStack.m_41619_() || this.player.m_9236_().f_46443_ || !this.hasUpgrade("backpack_refill_upgrade")) {
            return;
        }
        this.refillHand(this.player.m_21205_(), false);
        this.refillHand(this.player.m_21206_(), true);
    }

    private void refillHand(@NotNull ItemStack handItem, boolean isOffHand) {
        if (handItem.m_41619_()) {
            return;
        }
        int requiredItems = handItem.m_41741_() - handItem.m_41613_();
        if (requiredItems > 0) {
            int offHandSlotIndex = 40;
            int ignorePlayerSlot = isOffHand ? offHandSlotIndex : this.player.m_150109_().f_35977_;
            boolean success = this.refillMatchingItem(handItem, requiredItems, this.player, this.getContainer(), 0, this.player.m_150109_().m_6643_(), ignorePlayerSlot);
            if (!success) {
                this.refillMatchingItem(handItem, requiredItems, null, this.getContainer(), 0, Util.ITEM_SLOT_END_RANGE, -1);
            }
        }
    }

    private boolean refillMatchingItem(ItemStack itemStack, int requiredItems, Player player, IBackpackContainer container, int startIndex, int endIndex, int ignoreSlot) {
        block6: {
            int amountToPlace;
            block5: {
                amountToPlace = requiredItems;
                if (player == null) break block5;
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack inventoryItem;
                    if (i == ignoreSlot || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)(inventoryItem = inventory.m_8020_(i)))) continue;
                    if (inventoryItem.m_41613_() < requiredItems) {
                        amountToPlace = inventoryItem.m_41613_();
                    }
                    ItemStack itemToTransfer = inventoryItem.m_41777_();
                    itemToTransfer.m_41764_(amountToPlace);
                    inventoryItem.m_41774_(amountToPlace);
                    itemStack.m_41769_(amountToPlace);
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (abstractContainerMenu instanceof BackpackMenu) {
                        BackpackMenu backpackMenu = (BackpackMenu)abstractContainerMenu;
                        backpackMenu.container.setDataChanged();
                    }
                    return true;
                }
                break block6;
            }
            ItemStackHandler itemHandler = container.getItemHandler();
            if (itemHandler == null) break block6;
            for (int i = startIndex; i < endIndex; ++i) {
                ItemStack containerItem;
                if (i == ignoreSlot || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)(containerItem = itemHandler.getStackInSlot(i)))) continue;
                if (containerItem.m_41613_() < requiredItems) {
                    amountToPlace = containerItem.m_41613_();
                }
                ItemStack itemToTransfer = containerItem.m_41777_();
                itemToTransfer.m_41764_(amountToPlace);
                itemHandler.extractItem(i, amountToPlace, false);
                itemStack.m_41769_(amountToPlace);
                container.setDataChanged();
                return true;
            }
        }
        return false;
    }

    public boolean applyFallDamageUpgrade() {
        return !this.itemStack.m_41619_() && !this.player.m_9236_().f_46443_ && this.hasUpgrade("backpack_falldamage_upgrade");
    }

    public void fromAttackBlockEvent(Player player, Level level, InteractionHand hand, BlockPos pos) {
        if (this.itemStack.m_41619_() || hand != InteractionHand.OFF_HAND && player.m_5833_() || level.f_46443_ || !player.m_6084_() || player.m_5803_() || player.m_21224_() || !this.hasUpgrade("backpack_toolswap_upgrade") || player.m_21205_().m_150930_(AllItems.WRENCH.m_5456_())) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(pos, null);
    }

    public void fromAttackEntityEvent(Player player, Level level, InteractionHand hand, LivingEntity entity) {
        if (this.itemStack.m_41619_() || hand != InteractionHand.OFF_HAND && player.m_5833_() || level.f_46443_ || !player.m_6084_() || player.m_5803_() || player.m_21224_() || !this.hasUpgrade("backpack_toolswap_upgrade") || player.m_21205_().m_150930_(AllItems.WRENCH.m_5456_())) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(null, entity);
    }

    public void applyOreMiningUpgrade(Level level, BlockPos origin, Player player, boolean mineAllBlocks, int maxBlocks) {
        BlockState targetState = level.m_8055_(origin);
        List<BlockPos> vein = this.findVein(level, origin, targetState, mineAllBlocks, maxBlocks);
        ArrayList drops = new ArrayList();
        ItemStack tool = player.m_21205_();
        int blocksMined = 0;
        for (BlockPos blockPos : vein) {
            if (tool.m_41619_()) break;
            BlockState state = level.m_8055_(blockPos);
            if (level.m_46859_(blockPos)) continue;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287286_(LootContextParams.f_81461_, (Object)state).m_287289_(LootContextParams.f_81455_, (Object)player).m_287289_(LootContextParams.f_81462_, (Object)blockEntity);
            List blockDrops = state.m_287290_(lootParams);
            drops.addAll(blockDrops);
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            state.onDestroyedByPlayer(level, blockPos, player, true, level.m_6425_(blockPos));
            if (state.m_60800_((BlockGetter)level, blockPos) >= 0.0f) {
                tool.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
                if (!player.m_150110_().f_35937_) {
                    player.m_36399_(0.2f);
                }
            }
            ++blocksMined;
        }
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (stack.m_41619_()) continue;
            boolean merged = false;
            for (ItemStack existing : condensed) {
                int transferable;
                if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack) || !existing.m_41753_() || (transferable = Math.min(stack.m_41613_(), existing.m_41741_() - existing.m_41613_())) <= 0) continue;
                existing.m_41769_(transferable);
                stack.m_41774_(transferable);
                if (!stack.m_41619_()) continue;
                merged = true;
                break;
            }
            if (merged || stack.m_41619_()) continue;
            condensed.add(stack.m_41777_());
        }
        for (ItemStack drop : condensed) {
            Block.m_49840_((Level)level, (BlockPos)origin, (ItemStack)drop);
        }
        if (!FMLEnvironment.production) {
            MutableComponent mutableComponent = Component.m_237113_((String)("Successfully mined \u00a7a" + blocksMined + "\u00a7r out of \u00a7a" + vein.size() + "\u00a7r"));
            player.m_5661_((Component)mutableComponent, false);
        }
    }

    private List<BlockPos> findVein(Level level, BlockPos start, BlockState targetState, boolean mineAllBlocks, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        toVisit.add(start);
        while (!toVisit.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (!visited.add(current)) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockState neighborState;
                        BlockPos neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = current.m_7918_(dx, dy, dz)) || !(neighborState = level.m_8055_(neighbor)).m_60734_().equals(targetState.m_60734_()) || !mineAllBlocks && !neighborState.m_204336_(ModTags.Blocks.ORE_MINING_BLOCK)) continue;
                        toVisit.add(neighbor);
                    }
                }
            }
        }
        return visited.stream().sorted(Comparator.comparingDouble(blockPos -> blockPos.m_123331_((Vec3i)this.player.m_20183_()))).toList();
    }

    public void applyTorchDeployerUpgrade(Player player) {
        int blockLightLevel;
        ConfigManager.ClientConfig.TorchDeployerLightSource lightSource;
        BlockPos playerPos = player.m_20183_();
        BlockPos belowPos = playerPos.m_7495_();
        Level level = player.m_9236_();
        int lightLevel = player.getPersistentData().m_128469_("fxntstorageSettings").m_128451_("TorchDeployerLightLevel");
        int cooldown = player.getPersistentData().m_128469_("fxntstorageSettings").m_128451_("TorchDeployerCooldown");
        String sourceValue = player.getPersistentData().m_128469_("fxntstorageSettings").m_128461_("TorchDeployerLightSource");
        try {
            lightSource = ConfigManager.ClientConfig.TorchDeployerLightSource.valueOf(sourceValue.isEmpty() ? "BLOCK_LIGHT" : sourceValue);
        }
        catch (IllegalArgumentException e) {
            lightSource = ConfigManager.ClientConfig.TorchDeployerLightSource.BLOCK_LIGHT;
        }
        int n = blockLightLevel = lightSource == ConfigManager.ClientConfig.TorchDeployerLightSource.SKY_LIGHT ? level.m_45517_(LightLayer.BLOCK, playerPos) : level.m_46803_(playerPos);
        if (blockLightLevel <= lightLevel && level.m_8055_(belowPos).m_280296_() && level.m_8055_(playerPos).m_60795_()) {
            if (!TorchDeployerManager.canPlaceTorch(player, cooldown)) {
                return;
            }
            IBackpackContainer container = this.getContainer();
            ItemStackHandler itemHandler = container.getItemHandler();
            for (int slot = 0; slot < Util.ITEM_SLOT_END_RANGE; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.m_150930_(Items.f_42000_)) continue;
                stack.m_41774_(1);
                itemHandler.setStackInSlot(slot, stack);
                level.m_7731_(playerPos, Blocks.f_50081_.m_49966_(), 3);
                level.m_247517_(null, playerPos, SoundEvents.f_12635_, SoundSource.BLOCKS);
                container.setDataChanged();
                if (FMLEnvironment.production) break;
                player.m_5661_((Component)Component.m_237113_((String)("Placed \u00a7a1\u00a7r torch with \u00a7a" + stack.m_41613_() + "\u00a7r left in the stack")), false);
                break;
            }
        }
    }
}

