/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackOnBackUpgradeHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.fxnt.fxntstorage.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class JetpackHandler {
    private static final int MAX_ALLOWED_HEIGHT = 32;
    private static final double GRAVITY = -0.44;
    private static final long FUEL_SYNC_INTERVAL = 1000L;
    private static final long MAX_INTERPOLATION_TIME = 200L;
    private static final int MAX_MISSED_PACKETS = 5;
    private final Player player;
    private double hoverHeight = 0.0;
    private float jetPackFuelRemaining;
    private long lastRuntime = 0L;
    private long airGaugeLastCleared = 0L;
    private boolean airGaugeCleared = false;
    private boolean isJumping = false;
    private boolean isHovering = false;
    private float forward = 0.0f;
    private float left = 0.0f;
    private boolean playedSoundThisJump = false;
    private float predictedFuelRemaining;
    private long lastFuelSync = 0L;
    private Vec3 lastValidVelocity = Vec3.f_82478_;
    private long lastServerUpdate = 0L;
    private double lastKnownY = 0.0;
    private static final double TELEPORT_THRESHOLD = 5.0;
    private long lastPacketTime = 0L;
    private int missedPackets = 0;

    public JetpackHandler(Player player) {
        this.player = player;
    }

    public void execute() {
        if (this.player == null) {
            return;
        }
        if (this.player.m_9236_().f_46443_) {
            this.executeClient();
        } else {
            this.executeServer();
        }
    }

    private void executeClient() {
        this.updatePredictedFuel();
        if (this.isHovering && this.wasTeleported()) {
            this.hoverHeight = this.player.m_20186_();
        }
        if (this.isJumping) {
            if (this.predictedFuelRemaining <= 0.0f) {
                this.endHovering(false);
                return;
            }
            this.player.m_20242_(true);
            this.player.m_183634_();
            if (this.player.m_6144_()) {
                this.startHovering(true);
            } else if (this.isHovering) {
                this.endHovering(true);
            }
            this.updateClientMovementWithInterpolation();
            if (this.player.m_20096_() && this.isHovering) {
                this.endHovering(true);
            }
            if (!this.player.m_20069_() && !this.player.m_20077_()) {
                this.handleThrustSound();
            }
        } else {
            boolean bl = this.playedSoundThisJump = !this.player.m_20096_();
            if (this.isHovering) {
                if (this.player.m_20096_()) {
                    this.endHovering(true);
                }
                if (this.predictedFuelRemaining <= 0.0f) {
                    this.endHovering(false);
                    return;
                }
                this.updateClientMovementWithInterpolation();
            } else {
                this.player.m_20242_(false);
                this.fadeOutVisualAirOverlay();
            }
        }
    }

    private void executeServer() {
        if (this.isHovering && this.wasTeleported()) {
            this.hoverHeight = this.player.m_20186_();
        }
        this.jetPackFuelRemaining = (float)this.calculateJetPackFuel(this.player);
        if (this.isJumping || this.isHovering && this.jetPackFuelRemaining > 0.0f) {
            this.depleteJetPackFuel(this.player);
            this.validatePlayerMovement();
            this.player.m_183634_();
            if (this.player.f_19797_ % 5 == 0) {
                this.validateAndCorrectPosition();
            }
            if (BackpackHelper.isWearingBackpack(this.player, true)) {
                ParticleHelper.jetPackParticles(this.player);
            }
        } else if (this.isHovering && this.jetPackFuelRemaining <= 0.0f) {
            this.endHovering(false);
        }
        this.syncFuelToClient();
        this.fadeOutVisualAirOverlay();
    }

    private boolean wasTeleported() {
        double yDifference = Math.abs(this.player.m_20186_() - this.lastKnownY);
        boolean teleported = yDifference > 5.0 && this.lastKnownY != 0.0;
        this.lastKnownY = this.player.m_20186_();
        return teleported;
    }

    private void updatePredictedFuel() {
        long currentTime = this.player.m_9236_().m_46467_();
        if (this.lastFuelSync == 0L || currentTime - this.lastFuelSync > 2000L) {
            this.predictedFuelRemaining = this.jetPackFuelRemaining;
        } else if (this.isJumping) {
            long timeSinceSync = currentTime - this.lastFuelSync;
            float estimatedConsumption = (float)((double)timeSinceSync / 1000.0);
            this.predictedFuelRemaining = Math.max(this.jetPackFuelRemaining - estimatedConsumption, 0.0f);
        }
    }

    public void onFuelSync(float serverFuel, long serverTime) {
        this.jetPackFuelRemaining = serverFuel;
        this.predictedFuelRemaining = serverFuel;
        this.lastFuelSync = this.player.m_9236_().m_46467_();
        long clientTime = this.player.m_9236_().m_46467_();
        long estimatedLatency = Math.max(0L, clientTime - serverTime);
        if (this.isJumping && estimatedLatency > 0L) {
            float latencyConsumption = (float)estimatedLatency / 1000.0f;
            this.predictedFuelRemaining = Math.max(serverFuel - latencyConsumption, 0.0f);
        }
        this.missedPackets = 0;
        this.lastPacketTime = clientTime;
    }

    private void validatePlayerMovement() {
        Vec3 velocity = this.player.m_20184_();
        double maxHorizontalSpeed = 2.0;
        double maxVerticalSpeed = 1.0;
        boolean needsCorrection = false;
        double newX = velocity.f_82479_;
        double newY = velocity.f_82480_;
        double newZ = velocity.f_82481_;
        double horizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
        if (horizontalSpeed > maxHorizontalSpeed) {
            double scale = maxHorizontalSpeed / horizontalSpeed;
            newX *= scale;
            newZ *= scale;
            needsCorrection = true;
        }
        if (Math.abs(velocity.f_82480_) > maxVerticalSpeed) {
            newY = Math.copySign(maxVerticalSpeed, velocity.f_82480_);
            needsCorrection = true;
        }
        if (needsCorrection) {
            this.player.m_20334_(newX, newY, newZ);
        }
    }

    private void validateAndCorrectPosition() {
        double distanceToGround = JetpackHandler.getDistanceToGround(this.player);
        if (distanceToGround > 37.0) {
            Vec3 velocity = this.player.m_20184_();
            this.player.m_20334_(velocity.f_82479_, Math.min(velocity.f_82480_, -0.1), velocity.f_82481_);
        }
    }

    private void handleThrustSound() {
        if (this.player.m_20096_()) {
            this.playedSoundThisJump = false;
        } else if (!this.playedSoundThisJump) {
            if (this.player.m_9236_().f_46443_) {
                this.player.m_9236_().m_7785_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), AllSoundEvents.STEAM.getMainEvent(), SoundSource.PLAYERS, 0.1f, 1.0f, false);
            }
            this.playedSoundThisJump = true;
        }
    }

    public void fadeOutVisualAirOverlay() {
        if (this.player.m_20096_() && !this.airGaugeCleared) {
            long currentTime;
            if (this.airGaugeLastCleared == 0L) {
                this.airGaugeLastCleared = this.player.m_9236_().m_46467_();
            }
            if ((currentTime = this.player.m_9236_().m_46467_()) - this.airGaugeLastCleared >= 25L) {
                if (!this.player.m_9236_().f_46443_) {
                    ModNetwork.sendToPlayer((ServerPlayer)this.player, new VisualJetpackAirPacket(-1));
                }
                this.airGaugeCleared = true;
            }
        } else if (!this.player.m_20096_() || !this.isJumping && !this.isHovering) {
            this.airGaugeLastCleared = 0L;
        }
    }

    private static double getDistanceToGround(@NotNull Player player) {
        Vec3 start = player.m_20182_();
        Vec3 end = start.m_82520_(0.0, (double)(-player.m_146904_() - 256), 0.0);
        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return start.f_82480_ - hitResult.m_82450_().f_82480_;
        }
        return (Boolean)ConfigManager.CommonConfig.JETPACK_ALLOW_VOID_FLIGHT.get() != false ? -1.0 : Double.MAX_VALUE;
    }

    public void toggleHover() {
        if (this.player.m_20096_()) {
            this.endHovering(false);
            return;
        }
        if (!this.isHovering) {
            this.startHovering(true);
        } else {
            this.player.m_20242_(false);
            this.endHovering(true);
        }
    }

    public void startHovering(boolean announce) {
        this.isHovering = true;
        this.hoverHeight = this.player.m_20186_();
        if (announce) {
            this.displayHoverMessage(true);
        }
    }

    public void endHovering(boolean announce) {
        this.isHovering = false;
        this.hoverHeight = 0.0;
        if (announce) {
            this.displayHoverMessage(false);
        }
        if (this.player.m_20096_()) {
            this.airGaugeLastCleared = 0L;
        }
    }

    private void displayHoverMessage(boolean isStarting) {
        boolean isElytraBoost;
        boolean bl = isElytraBoost = this.player.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(Items.f_42741_) && this.player.m_21255_() && (Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get() != false;
        String messageKey = isStarting ? (isElytraBoost ? "item.fxntstorage.jetpack.elytra_boost_enabled" : "item.fxntstorage.jetpack.hover_enabled") : (isElytraBoost ? "item.fxntstorage.jetpack.elytra_boost_disabled" : "item.fxntstorage.jetpack.hover_disabled");
        this.player.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void updateClientMovementWithInterpolation() {
        long currentTime = this.player.m_9236_().m_46467_();
        if (this.lastPacketTime > 0L && currentTime - this.lastPacketTime > 100L) {
            ++this.missedPackets;
        }
        Vec3 calculatedVelocity = this.calculateMovementVelocity();
        if (this.shouldUseInterpolation()) {
            calculatedVelocity = this.applyVelocityInterpolation(calculatedVelocity);
        }
        this.applyVelocityToPlayer(calculatedVelocity);
    }

    private boolean shouldUseInterpolation() {
        long timeSinceServerUpdate = this.player.m_9236_().m_46467_() - this.lastServerUpdate;
        return timeSinceServerUpdate < 200L && this.missedPackets < 5 && !this.lastValidVelocity.equals((Object)Vec3.f_82478_);
    }

    private Vec3 applyVelocityInterpolation(Vec3 calculatedVelocity) {
        long currentTime = this.player.m_9236_().m_46467_();
        long timeSinceUpdate = currentTime - this.lastServerUpdate;
        if (timeSinceUpdate < 200L) {
            float interpolationAlpha = Math.min(1.0f, (float)timeSinceUpdate / 200.0f);
            Vec3 interpolatedVelocity = this.lastValidVelocity.m_165921_(calculatedVelocity, (double)interpolationAlpha);
            double velocityDifference = calculatedVelocity.m_82554_(this.lastValidVelocity);
            if (velocityDifference > 0.5) {
                float smoothingFactor = Math.min(0.3f, 1.0f / (float)(this.missedPackets + 1));
                return this.lastValidVelocity.m_165921_(calculatedVelocity, (double)smoothingFactor);
            }
            return interpolatedVelocity;
        }
        return calculatedVelocity;
    }

    private Vec3 calculateMovementVelocity() {
        Vec3 lookVec = this.player.m_20154_();
        Vec3 flatLookDirection = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_);
        Vec3 strafeDirection = flatLookDirection.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double forwardWeight = this.isHovering ? 1.0 : 1.5;
        double leftWeight = this.isHovering ? 0.2 : 0.6;
        Vec3 movementDirection = flatLookDirection.m_82490_((double)this.forward * forwardWeight).m_82549_(strafeDirection.m_82490_((double)this.left * leftWeight));
        double acceleration = this.isHovering ? 0.005 : 0.25;
        double horizontalSpeed = this.calculateHorizontalSpeed();
        Vec3 horizontalVelocity = this.applyMovementPhysics(this.player.m_20184_(), movementDirection.m_82541_(), acceleration, horizontalSpeed);
        double verticalSpeed = this.isHovering ? this.calculateVerticalHoveringSpeed(this.hoverHeight) : this.calculateVerticalSpeed();
        return new Vec3(horizontalVelocity.f_82479_, verticalSpeed, horizontalVelocity.f_82481_);
    }

    private void applyVelocityToPlayer(Vec3 velocity) {
        float fuelToCheck = this.player.m_9236_().f_46443_ ? this.predictedFuelRemaining : this.jetPackFuelRemaining;
        double distanceToGround = JetpackHandler.getDistanceToGround(this.player);
        if ((fuelToCheck < 10.0f || distanceToGround > 32.0) && this.isJumping) {
            velocity = new Vec3(velocity.f_82479_, Mth.m_14139_((double)velocity.f_82480_, (double)-0.044, (double)0.5), velocity.f_82481_);
        }
        if (!this.player.m_9236_().f_46443_) {
            this.lastValidVelocity = velocity;
            this.lastServerUpdate = this.player.m_9236_().m_46467_();
        }
        if (this.player.m_6069_() && this.isJumping) {
            Vec3 lookDirection = this.player.m_20154_();
            Vec3 deltaMovement = this.player.m_20184_();
            this.player.m_20334_(deltaMovement.f_82479_ + lookDirection.f_82479_ * 0.08, deltaMovement.f_82480_ + lookDirection.f_82480_ * 0.08, deltaMovement.f_82481_ + lookDirection.f_82481_ * 0.08);
        } else if (this.player.m_21255_() && ((Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get()).booleanValue()) {
            this.applyElytraBoost();
        } else {
            this.player.m_20256_(velocity);
        }
    }

    private void applyElytraBoost() {
        Vec3 motion = this.player.m_20184_();
        Vec3 look = this.player.m_20154_();
        double horizontalBoost = 0.12;
        double verticalBoost = 0.1;
        double newX = motion.f_82479_ + look.f_82479_ * horizontalBoost;
        double newY = motion.f_82480_ + look.f_82480_ * verticalBoost;
        double newZ = motion.f_82481_ + look.f_82481_ * horizontalBoost;
        double maxSpeed = (Double)ConfigManager.CommonConfig.ELYTRA_BOOST_SPEED_MULTIPLIER.get();
        Vec3 newMotion = new Vec3(newX, newY, newZ);
        if (newMotion.m_82553_() > maxSpeed) {
            newMotion = newMotion.m_82541_().m_82490_(maxSpeed);
        }
        this.player.m_20256_(newMotion);
    }

    private void syncFuelToClient() {
        if (this.player.f_19797_ % 20 != 0) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)this.player;
        int totalAir = (int)this.jetPackFuelRemaining;
        if (!this.player.m_20096_()) {
            ModNetwork.sendToPlayer(serverPlayer, new VisualJetpackAirPacket(totalAir));
            this.airGaugeCleared = false;
        } else {
            this.fadeOutVisualAirOverlay();
        }
        long serverTime = this.player.m_9236_().m_46467_();
        ModNetwork.sendToPlayer(serverPlayer, new JetpackFuelSyncPacket(this.jetPackFuelRemaining, serverTime));
    }

    private Vec3 applyMovementPhysics(@NotNull Vec3 currentVelocity, @NotNull Vec3 direction, double acceleration, double maxSpeed) {
        Vec3 targetVelocity = currentVelocity.m_82549_(direction.m_82490_(acceleration));
        double speed = Math.sqrt(targetVelocity.f_82479_ * targetVelocity.f_82479_ + targetVelocity.f_82481_ * targetVelocity.f_82481_);
        if (speed > maxSpeed) {
            double scale = maxSpeed / speed;
            targetVelocity = new Vec3(targetVelocity.f_82479_ * scale, currentVelocity.f_82480_, targetVelocity.f_82481_ * scale);
        }
        return targetVelocity;
    }

    private double calculateHorizontalSpeed() {
        double baseFlySpeedBoost = 0.375;
        double defaultPlayerSneakSpeed = 0.08;
        double defaultPlayerWaterSpeed = 0.08;
        double defaultPlayerSprintSpeed = 0.13;
        double defaultPlayerWalkSpeed = 0.1;
        double baseHoverSpeedBoost = 0.25;
        double enchantedSpeedMultiplier = EnchantmentHelper.m_220302_((LivingEntity)this.player);
        double mobEffectSpeedMultiplier = this.player.m_21023_(MobEffects.f_19596_) ? (double)Objects.requireNonNull(this.player.m_21124_(MobEffects.f_19596_)).m_19564_() : 0.0;
        double baseSpeed = defaultPlayerWalkSpeed;
        if (this.player.m_20069_() && !this.player.m_6069_()) {
            return this.player.m_6069_() ? defaultPlayerWaterSpeed * 0.5 : defaultPlayerWaterSpeed;
        }
        if (this.player.m_20142_()) {
            baseSpeed = defaultPlayerSprintSpeed;
        } else if (this.isHovering) {
            baseSpeed = defaultPlayerSneakSpeed;
        }
        double horizontalSpeed = baseSpeed + baseFlySpeedBoost + mobEffectSpeedMultiplier / 10.0;
        if (this.isHovering) {
            horizontalSpeed = (baseSpeed + baseHoverSpeedBoost) * (1.0 + enchantedSpeedMultiplier) + mobEffectSpeedMultiplier / 10.0;
        }
        return horizontalSpeed;
    }

    private double calculateVerticalSpeed() {
        double currentVerticalSpeed = this.player.m_20184_().f_82480_;
        double dampingFactor = currentVerticalSpeed < 0.0 && !this.isJumping ? 0.05 : 0.15;
        double verticalTarget = -0.44;
        if (this.isJumping) {
            verticalTarget = 0.42;
        } else if (this.player.m_20069_()) {
            verticalTarget = -0.0275;
        } else if (this.player.m_6069_()) {
            return 0.0;
        }
        return currentVerticalSpeed * (1.0 - dampingFactor) + verticalTarget * dampingFactor;
    }

    private double calculateVerticalHoveringSpeed(double targetHeight) {
        boolean bobbingEnabled = this.player.getPersistentData().m_128469_("fxntstorageSettings").m_128471_("JetpackHoverBobbing");
        double currentY = this.player.m_20186_();
        double yDifference = targetHeight - currentY;
        double adjustmentForce = yDifference * 0.3;
        double newYVelocity = this.player.m_20184_().f_82480_ * 0.8 + adjustmentForce;
        if (bobbingEnabled && this.player.m_9236_().m_5776_()) {
            float time = (float)this.player.m_9236_().m_46467_() + Minecraft.m_91087_().getPartialTick();
            double period = 20.0;
            double angle = (double)time % period / period * (Math.PI * 2);
            double bob = Math.sin(angle) * 0.008;
            newYVelocity += bob;
        }
        return Mth.m_14008_((double)newYVelocity, (double)-0.2, (double)0.2);
    }

    public double calculateJetPackFuel(Player player) {
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        if (backpack.m_41619_()) {
            return 0.0;
        }
        List<ItemStack> backtanks = this.getBacktanksFromPlayer(player, backpack);
        return backtanks.stream().map(BacktankUtil::getAir).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    private void depleteJetPackFuel(Player player) {
        if (player.m_9236_().f_46443_ || player.m_7500_()) {
            return;
        }
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        Level world = player.m_9236_();
        long currRuntime = world.m_46467_();
        int elytraMultiplier = (Integer)ConfigManager.CommonConfig.ELYTRA_BOOST_MULTIPLIER.get();
        if (player.m_21255_() && (Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get() != false ? this.lastRuntime != 0L && currRuntime - this.lastRuntime < (long)(20 / elytraMultiplier) : this.lastRuntime != 0L && currRuntime - this.lastRuntime < 20L) {
            return;
        }
        this.lastRuntime = currRuntime;
        List<ItemStack> backtanks = this.getBacktanksFromPlayer(player, backpack);
        if (backtanks.isEmpty()) {
            return;
        }
        backtanks.sort((a, b) -> Float.compare(BacktankUtil.getAir((ItemStack)a), BacktankUtil.getAir((ItemStack)b)));
        int totalAir = Math.round(backtanks.stream().map(BacktankUtil::getAir).reduce(Float.valueOf(0.0f), Float::sum).floatValue());
        ModNetwork.sendToPlayer((ServerPlayer)player, new VisualJetpackAirPacket(totalAir));
        this.airGaugeCleared = false;
        CompoundTag tag = backtanks.get(0).m_41784_();
        int maxAir = BacktankUtil.maxAir((ItemStack)backtanks.get(0));
        float air = BacktankUtil.getAir((ItemStack)backtanks.get(0));
        float newAir = Math.max(air - 1.0f, 0.0f);
        tag.m_128350_("Air", Math.min(newAir, (float)maxAir));
        backtanks.get(0).m_41751_(tag);
        JetpackHandler.sendFuelWarning(player, totalAir, totalAir - 1, 90.0f);
        JetpackHandler.sendFuelWarning(player, totalAir, totalAir - 1, 1.0f);
    }

    private static IBackpackContainer getBackpackContainer(Player player, ItemStack backpack) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackMenu) {
            BackpackMenu backpackMenu = (BackpackMenu)abstractContainerMenu;
            if (backpackMenu.backpackType == 1) {
                return backpackMenu.container;
            }
        }
        return new BackpackContainer(backpack, player);
    }

    private List<ItemStack> getBacktanksFromPlayer(Player player, ItemStack backpack) {
        ArrayList<ItemStack> backtanks = new ArrayList<ItemStack>();
        ItemStack chestItem = player.m_6844_(EquipmentSlot.CHEST);
        if (!chestItem.m_41619_() && AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(chestItem) && BacktankUtil.hasAirRemaining((ItemStack)chestItem)) {
            backtanks.add(chestItem);
        }
        if (!backpack.m_41619_()) {
            IBackpackContainer container = JetpackHandler.getBackpackContainer(player, backpack);
            ItemStackHandler inventory = container.getItemHandler();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack slotItem = inventory.getStackInSlot(i);
                if (!AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(slotItem) || !BacktankUtil.hasAirRemaining((ItemStack)slotItem)) continue;
                backtanks.add(slotItem);
            }
        }
        return backtanks;
    }

    private static void sendFuelWarning(Player player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        MutableComponent component = Component.m_237115_((String)(depleted ? "item.fxntstorage.jetpack.fuel_depleted" : "item.fxntstorage.jetpack.fuel_low"));
        AllSoundEvents.DENY.play(player.m_9236_(), null, (Vec3i)player.m_20183_(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.m_9236_(), null, (Vec3i)player.m_20183_(), 0.5f, 0.5f);
        ServerPlayer sp = (ServerPlayer)player;
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)"\u26a0 ").m_130940_(depleted ? ChatFormatting.RED : ChatFormatting.GOLD).m_7220_((Component)component.m_130940_(ChatFormatting.GRAY))));
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(CommonComponents.f_237098_));
    }

    public void processPlayerInputPacket(float forward, float left) {
        this.forward = forward;
        this.left = left;
    }

    public void processPlayerFlyingPacket(boolean flying, boolean hovering) {
        this.isJumping = flying;
        this.isHovering = hovering;
    }

    public void flyingOnKeyPress() {
        if (new BackpackOnBackUpgradeHandler(this.player).hasUpgrade("backpack_flight_upgrade")) {
            this.isJumping = true;
        }
    }

    public void flyingOnKeyRelease() {
        this.isJumping = false;
    }

    public void resetState() {
        this.isJumping = false;
        this.isHovering = false;
        this.hoverHeight = 0.0;
        this.playedSoundThisJump = false;
        this.lastRuntime = 0L;
        this.airGaugeLastCleared = 0L;
        this.airGaugeCleared = false;
        this.lastValidVelocity = Vec3.f_82478_;
        this.predictedFuelRemaining = 0.0f;
        this.lastFuelSync = 0L;
    }
}

