/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class JetpackManager {
    private static final Map<UUID, JetpackHandler> SERVER = new HashMap<UUID, JetpackHandler>();
    private static final Map<UUID, JetpackHandler> CLIENT = new HashMap<UUID, JetpackHandler>();

    public static JetpackHandler getJetpackHandler(@NotNull Player player) {
        return player.m_9236_().f_46443_ ? CLIENT.computeIfAbsent(player.m_20148_(), uuid -> new JetpackHandler(player)) : SERVER.computeIfAbsent(player.m_20148_(), uuid -> new JetpackHandler(player));
    }

    public static void addPlayer(@NotNull Player player) {
        JetpackManager.removePlayer(player);
        JetpackHandler handler = JetpackManager.getJetpackHandler(player);
        handler.resetState();
        CompoundTag tag = player.getPersistentData().m_128469_("fxntstorageSettings");
        tag.m_128473_("JetpackFlying");
        tag.m_128473_("JetpackHover");
        tag.m_128473_("Jetpackforward");
        tag.m_128473_("Jetpackleft");
        if (!player.m_9236_().f_46443_) {
            double fuel = handler.calculateJetPackFuel(player);
            ModNetwork.sendToPlayer((ServerPlayer)player, new JetpackFuelSyncPacket((float)fuel, System.currentTimeMillis()));
        }
    }

    public static void removePlayer(@NotNull Player player) {
        if (player.m_9236_().f_46443_) {
            CLIENT.remove(player.m_20148_());
        } else {
            SERVER.remove(player.m_20148_());
        }
    }
}

