/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.ArrayList;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ToolSwapHandler {
    private final Player player;
    private final IBackpackContainer container;
    private final int startIndex;
    private final int endIndex;
    private static BlockState lastBlockState;
    private static ItemStack lastTool;
    private static LivingEntity lastEntity;
    private static ItemStack lastWeapon;

    public ToolSwapHandler(Player player, IBackpackContainer container, int startIndex, int endIndex) {
        this.player = player;
        this.container = container;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public void doToolSwap(BlockPos blockPos, LivingEntity entity) {
        ItemStack currentItem;
        if (blockPos != null && entity == null) {
            ToolInfo bestTool;
            currentItem = this.player.m_21205_();
            BlockState blockState = this.player.m_9236_().m_8055_(blockPos);
            if (!(blockState == lastBlockState && currentItem == lastTool || (bestTool = this.findBestToolForBreakingBlock(blockState)) == null || bestTool.itemStack.equals(currentItem))) {
                this.swapBlockTool(bestTool);
            }
            lastBlockState = blockState;
            lastTool = currentItem;
        }
        if (entity != null && blockPos == null) {
            WeaponInfo bestWeapon;
            currentItem = this.player.m_21205_();
            if (!(entity == lastEntity && currentItem == lastWeapon || (bestWeapon = this.findBestWeaponForAttackingEntity(entity)) == null || bestWeapon.itemStack.equals(currentItem))) {
                this.swapEntityTool(bestWeapon);
            }
            lastEntity = entity;
            lastWeapon = currentItem;
        }
    }

    public void swapBlockTool(ToolInfo bestTool) {
        ItemStack selectedStack;
        int selectedSlot;
        if (!bestTool.itemStack.m_41619_() && (selectedSlot = this.player.m_150109_().f_35977_) != bestTool.slot && !(selectedStack = this.player.m_150109_().m_36056_().m_41777_()).m_41619_()) {
            this.player.m_21008_(InteractionHand.MAIN_HAND, bestTool.itemStack.m_41777_());
            this.container.getItemHandler().setStackInSlot(bestTool.slot, selectedStack.m_41777_());
            this.container.setDataChanged();
        }
    }

    private ToolInfo findBestToolForBreakingBlock(BlockState blockState) {
        boolean currentToolMeetsSilkTouchRequirement;
        NonNullList suitableItems = NonNullList.m_122779_();
        boolean requiresSilkTouch = this.requiresSilkTouch(blockState);
        boolean prefersSilkTouch = this.prefersSilkTouch(blockState);
        boolean needsSilkTouch = requiresSilkTouch || prefersSilkTouch;
        ItemStack currentTool = this.player.m_21205_();
        boolean canUseAnyTool = this.canUseAnyToolForDrops(blockState);
        boolean currentToolIsCorrect = currentTool.m_41735_(blockState) || canUseAnyTool;
        boolean currentToolHasSilkTouch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)currentTool) > 0;
        boolean bl = currentToolMeetsSilkTouchRequirement = currentToolIsCorrect && (!needsSilkTouch || currentToolHasSilkTouch);
        if (currentToolMeetsSilkTouchRequirement && canUseAnyTool) {
            return null;
        }
        if (canUseAnyTool || currentToolIsCorrect) {
            suitableItems.add((Object)new ToolInfo(currentTool, this.player.m_150109_().f_35977_, currentTool.m_41691_(blockState), currentTool.m_41773_(), currentToolHasSilkTouch));
        }
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            int durability;
            double speed;
            boolean isItemTool;
            ItemStack itemStack = this.container.getItemHandler().getStackInSlot(i);
            boolean hasSilkTouch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) > 0;
            boolean bl2 = isItemTool = itemStack.m_204117_(Tags.Items.TOOLS) || itemStack.m_204117_(Tags.Items.SHEARS);
            if (canUseAnyTool && isItemTool) {
                speed = itemStack.m_41691_(blockState);
                durability = itemStack.m_41773_();
                suitableItems.add((Object)new ToolInfo(itemStack, i, speed, durability, hasSilkTouch));
                continue;
            }
            if (!itemStack.m_41735_(blockState)) continue;
            speed = itemStack.m_41691_(blockState);
            durability = itemStack.m_41773_();
            suitableItems.add((Object)new ToolInfo(itemStack, i, speed, durability, hasSilkTouch));
        }
        if (suitableItems.isEmpty()) {
            return new ToolInfo(ItemStack.f_41583_, -1, 0.0, 0, false);
        }
        ToolSwapHandler.sortTools((NonNullList<ToolInfo>)suitableItems, needsSilkTouch);
        for (ToolInfo tool : suitableItems) {
            if (suitableItems.size() == 1) {
                return tool;
            }
            if (tool.silkTouch && prefersSilkTouch) {
                return tool;
            }
            if (tool.silkTouch && requiresSilkTouch) {
                return tool;
            }
            if (tool.silkTouch) continue;
            return tool;
        }
        return null;
    }

    public void swapEntityTool(WeaponInfo bestWeapon) {
        ItemStack selectedStack;
        int selectedSlot;
        if (!bestWeapon.itemStack.m_41619_() && (selectedSlot = this.player.m_150109_().f_35977_) != bestWeapon.slot && !(selectedStack = this.player.m_150109_().m_36056_().m_41777_()).m_41619_()) {
            this.player.m_21008_(InteractionHand.MAIN_HAND, bestWeapon.itemStack.m_41777_());
            this.container.getItemHandler().setStackInSlot(bestWeapon.slot, selectedStack.m_41777_());
            this.container.setDataChanged();
        }
    }

    public WeaponInfo findBestWeaponForAttackingEntity(LivingEntity entity) {
        NonNullList suitableItems = NonNullList.m_122779_();
        ItemStack currentItem = this.player.m_150109_().m_36056_();
        double currentItemDamage = ToolSwapHandler.getAttackDamage(currentItem, entity);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            ItemStack itemStack = this.container.getItemHandler().getStackInSlot(i);
            if (!itemStack.canPerformAction(ToolActions.SWORD_SWEEP) && !itemStack.m_204117_(ItemTags.f_271388_) && !itemStack.m_204117_(ItemTags.f_271207_)) continue;
            double itemDamage = ToolSwapHandler.getAttackDamage(itemStack, entity);
            int durability = itemStack.m_41773_();
            if (!(itemDamage > currentItemDamage)) continue;
            suitableItems.add((Object)new WeaponInfo(itemStack, i, durability, itemDamage));
        }
        if (suitableItems.isEmpty()) {
            return new WeaponInfo(ItemStack.f_41583_, -1, 0, 0.0);
        }
        ToolSwapHandler.sortWeapons((NonNullList<WeaponInfo>)suitableItems);
        return (WeaponInfo)suitableItems.get(0);
    }

    public static double getAttackDamage(ItemStack weapon, LivingEntity target) {
        double baseDamage = ToolSwapHandler.getBaseAttackDamage(weapon);
        double enchantmentDamage = ToolSwapHandler.calculateEnchantmentDamage(weapon, target);
        return baseDamage + enchantmentDamage;
    }

    public static double getBaseAttackDamage(ItemStack itemStack) {
        return itemStack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, itemStack).get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
    }

    public static double calculateEnchantmentDamage(ItemStack weapon, LivingEntity target) {
        int sharpnessLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)weapon);
        int smiteLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44978_, (ItemStack)weapon);
        int baneLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44979_, (ItemStack)weapon);
        double additionalDamage = 0.0;
        if (sharpnessLevel > 0) {
            additionalDamage += 0.5 * (double)sharpnessLevel + 0.5;
        }
        if (smiteLevel > 0 && target.m_6336_() == MobType.f_21641_) {
            additionalDamage += (double)smiteLevel * 2.5;
        }
        if (baneLevel > 0 && target.m_6336_() == MobType.f_21642_) {
            additionalDamage += (double)baneLevel * 2.5;
        }
        return additionalDamage;
    }

    public static void sortTools(@NotNull NonNullList<ToolInfo> tools, boolean sortSilkTouchFirst) {
        tools.sort((o1, o2) -> {
            int silkTouchComparison;
            if (sortSilkTouchFirst && (silkTouchComparison = Boolean.compare(o2.silkTouch, o1.silkTouch)) != 0) {
                return silkTouchComparison;
            }
            int speedComparison = Double.compare(o2.speed, o1.speed);
            if (speedComparison != 0) {
                return speedComparison;
            }
            return Integer.compare(o1.slot, o2.slot);
        });
    }

    public static void sortWeapons(@NotNull NonNullList<WeaponInfo> tools) {
        tools.sort((o1, o2) -> {
            int damageComparison = Double.compare(o2.damage, o1.damage);
            if (damageComparison != 0) {
                return damageComparison;
            }
            return Double.compare(o2.durability, o1.durability);
        });
    }

    public boolean requiresSilkTouch(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block == Blocks.f_50717_ || blockState.m_204336_(BlockTags.f_13064_) || block == Blocks.f_152492_ || block == Blocks.f_244299_ || blockState.m_204336_(Tags.Blocks.GLASS) || blockState.m_204336_(Tags.Blocks.GLASS_PANES) || blockState.m_204336_(BlockTags.f_13047_) || block == Blocks.f_50578_;
    }

    public boolean prefersSilkTouch(BlockState state) {
        CompoundTag pData = this.player.getPersistentData().m_128469_("fxntstorageSettings");
        if (pData.m_128441_("PreferSilkTouch") && pData.m_128471_("PreferSilkTouch")) {
            if (pData.m_128441_("PrefersSilkTouchList")) {
                ListTag blockListTag = pData.m_128437_("PrefersSilkTouchList", 8);
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                ArrayList<String> blockList = new ArrayList<String>();
                for (int i = 0; i < blockListTag.size(); ++i) {
                    blockList.add(blockListTag.m_128778_(i));
                }
                if (blockId != null && !blockList.isEmpty()) {
                    return blockList.contains(blockId.toString());
                }
            }
            return false;
        }
        return false;
    }

    public boolean canUseAnyToolForDrops(BlockState state) {
        return state.m_204336_(ModTags.Blocks.BREAKABLE_WITH_ANY_TOOL);
    }

    public record ToolInfo(ItemStack itemStack, int slot, double speed, int durability, boolean silkTouch) {
    }

    public record WeaponInfo(ItemStack itemStack, int slot, int durability, double damage) {
    }
}

