/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.util;

import java.util.Optional;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BackpackHelper {
    public static boolean isBackpackCuriosSlotVisible(Player player) {
        if (player == null) {
            return false;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).map(slotResult -> slotResult.slotContext().visible()).orElse(false);
    }

    public static boolean isWearingBackpack(Player player, boolean checkVisibility) {
        ItemStack itemStack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        if (FXNTStorage.curiosLoaded && checkVisibility && !(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof BackpackItem)) {
            return BackpackHelper.isBackpackCuriosSlotVisible(player);
        }
        return !itemStack.m_41619_();
    }

    public static boolean isWearingBackpack(Player player) {
        return BackpackHelper.isWearingBackpack(player, false);
    }

    public static ItemStack getEquippedBackpackStack(LivingEntity player) {
        Optional stacksHandler;
        if (player == null) {
            return ItemStack.f_41583_;
        }
        if (!FXNTStorage.curiosLoaded) {
            return BackpackHelper.checkChestSlot(player);
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curios.isPresent() && (stacksHandler = ((ICuriosItemHandler)curios.get()).getStacksHandler("back")).isPresent()) {
            IDynamicStackHandler stacks = ((ICurioStacksHandler)stacksHandler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof BackpackItem)) continue;
                return stack;
            }
        }
        return BackpackHelper.checkChestSlot(player);
    }

    private static ItemStack checkChestSlot(@NotNull LivingEntity player) {
        ItemStack chestSlotItem = player.m_6844_(EquipmentSlot.CHEST);
        return chestSlotItem.m_41720_() instanceof BackpackItem ? chestSlotItem : ItemStack.f_41583_;
    }

    public static boolean equipBackpack(Player player, ItemStack backpack) {
        ICuriosItemHandler curiosInv;
        Optional stacksHandler;
        if (player == null || backpack.m_41619_()) {
            return false;
        }
        if (!FXNTStorage.curiosLoaded) {
            return BackpackHelper.equipInChestSlot(player, backpack);
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curios.isPresent() && (stacksHandler = (curiosInv = (ICuriosItemHandler)curios.get()).getStacksHandler("back")).isPresent()) {
            IDynamicStackHandler stacks = ((ICurioStacksHandler)stacksHandler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!stacks.getStackInSlot(i).m_41619_()) continue;
                curiosInv.setEquippedCurio("back", i, backpack);
                return true;
            }
        }
        return BackpackHelper.equipInChestSlot(player, backpack);
    }

    private static boolean equipInChestSlot(@NotNull Player player, ItemStack backpack) {
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        if (chestStack.m_41619_()) {
            player.m_8061_(EquipmentSlot.CHEST, backpack);
            return true;
        }
        return BackpackHelper.equipInPlayerInventory(player, backpack);
    }

    private static boolean equipInPlayerInventory(@NotNull Player player, ItemStack backpack) {
        int freeInventorySlot = player.m_150109_().m_36062_();
        if (freeInventorySlot > -1) {
            player.m_150109_().m_6836_(freeInventorySlot, backpack);
            return true;
        }
        return false;
    }

    public int getItemSlotFromContainer(@NotNull IBackpackContainer container, Item itemToFind) {
        for (int i = 0; i < container.getItemHandler().getSlots(); ++i) {
            ItemStack slotItem = container.getItemHandler().getStackInSlot(i);
            if (!slotItem.m_150930_(itemToFind)) continue;
            return i;
        }
        return -1;
    }

    public boolean itemEntityToBackpack(@NotNull IBackpackContainer container, @NotNull ItemEntity itemEntity, int startIndex, int endIndex) {
        ItemStack itemStack;
        int i;
        ItemStack newStack = itemEntity.m_32055_();
        ItemStackHandler itemHandler = container.getItemHandler();
        if (endIndex == -1) {
            endIndex = itemHandler.getSlots();
        }
        boolean success = false;
        if (!(newStack.m_41763_() || newStack.m_41782_() || newStack.m_41788_() || newStack.m_150947_())) {
            for (i = startIndex; !newStack.m_41619_() && i < endIndex; ++i) {
                itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.m_41619_() || !ItemStack.m_150942_((ItemStack)newStack, (ItemStack)itemStack)) continue;
                int totalCount = itemStack.m_41613_() + newStack.m_41613_();
                int maxPutSize = Math.max(newStack.m_41741_(), container.getStackMultiplier() * newStack.m_41741_());
                int availableSpace = maxPutSize - itemStack.m_41613_();
                if (totalCount <= maxPutSize) {
                    newStack.m_41764_(0);
                    itemStack.m_41764_(totalCount);
                    success = true;
                    continue;
                }
                if (availableSpace >= newStack.m_41741_()) continue;
                newStack.m_41774_(availableSpace);
                itemStack.m_41764_(maxPutSize);
                success = true;
            }
        }
        if (!newStack.m_41619_()) {
            for (i = startIndex; i < endIndex; ++i) {
                itemStack = container.getItemHandler().getStackInSlot(i);
                if (!itemStack.m_41619_()) continue;
                int maxPutSize = Math.max(newStack.m_41741_(), container.getStackMultiplier() * newStack.m_41741_());
                int availableSpace = maxPutSize - itemStack.m_41613_();
                if (newStack.m_41613_() > availableSpace) {
                    ItemStack inputStack = newStack.m_41620_(container.getStackMultiplier() * newStack.m_41741_());
                    itemHandler.setStackInSlot(i, inputStack);
                } else {
                    ItemStack inputStack = newStack.m_41620_(newStack.m_41613_());
                    itemHandler.setStackInSlot(i, inputStack);
                }
                success = true;
                break;
            }
        }
        container.setDataChanged();
        return success;
    }
}

