/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.cache;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PasserShapeCache {
    private static final Map<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);

    public static void clearCache() {
        shapes.clear();
        PasserShapeCache.initializeShapes();
    }

    private static void initializeShapes() {
        shapes.put(Direction.UP, PasserShapeCache.createShapeForDirection(Direction.UP));
        shapes.put(Direction.DOWN, PasserShapeCache.createShapeForDirection(Direction.DOWN));
        shapes.put(Direction.NORTH, PasserShapeCache.createShapeForDirection(Direction.NORTH));
        shapes.put(Direction.SOUTH, PasserShapeCache.createShapeForDirection(Direction.SOUTH));
        shapes.put(Direction.EAST, PasserShapeCache.createShapeForDirection(Direction.EAST));
        shapes.put(Direction.WEST, PasserShapeCache.createShapeForDirection(Direction.WEST));
    }

    private static VoxelShape createShapeForDirection(Direction direction) {
        VoxelShape finalShape = Shapes.m_83040_();
        List<VoxelShape> parts = Arrays.asList(Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0), Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)5.0), Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0, (double)9.0), Block.m_49796_((double)3.0, (double)3.0, (double)9.0, (double)13.0, (double)13.0, (double)15.0), Block.m_49796_((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0));
        for (VoxelShape part : parts) {
            VoxelShape rotatedPart = PasserShapeCache.rotate(part, direction);
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)rotatedPart);
        }
        return finalShape.m_83296_();
    }

    public static VoxelShape getShape(Direction direction) {
        return shapes.get(direction);
    }

    private static VoxelShape rotate(VoxelShape shape, Direction dir) {
        return switch (dir) {
            case Direction.UP -> Shapes.m_166049_((double)shape.m_83288_(Direction.Axis.X), (double)(1.0 - shape.m_83297_(Direction.Axis.Z)), (double)shape.m_83288_(Direction.Axis.Y), (double)shape.m_83297_(Direction.Axis.X), (double)(1.0 - shape.m_83288_(Direction.Axis.Z)), (double)shape.m_83297_(Direction.Axis.Y));
            case Direction.DOWN -> Shapes.m_166049_((double)shape.m_83288_(Direction.Axis.X), (double)shape.m_83288_(Direction.Axis.Z), (double)shape.m_83288_(Direction.Axis.Y), (double)shape.m_83297_(Direction.Axis.X), (double)shape.m_83297_(Direction.Axis.Z), (double)shape.m_83297_(Direction.Axis.Y));
            case Direction.SOUTH -> Shapes.m_166049_((double)(1.0 - shape.m_83297_(Direction.Axis.X)), (double)shape.m_83288_(Direction.Axis.Y), (double)(1.0 - shape.m_83297_(Direction.Axis.Z)), (double)(1.0 - shape.m_83288_(Direction.Axis.X)), (double)shape.m_83297_(Direction.Axis.Y), (double)(1.0 - shape.m_83288_(Direction.Axis.Z)));
            case Direction.WEST -> Shapes.m_166049_((double)shape.m_83288_(Direction.Axis.Z), (double)shape.m_83288_(Direction.Axis.Y), (double)(1.0 - shape.m_83297_(Direction.Axis.X)), (double)shape.m_83297_(Direction.Axis.Z), (double)shape.m_83297_(Direction.Axis.Y), (double)(1.0 - shape.m_83288_(Direction.Axis.X)));
            case Direction.EAST -> Shapes.m_166049_((double)(1.0 - shape.m_83297_(Direction.Axis.Z)), (double)shape.m_83288_(Direction.Axis.Y), (double)shape.m_83288_(Direction.Axis.X), (double)(1.0 - shape.m_83288_(Direction.Axis.Z)), (double)shape.m_83297_(Direction.Axis.Y), (double)shape.m_83297_(Direction.Axis.X));
            default -> shape;
        };
    }

    static {
        PasserShapeCache.initializeShapes();
    }
}

