/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat;

import java.util.Optional;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosCompat
implements ICurio {
    public final ItemStack stack;

    public CuriosCompat(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo(SoundEvents.f_11678_, 1.0f, 1.0f);
    }

    public boolean canEquip(SlotContext slotContext) {
        if (slotContext.entity().m_6844_(EquipmentSlot.CHEST).m_41720_().m_5456_() instanceof BackpackItem) {
            return false;
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).resolve();
        if (curios.isPresent()) {
            ICuriosItemHandler curiosInv = (ICuriosItemHandler)curios.get();
            Optional backpackSlot = curiosInv.findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem);
            return backpackSlot.isEmpty();
        }
        return false;
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return false;
    }

    public boolean canSync(SlotContext slotContext) {
        return true;
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
        return (Boolean)ConfigManager.CommonConfig.CURIOS_KEEP_BACKPACK.get() != false ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.ALWAYS_DROP;
    }
}

