/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.constructionwand;

import java.util.Optional;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerStorageBox
implements IContainerHandler {
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.m_41613_() == 1 && (Block.m_49814_((Item)inventoryStack.m_41720_()) instanceof StorageBox || Block.m_49814_((Item)inventoryStack.m_41720_()) instanceof SimpleStorageBox);
    }

    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        int total = 0;
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack containerStack = itemHandler.getStackInSlot(i);
            if (!WandUtil.stackEquals((ItemStack)itemStack, (ItemStack)containerStack)) continue;
            total += Math.max(0, containerStack.m_41613_());
        }
        return total;
    }

    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        ItemStack extracted;
        ItemStack handlerStack;
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; !(i >= itemHandler.getSlots() || WandUtil.stackEquals((ItemStack)itemStack, (ItemStack)(handlerStack = itemHandler.getStackInSlot(i))) && (count -= (extracted = itemHandler.extractItem(i, count, false)).m_41613_()) <= 0); ++i) {
        }
        HandlerStorageBox.saveInventoryToStack(inventoryStack);
        return count;
    }

    public static void saveInventoryToStack(ItemStack stack) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
            if (cap instanceof ItemStackHandler) {
                ItemStackHandler handler = (ItemStackHandler)cap;
                CompoundTag beTag = stack.m_41698_("BlockEntityTag");
                beTag.m_128365_("Items", (Tag)handler.serializeNBT());
                if (Block.m_49814_((Item)stack.m_41720_()) instanceof SimpleStorageBox) {
                    beTag.m_128405_("StoredAmount", handler.getStackInSlot(0).m_41613_());
                    BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get()), (CompoundTag)beTag);
                } else if (Block.m_49814_((Item)stack.m_41720_()) instanceof StorageBox) {
                    int storedAmount = 0;
                    int totalSpace = 0;
                    float percentageUsed = 0.0f;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack itemStack = handler.getStackInSlot(i);
                        int maxStackSize = Math.min(handler.getSlotLimit(i), itemStack.m_41741_());
                        storedAmount += handler.getStackInSlot(i).m_41613_();
                        totalSpace += maxStackSize;
                    }
                    if (totalSpace > 0) {
                        percentageUsed = (float)storedAmount / (float)totalSpace * 100.0f;
                    }
                    beTag.m_128405_("StoredAmount", storedAmount);
                    beTag.m_128350_("PercentageUsed", percentageUsed);
                    BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get()), (CompoundTag)beTag);
                }
            }
        });
    }
}

