/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.block.IBE;
import java.util.UUID;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBox
extends BaseEntityBlock
implements IBE<StorageBoxEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<EnumProperties.StorageUsed> STORAGE_USED = EnumProperty.m_61587_((String)"storage_used", EnumProperties.StorageUsed.class);
    public static final BooleanProperty VOID_UPGRADE = BooleanProperty.m_61465_((String)"void_upgrade");
    public static final BooleanProperty COPY_NBT = BooleanProperty.m_61465_((String)"copy_nbt");
    private final int slotCount;
    private long lastClickTime;
    private UUID lastClickUUID;

    public StorageBox(BlockBehaviour.Properties pProperties, int slotCount) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STORAGE_USED, (Comparable)((Object)EnumProperties.StorageUsed.EMPTY))).m_61124_((Property)VOID_UPGRADE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COPY_NBT, (Comparable)Boolean.valueOf(false)));
        this.slotCount = slotCount;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public Class<StorageBoxEntity> getBlockEntityClass() {
        return StorageBoxEntity.class;
    }

    public BlockEntityType<? extends StorageBoxEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        BlockEntityType type = (BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get();
        StorageBoxEntity blockEntity = new StorageBoxEntity(type, pPos, pState);
        blockEntity.initializeEntity(this.slotCount);
        return blockEntity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return StorageBox.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof StorageBoxEntity) {
            CompoundTag tag;
            StorageBoxEntity be = (StorageBoxEntity)blockEntity;
            if (pStack.m_41788_()) {
                be.setCustomName(pStack.m_41786_());
            }
            if ((tag = pStack.m_41783_()) != null && tag.m_128425_("BlockEntityTag", 10)) {
                CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
                SortOrder order = blockEntityTag.m_128441_("SortOrder") ? SortOrder.valueOf(blockEntityTag.m_128461_("SortOrder")) : SortOrder.COUNT;
                be.setSortOrder(order);
            }
            be.forceNextTick();
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        IBE.onRemove((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockState)pNewState);
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    private boolean hitFront(BlockState blockState, BlockHitResult hit) {
        Direction side = hit.m_82434_();
        return blockState.m_61143_((Property)FACING) == side;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_5833_() || pHand == InteractionHand.OFF_HAND || !this.hitFront(pState, pHit)) {
            return InteractionResult.PASS;
        }
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = pLevel.m_7702_(pPos);
        if (entity instanceof StorageBoxEntity) {
            ItemStack itemInHand = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
            int INTERACTION_COOLDOWN = 8;
            if (pLevel.m_46467_() - this.lastClickTime < 8L && pPlayer.m_20148_().equals(this.lastClickUUID)) {
                if (itemInHand.m_41619_()) {
                    ((StorageBoxEntity)entity).transferToStorage(pState, pPlayer, true);
                }
            } else {
                if (itemInHand.m_204117_(AllTags.AllItemTags.WRENCH.tag)) {
                    ((StorageBoxEntity)entity).toggleVoidUpgrade();
                    return InteractionResult.SUCCESS;
                }
                if (pPlayer.m_6144_()) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((MenuProvider)entity), (BlockPos)pPos);
                    return InteractionResult.CONSUME;
                }
                if (!itemInHand.m_41619_()) {
                    ((StorageBoxEntity)entity).transferToStorage(pState, pPlayer, false);
                }
            }
            this.lastClickTime = pLevel.m_46467_();
            this.lastClickUUID = pPlayer.m_20148_();
        }
        return InteractionResult.m_19078_((boolean)false);
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockHitResult hit = StorageBox.rayTraceEyes(pLevel, pPlayer, pPos);
        if (hit.m_6662_() != HitResult.Type.BLOCK || !hit.m_82425_().equals((Object)pPos) || !this.hitFront(pState, hit)) {
            return;
        }
        StorageBoxEntity blockEntity = (StorageBoxEntity)pLevel.m_7702_(pPos);
        Item item = pPlayer.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (blockEntity != null && !(item instanceof PickaxeItem) && !(item instanceof AxeItem)) {
            blockEntity.transferFromStorage(pPlayer);
        }
    }

    @Nullable
    public static Direction getDirectionFacing(BlockState state) {
        if (!(state.m_60734_() instanceof StorageBox)) {
            return null;
        }
        return ((StorageBox)state.m_60734_()).getFacing(state);
    }

    protected Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        CompoundTag tag = pContext.m_43722_().m_41783_();
        boolean voidUpgrade = tag != null && tag.m_128469_("BlockEntityTag").m_128471_("voidUpgrade");
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)VOID_UPGRADE, (Comparable)Boolean.valueOf(voidUpgrade));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, STORAGE_USED, VOID_UPGRADE, COPY_NBT});
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof StorageBoxEntity) {
            StorageBoxEntity entity = (StorageBoxEntity)blockEntity;
            float percentFull = entity.calculatePercentageUsed() / 100.0f;
            return (int)Math.min(percentFull * 15.0f, 15.0f);
        }
        return 0;
    }

    public static BlockHitResult rayTraceEyes(Level level, Player player, BlockPos blockPos) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVector.m_82490_(eyePos.m_82554_(Vec3.m_82512_((Vec3i)blockPos)) + 1.0));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return level.m_45547_(context);
    }
}

