/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container.mounted;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.menu.StorageInteractionWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.utility.CreateCodecs;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedMenu;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModMountedStorageTypes;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.registry.ContraptionStorageFilters;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBoxMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler>
implements ContraptionStorageFilters.FilteredMountedStorage {
    public static final Codec<StorageBoxMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(StorageBoxMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped);
    public boolean initialized = false;
    private boolean dirty = false;
    private FilterItemStack filterItem = FilterItemStack.empty();
    @Nullable
    private Contraption currentContraption = null;
    private boolean voidUpgrade;
    private SortOrder sortOrder;

    protected StorageBoxMountedStorage(MountedItemStorageType<?> type, ItemStackHandler handler) {
        super(type, (IItemHandlerModifiable)handler);
    }

    protected StorageBoxMountedStorage(ItemStackHandler handler) {
        this((MountedItemStorageType)ModMountedStorageTypes.STORAGE_BOX_MOUNTED.get(), handler);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        if (player.m_5833_()) {
            return false;
        }
        ItemStack itemInHand = player.m_21205_();
        if (itemInHand.m_204117_(AllTags.AllItemTags.WRENCH.tag) && info.f_74677_() != null) {
            boolean nbtValue = info.f_74677_().m_128471_("VoidUpgrade");
            this.voidUpgrade = !nbtValue;
            CompoundTag newNbt = info.f_74677_().m_6426_();
            newNbt.m_128379_("VoidUpgrade", !nbtValue);
            BlockState updatedState = (BlockState)info.f_74676_().m_61124_((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(!nbtValue));
            StructureTemplate.StructureBlockInfo updatedInfo = new StructureTemplate.StructureBlockInfo(info.f_74675_(), updatedState, newNbt);
            contraption.getBlocks().put(info.f_74675_(), updatedInfo);
            this.markDirty();
            return true;
        }
        if (!itemInHand.m_41619_()) {
            if (this.filterItem.isEmpty() || this.filterTest(itemInHand)) {
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.wrapped, (ItemStack)itemInHand, (boolean)false);
                if (remainder.m_41613_() > 0 && this.voidUpgrade) {
                    remainder = ItemStack.f_41583_;
                }
                if (remainder.m_41613_() <= itemInHand.m_41613_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, remainder);
                } else {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                this.markDirty();
                return true;
            }
            return false;
        }
        ServerLevel level = player.m_284548_();
        BlockPos localPos = info.f_74675_();
        Vec3 localPosVec = Vec3.m_82512_((Vec3i)localPos);
        Predicate<Player> stillValid = p -> {
            Vec3 currentPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            return this.isMenuValid(player, contraption, currentPos);
        };
        Component menuName = this.getMenuName(info, contraption);
        Consumer<Player> onClose = p -> {
            Vec3 newPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.playClosingSound(level, newPos);
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this.createMenu(menuName, this.wrapped, stillValid, onClose, contraption.entity.m_19879_(), localPos, info.f_74677_()), buf -> {
            buf.writeInt(((ItemStackHandler)this.wrapped).getSlots());
            buf.writeInt(contraption.entity.m_19879_());
            buf.m_130064_(localPos);
            buf.m_130079_(info.f_74677_());
        });
        return true;
    }

    @Nullable
    protected MenuProvider createMenu(Component name, IItemHandlerModifiable handler, Predicate<Player> stillValid, Consumer<Player> onClose, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        StorageInteractionWrapper wrapper = new StorageInteractionWrapper(handler, stillValid, onClose);
        return new SimpleMenuProvider((arg_0, arg_1, arg_2) -> StorageBoxMountedStorage.lambda$createMenu$4((Container)wrapper, contraptionId, localPos, nbt, arg_0, arg_1, arg_2), name);
    }

    public static StorageBoxMountedStorage fromStorage(StorageBoxEntity storageBox) {
        return new StorageBoxMountedStorage(StorageBoxMountedStorage.copyToItemStackHandler((IItemHandler)storageBox.getItemHandler()));
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof StorageBoxEntity) {
            StorageBoxEntity storageBoxEntity = (StorageBoxEntity)be;
            storageBoxEntity.applyInventoryToBlock((ItemStackHandler)this.wrapped);
        }
        this.currentContraption = null;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack amount = super.insertItem(slot, stack, simulate);
        if (slot == ((ItemStackHandler)this.wrapped).getSlots() - 1 && !amount.m_41619_() && this.voidUpgrade) {
            return ItemStack.f_41583_;
        }
        this.markDirty();
        return amount;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = super.extractItem(slot, amount, simulate);
        if (!stack.m_41619_() && !simulate) {
            this.markDirty();
        }
        return stack;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        ContraptionStorageFilters registry;
        if (this.currentContraption != null && (registry = ContraptionStorageFilters.getOrCreate(this.currentContraption)).matches(this.currentContraption.entity.m_9236_(), stack) && this.filterItem.isEmpty()) {
            return false;
        }
        return this.filterTest(stack);
    }

    private boolean filterTest(ItemStack stack) {
        return this.filterItem.test(null, stack);
    }

    private float calculatePercentageUsed() {
        int totalSpace = 0;
        int usedSpace = 0;
        for (int i = 0; i < ((ItemStackHandler)this.wrapped).getSlots(); ++i) {
            ItemStack stack = ((ItemStackHandler)this.wrapped).getStackInSlot(i);
            int maxStackSize = stack.m_41619_() ? 64 : stack.m_41741_();
            totalSpace += maxStackSize;
            usedSpace += stack.m_41613_();
        }
        if (totalSpace == 0) {
            return 0.0f;
        }
        return (float)usedSpace / (float)totalSpace * 100.0f;
    }

    private EnumProperties.StorageUsed calculateFillLevel() {
        int totalSlots = ((ItemStackHandler)this.wrapped).getSlots();
        boolean allSlotsFull = true;
        int filledSlots = 0;
        for (int i = 0; i < ((ItemStackHandler)this.wrapped).getSlots(); ++i) {
            ItemStack slot = ((ItemStackHandler)this.wrapped).getStackInSlot(i);
            if (!slot.m_41619_()) {
                ++filledSlots;
                if (slot.m_41613_() >= slot.m_41741_()) continue;
                allSlotsFull = false;
                continue;
            }
            allSlotsFull = false;
        }
        int emptySlots = totalSlots - filledSlots;
        EnumProperties.StorageUsed newStorageUsed = EnumProperties.StorageUsed.EMPTY;
        if (allSlotsFull) {
            newStorageUsed = EnumProperties.StorageUsed.FULL;
        } else if (emptySlots == 0) {
            newStorageUsed = EnumProperties.StorageUsed.SLOTS_FILLED;
        } else if (filledSlots > 0) {
            newStorageUsed = EnumProperties.StorageUsed.HAS_ITEMS;
        }
        return newStorageUsed;
    }

    public void updateClientStorageData(MovementContext context) {
        int amount = IntStream.range(0, ((ItemStackHandler)this.wrapped).getSlots()).map(i -> ((ItemStackHandler)this.wrapped).getStackInSlot(i).m_41613_()).sum();
        float percentUsed = this.calculatePercentageUsed();
        EnumProperties.StorageUsed fillLevel = this.calculateFillLevel();
        context.blockEntityData.m_128405_("StoredAmount", amount);
        context.blockEntityData.m_128350_("PercentageUsed", percentUsed);
        context.blockEntityData.m_128359_("SortOrder", this.sortOrder.name());
        context.blockEntityData.m_128379_("VoidUpgrade", this.voidUpgrade);
        context.state.m_61124_(StorageBox.STORAGE_USED, (Comparable)((Object)fillLevel));
        context.state.m_61124_((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(this.voidUpgrade));
        ModNetwork.sendToAllTracking((Entity)context.contraption.entity, new SyncMountedStoragePacket(context.contraption.entity.m_19879_(), context.localPos, fillLevel, context.blockEntityData));
        this.markClean();
    }

    public void initBlockEntityData(MovementContext context) {
        if (this.initialized) {
            return;
        }
        this.filterItem = FilterItemStack.of((CompoundTag)context.blockEntityData.m_128469_("Filter"));
        this.voidUpgrade = context.blockEntityData.m_128471_("VoidUpgrade");
        this.sortOrder = SortOrder.valueOf(context.blockEntityData.m_128461_("SortOrder"));
        this.currentContraption = context.contraption.entity.getContraption();
        if (this.currentContraption != null && !this.filterItem.isEmpty()) {
            ContraptionStorageFilters registry = ContraptionStorageFilters.getOrCreate(this.currentContraption);
            registry.register((ContraptionStorageFilters.FilteredMountedStorage)this, this.filterItem);
        }
        ModNetwork.sendToAllTracking((Entity)context.contraption.entity, new SyncMountedStoragePacket(context.contraption.entity.m_19879_(), context.localPos, this.calculateFillLevel(), context.blockEntityData));
        this.initialized = true;
    }

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private static /* synthetic */ AbstractContainerMenu lambda$createMenu$4(Container wrapper, int contraptionId, BlockPos localPos, CompoundTag nbt, int id, Inventory inv, Player player) {
        return new StorageBoxMountedMenu(id, inv, wrapper, contraptionId, localPos, nbt);
    }
}

