/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.controller;

import java.util.UUID;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageController;
import net.fxnt.fxntstorage.storage_network.StorageNetwork;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageControllerEntity
extends BlockEntity {
    private static final int INTERACT_WINDOW = 600;
    private int tickCount = 0;
    private long lastInteractTime = 0L;
    private UUID lastInteractPlayer = UUID.randomUUID();
    private byte lastInteractType = (byte)-1;
    public StorageNetwork storageNetwork;
    private final LazyOptional<IItemHandlerModifiable> lazyItemHandler = LazyOptional.of(() -> new StorageControllerHandler(this));

    public StorageControllerEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.getStorageNetwork();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void getStorageNetwork() {
        this.storageNetwork = new StorageNetwork(this);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.storageNetwork != null ? this.storageNetwork.getItemHandler() : new EmptyHandler();
    }

    public void serverTick(Level level, BlockPos blockPos) {
        if (level.f_46443_) {
            return;
        }
        if (this.storageNetwork != null) {
            boolean isConnected;
            this.storageNetwork.tick();
            BlockState blockState = this.m_58900_();
            boolean bl = isConnected = !this.storageNetwork.boxes.isEmpty();
            if ((Boolean)blockState.m_61143_((Property)StorageController.CONNECTED) != isConnected) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)StorageController.CONNECTED, (Comparable)Boolean.valueOf(isConnected)));
            }
        }
        if (this.tickCount >= (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            this.tickCount = 0;
        }
        ++this.tickCount;
    }

    public void transferItemsFromPlayer(Player player) {
        ItemStack handItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (Util.m_137550_() < this.lastInteractTime + 600L && player.m_20148_().equals(this.lastInteractPlayer) && this.lastInteractType == 1 && handItem.m_41619_()) {
            this.transferAllItemsFromPlayer(player);
        } else if (!handItem.m_41619_()) {
            this.lastInteractTime = Util.m_137550_();
            this.lastInteractPlayer = player.m_20148_();
            this.lastInteractType = 1;
            this.doTransferItemsFromPlayer(player, handItem);
        }
    }

    public void transferAllItemsFromPlayer(Player player) {
        for (int i = 0; i <= player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            this.doTransferItemsFromPlayer(player, slotStack);
        }
    }

    private void doTransferItemsFromPlayer(Player player, ItemStack srcStack) {
        this.storageNetwork.insertItems(srcStack);
        player.m_150109_().m_6596_();
    }

    private record StorageControllerHandler(StorageControllerEntity storageControllerEntity) implements IItemHandlerModifiable
    {
        private IItemHandlerModifiable get() {
            return this.storageControllerEntity.getItemHandler();
        }

        public int getSlots() {
            return this.get().getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.get().getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.get().insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.get().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.get().isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.get().setStackInSlot(slot, stack);
        }
    }
}

