/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.controller;

import com.simibubi.create.api.packager.unpacking.UnpackingHandler;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageInterfaceEntity;
import net.fxnt.fxntstorage.storage_network.StorageNetwork;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public enum StorageInterfaceUnpacking implements UnpackingHandler
{
    INSTANCE;


    public boolean unpack(Level level, BlockPos blockPos, BlockState blockState, Direction direction, List<ItemStack> items, @Nullable PackageOrderWithCrafts packageOrderWithCrafts, boolean simulate) {
        BlockEntity targetBE = level.m_7702_(blockPos);
        if (targetBE == null) {
            return false;
        }
        IItemHandler targetInv = targetBE.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve().orElse(null);
        StorageInterfaceEntity storageInterfaceEntity = (StorageInterfaceEntity)targetBE;
        if (storageInterfaceEntity.controller == null || storageInterfaceEntity.controller.storageNetwork == null) {
            return false;
        }
        StorageNetwork storageNetwork = storageInterfaceEntity.controller.storageNetwork;
        if (targetInv == null) {
            return false;
        }
        if (!simulate) {
            for (ItemStack itemStack : items) {
                storageNetwork.insertItems(itemStack);
            }
            return true;
        }
        ArrayList<ItemStorage> emptyBoxes = new ArrayList<ItemStorage>();
        HashMap<Item, List> storageBoxes = new HashMap<Item, List>();
        for (Object item : storageNetwork.boxes) {
            Item filterItem = ((StorageNetwork.StorageNetworkItem)item).simpleStorageBoxEntity.filterItem.m_41720_();
            ItemStorage storage = new ItemStorage(((StorageNetwork.StorageNetworkItem)item).simpleStorageBoxEntity.getMaxItemCapacity(), ((StorageNetwork.StorageNetworkItem)item).simpleStorageBoxEntity.getStoredAmount(), ((StorageNetwork.StorageNetworkItem)item).simpleStorageBoxEntity.hasVoidUpgrade());
            if (filterItem == Items.f_41852_) {
                emptyBoxes.add(storage);
                continue;
            }
            storageBoxes.computeIfAbsent(filterItem, k -> new ArrayList()).add(storage);
        }
        HashMap<Util.ItemWithNBT, Integer> itemCounts = new HashMap<Util.ItemWithNBT, Integer>();
        for (ItemStack stack : items) {
            Util.ItemWithNBT key = new Util.ItemWithNBT(stack.m_41720_(), stack.m_41783_());
            itemCounts.merge(key, stack.m_41613_(), Integer::sum);
        }
        HashMap<ItemStack, Boolean> condensed = new HashMap<ItemStack, Boolean>();
        for (Map.Entry entry : itemCounts.entrySet()) {
            int stackSize;
            Util.ItemWithNBT key = (Util.ItemWithNBT)entry.getKey();
            Item item = key.item();
            CompoundTag tag = key.tag();
            for (int totalCount = ((Integer)entry.getValue()).intValue(); totalCount > 0; totalCount -= stackSize) {
                stackSize = totalCount;
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (tag != null) {
                    stack.m_41751_(tag.m_6426_());
                }
                condensed.put(stack, false);
            }
        }
        for (Map.Entry entry : condensed.entrySet()) {
            ItemStorage box;
            ItemStack itemStack = (ItemStack)entry.getKey();
            boolean storageFound = false;
            List matchingBoxes = (List)storageBoxes.get(itemStack.m_41720_());
            if (matchingBoxes != null) {
                for (ItemStorage box2 : matchingBoxes) {
                    if (!box2.voidUpgrade() && box2.storedAmount() + itemStack.m_41613_() > box2.maxCapacity()) continue;
                    storageFound = true;
                    break;
                }
            }
            if (((Boolean)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_FILL_EMPTY.get()).booleanValue() && !storageFound && !emptyBoxes.isEmpty() && ((box = (ItemStorage)emptyBoxes.remove(0)).voidUpgrade() || itemStack.m_41613_() <= box.maxCapacity())) {
                storageFound = true;
            }
            entry.setValue(storageFound);
        }
        return condensed.values().stream().allMatch(Boolean::booleanValue);
    }

    private record ItemStorage(int maxCapacity, int storedAmount, boolean voidUpgrade) {
    }
}

