/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.init;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fxnt.fxntstorage.network.handler.ClientPayloadHandler;
import net.fxnt.fxntstorage.network.handler.ServerPayloadHandler;
import net.fxnt.fxntstorage.network.packet.CrossbowChargedPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFlyingPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.KeyPressedPacket;
import net.fxnt.fxntstorage.network.packet.PickBlockUpgradePacket;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.network.packet.SortInventoryPacket;
import net.fxnt.fxntstorage.network.packet.SyncClientSettingsPacket;
import net.fxnt.fxntstorage.network.packet.SyncContainerPacket;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.network.packet.SyncNBTDataPacket;
import net.fxnt.fxntstorage.network.packet.SyncSlotCountPacket;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetwork {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"network"), () -> "1", "1"::equals, "1"::equals);
    private static int pkt = 0;

    public static void registerCommonPackets() {
        ModNetwork.registerMessage(JetpackFuelSyncPacket.class, JetpackFuelSyncPacket::encode, JetpackFuelSyncPacket::decode, ClientPayloadHandler::handleJetpackFuelSyncPacket);
        ModNetwork.registerMessage(SetCarriedPacket.class, SetCarriedPacket::encode, SetCarriedPacket::decode, ClientPayloadHandler::handleSetCarriedPacket);
        ModNetwork.registerMessage(SyncContainerPacket.class, SyncContainerPacket::encode, SyncContainerPacket::decode, ClientPayloadHandler::handleSyncContainerPacket);
        ModNetwork.registerMessage(SyncSlotCountPacket.class, SyncSlotCountPacket::encode, SyncSlotCountPacket::decode, ClientPayloadHandler::handleSyncSlotCountPacket);
        ModNetwork.registerMessage(VisualJetpackAirPacket.class, VisualJetpackAirPacket::encode, VisualJetpackAirPacket::decode, ClientPayloadHandler::handleVisualJetpackAirPacket);
        ModNetwork.registerMessage(SyncMountedStoragePacket.class, SyncMountedStoragePacket::encode, SyncMountedStoragePacket::decode, ClientPayloadHandler::handleSyncMountedStoragePacket);
        ModNetwork.registerMessage(SyncNBTDataPacket.class, SyncNBTDataPacket::encode, SyncNBTDataPacket::decode, ClientPayloadHandler::handleSyncNBTDataPacket);
        ModNetwork.registerMessage(CrossbowChargedPacket.class, CrossbowChargedPacket::encode, CrossbowChargedPacket::decode, ServerPayloadHandler::handleCrossbowChargedPacket);
        ModNetwork.registerMessage(JetpackFlyingPacket.class, JetpackFlyingPacket::encode, JetpackFlyingPacket::decode, ServerPayloadHandler::handleJetpackFlyingPacket);
        ModNetwork.registerMessage(KeyPressedPacket.class, KeyPressedPacket::encode, KeyPressedPacket::decode, ServerPayloadHandler::handleKeyPressedPacket);
        ModNetwork.registerMessage(PickBlockUpgradePacket.class, PickBlockUpgradePacket::encode, PickBlockUpgradePacket::decode, ServerPayloadHandler::handlePickBlockUpgradePacket);
        ModNetwork.registerMessage(PlayerInputPacket.class, PlayerInputPacket::encode, PlayerInputPacket::decode, ServerPayloadHandler::handlePlayerInputPacket);
        ModNetwork.registerMessage(SetMountedStorageDirtyPacket.class, SetMountedStorageDirtyPacket::encode, SetMountedStorageDirtyPacket::decode, ServerPayloadHandler::handleSetMountedStorageDirtyPacket);
        ModNetwork.registerMessage(SetSortOrderPacket.class, SetSortOrderPacket::encode, SetSortOrderPacket::decode, ServerPayloadHandler::handleSetSortOrderPacket);
        ModNetwork.registerMessage(SortInventoryPacket.class, SortInventoryPacket::encode, SortInventoryPacket::decode, ServerPayloadHandler::handleSortInventoryPacket);
        ModNetwork.registerMessage(SyncClientSettingsPacket.class, SyncClientSettingsPacket::encode, SyncClientSettingsPacket::decode, ServerPayloadHandler::handleSyncClientSettingsPacket);
        ModNetwork.registerMessage(TransferRecipePacket.class, TransferRecipePacket::encode, TransferRecipePacket::decode, ServerPayloadHandler::handleTransferRecipePacket);
    }

    public static <T> void sendToServer(T message) {
        INSTANCE.sendToServer(message);
    }

    public static <T> void sendToPlayer(ServerPlayer player, T message) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToAllTracking(Entity entity, T message) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <M> void registerMessage(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(pkt++, messageType, encoder, decoder, messageConsumer);
    }
}

