/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.network.packet;

import net.fxnt.fxntstorage.backpack.util.BackpackNetworkHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record SyncContainerPacket(int containerId, int stateId, NonNullList<ItemStack> items, ItemStack carriedItem) {
    public static void encode(@NotNull SyncContainerPacket packet, @NotNull FriendlyByteBuf buffer) {
        buffer.m_130130_(packet.containerId);
        buffer.m_130130_(packet.stateId);
        buffer.m_130130_(packet.items.size());
        for (ItemStack stack : packet.items) {
            BackpackNetworkHelper.writeItemStack(stack, buffer);
        }
        buffer.m_130055_(packet.carriedItem);
    }

    @NotNull
    public static SyncContainerPacket decode(@NotNull FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        int stateId = buffer.m_130242_();
        int size = buffer.m_130242_();
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            stacks.set(i, (Object)BackpackNetworkHelper.readItemStack(buffer));
        }
        ItemStack carriedItem = buffer.m_130267_();
        return new SyncContainerPacket(containerId, stateId, (NonNullList<ItemStack>)stacks, carriedItem);
    }
}

