/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.passer;

import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.function.Predicate;
import net.fxnt.fxntstorage.passer.PasserBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class PasserEntity
extends SmartBlockEntity {
    private static final int UPDATE_EVERY_X_TICKS = 10;
    private int tickCount = 0;
    private Direction facing;
    VersionedInventoryTrackerBehaviour invVersionTracker;

    public PasserEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.facing = (Direction)pBlockState.m_61143_((Property)PasserBlock.FACING);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    protected boolean canAcceptItem(ItemStack stack) {
        return !stack.m_41619_();
    }

    protected boolean canActivate() {
        return true;
    }

    protected int getExtractionAmount() {
        return 1;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return ItemHelper.ExtractionCountMode.UPTO;
    }

    private boolean canTick() {
        if (this.tickCount++ < 10) {
            return false;
        }
        this.tickCount = 0;
        return true;
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.canTick()) {
            return;
        }
        this.facing = (Direction)this.m_58900_().m_61143_((Property)PasserBlock.FACING);
        IItemHandler srcContainer = this.getStorage(this.f_58857_, this.facing, true);
        if (srcContainer == null) {
            return;
        }
        IItemHandler dstContainer = this.getStorage(this.f_58857_, this.facing, false);
        if (dstContainer == null) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        canAcceptItem canAccept = new canAcceptItem(dstContainer);
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        ItemStack extracted = ItemHelper.extract((IItemHandler)srcContainer, (Predicate)canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true);
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)dstContainer, (ItemStack)extracted, (boolean)true);
        int actualInsertAmount = extracted.m_41613_() - remainder.m_41613_();
        if (actualInsertAmount > 0) {
            if (mode.equals((Object)ItemHelper.ExtractionCountMode.UPTO)) {
                count = actualInsertAmount;
            }
            if ((extracted = ItemHelper.extract((IItemHandler)srcContainer, (Predicate)canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false)).m_41613_() == actualInsertAmount) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)dstContainer, (ItemStack)extracted, (boolean)false);
            }
        }
    }

    @Nullable
    public IItemHandler getStorage(Level level, Direction facing, boolean isSourceContainer) {
        BlockPos containerPos = isSourceContainer ? this.f_58858_.m_121945_(facing.m_122424_()) : this.f_58858_.m_121945_(facing);
        BlockEntity blockEntity = level.m_7702_(containerPos);
        BlockState blockState = level.m_8055_(containerPos);
        if (blockEntity != null) {
            if (blockEntity instanceof PackagerBlockEntity) {
                PackagerBlockEntity pbe = (PackagerBlockEntity)blockEntity;
                if (pbe.animationTicks > 0 || pbe.getAvailableItems().isEmpty()) {
                    return null;
                }
            }
            if (blockEntity instanceof PackagePortBlockEntity) {
                return null;
            }
            LazyOptional itemHandlerOpt = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing);
            if (itemHandlerOpt.isPresent()) {
                return (IItemHandler)itemHandlerOpt.orElse((Object)new EmptyHandler());
            }
        } else if (blockState.m_60713_(Blocks.f_50715_)) {
            ComposterBlock block = (ComposterBlock)blockState.m_60734_();
            WorldlyContainer inv = block.m_5840_(blockState, (LevelAccessor)level, containerPos);
            return new SidedInvWrapper(inv, isSourceContainer ? facing : facing.m_122424_());
        }
        return null;
    }

    private class canAcceptItem
    implements Predicate<ItemStack> {
        private final IItemHandler itemHandler;

        public canAcceptItem(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (!PasserEntity.this.canAcceptItem(itemStack)) {
                return false;
            }
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (!this.itemHandler.isItemValid(i, itemStack)) continue;
                return true;
            }
            return false;
        }
    }
}

