/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.utility.CreateLang;
import io.netty.buffer.Unpooled;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class SimpleStorageBoxEntity
extends BlockEntity
implements MenuProvider,
Nameable,
ThresholdSwitchObservable {
    private int tickCount = 0;
    private Component customName;
    public static final int BASE_CAPACITY = 32;
    public static final int ITEM_STACK_SIZE = 64;
    public int maxItemCapacity = 2048;
    public int storedAmount = 0;
    public boolean voidUpgrade = false;
    public static final int VOID_UPGRADE_SLOT = 1;
    public static final int CAPACITY_UPGRADE_SLOT_START = 2;
    public static final int MAX_CAPACITY_UPGRADES = 9;
    public static final int BASE_SLOT_COUNT = 2;
    public static int SLOT_COUNT = 11;
    public ItemStack filterItem = ItemStack.f_41583_;
    public boolean isPlayerInteraction = false;
    private int previousStoredAmount = -1;
    private boolean needsUpdate = false;
    private final ItemStackHandler itemHandler = this.createItemHandler(SLOT_COUNT);
    private LazyOptional<IItemHandlerModifiable> lazyItemHandler = LazyOptional.empty();

    public SimpleStorageBoxEntity(BlockEntityType<?> type, BlockPos position, BlockState state) {
        super(type, position, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public ItemStackHandler createItemHandler(int slotCount) {
        return new ItemStackHandler(slotCount){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SimpleStorageBoxEntity.this.m_6596_();
            }

            public CompoundTag serializeNBT() {
                ListTag nbtTagList = new ListTag();
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.m_128405_("Slot", i);
                    itemTag.m_128405_("ActualCount", ((ItemStack)this.stacks.get(i)).m_41613_());
                    ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
                    nbtTagList.add((Object)itemTag);
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Items", (Tag)nbtTagList);
                nbt.m_128405_("Size", this.stacks.size());
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
                ListTag tagList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.m_128728_(i);
                    int slot = itemTags.m_128451_("Slot");
                    ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
                    if (itemTags.m_128425_("ActualCount", 3)) {
                        slotStack.m_41764_(itemTags.m_128451_("ActualCount"));
                    }
                    this.stacks.set(slot, (Object)slotStack);
                }
                this.onLoad();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ItemStack amount = super.insertItem(slot, stack, simulate);
                if (SimpleStorageBoxEntity.this.storedAmount >= SimpleStorageBoxEntity.this.maxItemCapacity && SimpleStorageBoxEntity.this.voidUpgrade) {
                    return ItemStack.f_41583_;
                }
                return amount;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (SimpleStorageBoxEntity.this.isPlayerInteraction && slot >= 1 || slot <= 1) {
                    if (amount == 0) {
                        return ItemStack.f_41583_;
                    }
                    this.validateSlotIndex(slot);
                    ItemStack existing = (ItemStack)this.stacks.get(slot);
                    if (existing.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    int toExtract = Math.min(amount, SimpleStorageBoxEntity.this.maxItemCapacity);
                    if (existing.m_41613_() <= toExtract) {
                        if (!simulate) {
                            this.stacks.set(slot, (Object)ItemStack.f_41583_);
                            this.onContentsChanged(slot);
                            return existing;
                        }
                        return existing.m_41777_();
                    }
                    if (!simulate) {
                        this.stacks.set(slot, (Object)existing.m_255036_(existing.m_41613_() - toExtract));
                        this.onContentsChanged(slot);
                    }
                    return existing.m_255036_(toExtract);
                }
                return ItemStack.f_41583_;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (stack.m_204117_(ModTags.Items.STORAGE_BOX_UPGRADE) && !SimpleStorageBoxEntity.this.isPlayerInteraction) {
                    return false;
                }
                if (SimpleStorageBoxEntity.this.filterTest(stack)) {
                    if (slot > 0) {
                        return false;
                    }
                    if (SimpleStorageBoxEntity.this.voidUpgrade) {
                        return true;
                    }
                    return ((ItemStack)this.stacks.get(0)).m_41613_() < SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return false;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                if (slot == 0) {
                    return SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return super.getStackLimit(slot, stack);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return super.getSlotLimit(slot);
            }
        };
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getCapacityUpgrades() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!this.itemHandler.getStackInSlot(i).m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        return upgradeCount;
    }

    public boolean hasVoidUpgrade() {
        this.voidUpgrade = this.itemHandler.getStackInSlot(1).m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
        return this.voidUpgrade;
    }

    public int getStoredAmount() {
        this.storedAmount = this.itemHandler.getStackInSlot(0).m_41613_();
        return this.storedAmount;
    }

    public int getMaxItemCapacity() {
        int capacity = 32 << this.getCapacityUpgrades();
        int stackSize = this.filterItem.m_41619_() ? 64 : this.filterItem.m_41741_();
        this.maxItemCapacity = capacity * stackSize;
        return this.maxItemCapacity;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.m_58900_().m_60734_().m_49954_();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setPlayerInteraction(boolean isPlayer) {
        this.isPlayerInteraction = isPlayer;
    }

    public void onLoad() {
        super.onLoad();
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("MaxItemCapacity", this.getMaxItemCapacity());
        tag.m_128405_("StoredAmount", this.getStoredAmount());
        tag.m_128379_("VoidUpgrade", this.hasVoidUpgrade());
        tag.m_128365_("FilterItem", (Tag)this.filterItem.m_255036_(1).m_41739_(new CompoundTag()));
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag tag) {
        CompoundTag itemsTag;
        int oldSize;
        super.m_142466_(tag);
        this.maxItemCapacity = tag.m_128451_("MaxItemCapacity");
        this.previousStoredAmount = this.storedAmount = tag.m_128451_("StoredAmount");
        this.voidUpgrade = tag.m_128471_("VoidUpgrade");
        CompoundTag filterTag = tag.m_128469_("FilterItem");
        ItemStack itemStack = this.filterItem = filterTag.m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)filterTag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        if ((oldSize = (itemsTag = tag.m_128469_("Items")).m_128451_("Size")) != SLOT_COUNT) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Simple Storage Box at {}", (Object)this.f_58858_);
            if (oldSize == 0) {
                ListTag existingItems = tag.m_128437_("Items", 10);
                oldSize = tag.m_128451_("slotCount");
                CompoundTag newTag = new CompoundTag();
                newTag.m_128405_("Size", oldSize);
                newTag.m_128365_("Items", (Tag)existingItems);
                itemsTag = newTag;
                this.maxItemCapacity = tag.m_128451_("maxItemCapacity");
                this.storedAmount = tag.m_128451_("storedAmount");
                this.voidUpgrade = tag.m_128471_("voidUpgrade");
            }
            this.migrateSlotItems(itemsTag, oldSize);
        } else {
            this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        }
    }

    private void migrateSlotItems(CompoundTag itemsTag, int oldSize) {
        ItemStackHandler oldHandler = this.createItemHandler(oldSize);
        oldHandler.deserializeNBT(itemsTag);
        this.migrateSlotItems(oldHandler);
    }

    private void migrateSlotItems(ItemStackHandler oldHandler) {
        ItemStack slot0 = oldHandler.getStackInSlot(0);
        ItemStack slot1 = oldHandler.getStackInSlot(1);
        if (!slot0.m_41619_() || !slot1.m_41619_()) {
            ItemStack merged = slot0.m_41777_();
            int totalCount = slot0.m_41613_() + slot1.m_41613_();
            merged.m_41764_(Math.min(totalCount, this.maxItemCapacity));
            this.itemHandler.setStackInSlot(0, merged);
        }
        this.itemHandler.setStackInSlot(1, oldHandler.getStackInSlot(3).m_41777_());
        for (int oldSlot = 4; oldSlot <= 12; ++oldSlot) {
            int newSlot = oldSlot - 4 + 2;
            if (newSlot >= this.itemHandler.getSlots()) continue;
            this.itemHandler.setStackInSlot(newSlot, oldHandler.getStackInSlot(oldSlot).m_41777_());
        }
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void forceTick() {
        this.tickCount = 999;
    }

    public void serverTick(Level level) {
        if (level.f_46443_) {
            return;
        }
        int currentStoredAmount = this.getStoredAmount();
        this.getMaxItemCapacity();
        ItemStack slot0 = this.itemHandler.getStackInSlot(0);
        if (!slot0.m_41619_() && !ItemStack.m_150942_((ItemStack)slot0, (ItemStack)this.filterItem)) {
            this.setFilter(slot0);
        }
        if (this.previousStoredAmount != currentStoredAmount) {
            this.needsUpdate = true;
        }
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.STORAGE_BOX_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        if (this.needsUpdate) {
            this.updateBlockState(level);
            this.needsUpdate = false;
        }
    }

    private boolean isContainerModified() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return this.m_8077_();
    }

    private void updateBlockState(Level level) {
        boolean copyNbtChanged;
        BlockState currentState = this.m_58900_();
        EnumProperties.StorageUsed status = EnumProperties.StorageUsed.EMPTY;
        if (this.storedAmount >= this.getMaxItemCapacity()) {
            status = EnumProperties.StorageUsed.FULL;
        } else if (this.storedAmount > 0) {
            status = EnumProperties.StorageUsed.HAS_ITEMS;
        }
        boolean copyNbt = this.isContainerModified();
        boolean amountChanged = this.previousStoredAmount != this.storedAmount;
        boolean storageChanged = currentState.m_61143_(SimpleStorageBox.STORAGE_USED) != status;
        boolean bl = copyNbtChanged = (Boolean)currentState.m_61143_((Property)SimpleStorageBox.COPY_NBT) != copyNbt;
        if (amountChanged || storageChanged || copyNbtChanged) {
            BlockState newState = currentState;
            if (amountChanged) {
                this.previousStoredAmount = this.storedAmount;
            }
            if (storageChanged) {
                newState = (BlockState)newState.m_61124_(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)status));
            }
            if (copyNbtChanged) {
                newState = (BlockState)newState.m_61124_((Property)SimpleStorageBox.COPY_NBT, (Comparable)Boolean.valueOf(copyNbt));
            }
            level.m_7731_(this.f_58858_, newState, 3);
            level.m_7260_(this.f_58858_, currentState, newState, 3);
        }
    }

    public void transferToStorage(Player pPlayer, Boolean transferAll) {
        ItemStack itemInHand = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
        if (itemInHand.m_204117_(ModTags.Items.STORAGE_BOX_UPGRADE)) {
            if (itemInHand.m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
                if (!this.hasVoidUpgrade()) {
                    this.itemHandler.setStackInSlot(1, itemInHand.m_255036_(1));
                    if (!pPlayer.m_7500_()) {
                        itemInHand.m_41774_(1);
                        pPlayer.m_150109_().m_6596_();
                    }
                } else {
                    ItemStack voidStack = this.itemHandler.getStackInSlot(1);
                    int slot = pPlayer.m_150109_().m_36050_(voidStack);
                    if (slot > -1) {
                        pPlayer.m_150109_().m_8020_(slot).m_41769_(1);
                        pPlayer.m_150109_().m_6596_();
                    } else {
                        slot = pPlayer.m_150109_().m_36062_();
                        if (slot > -1) {
                            pPlayer.m_150109_().m_6836_(slot, voidStack);
                            pPlayer.m_150109_().m_6596_();
                        } else {
                            pPlayer.m_36176_(voidStack, false);
                        }
                    }
                    this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                }
            } else if (itemInHand.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
                boolean canAddUpgrade = false;
                for (int i = 2; i < 11; ++i) {
                    if (!this.itemHandler.getStackInSlot(i).m_41619_()) continue;
                    this.itemHandler.setStackInSlot(i, itemInHand.m_255036_(1));
                    canAddUpgrade = true;
                    break;
                }
                if (!pPlayer.m_7500_() && canAddUpgrade) {
                    itemInHand.m_41774_(1);
                    pPlayer.m_150109_().m_6596_();
                } else if (!canAddUpgrade) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"fxntstorage.storage_box_capacity_upgrade_max"), true);
                }
            }
        }
        if (transferAll.booleanValue()) {
            for (int i = 0; i < pPlayer.m_150109_().m_6643_(); ++i) {
                ItemStack playerStack = pPlayer.m_150109_().m_8020_(i);
                if (playerStack.m_41619_() || !ItemStack.m_150942_((ItemStack)this.filterItem, (ItemStack)playerStack)) continue;
                ItemStack remainder = this.insertItems(playerStack);
                if (remainder.m_41613_() <= itemInHand.m_41613_() || remainder.m_41613_() == playerStack.m_41613_()) {
                    pPlayer.m_150109_().m_6836_(i, remainder);
                    continue;
                }
                pPlayer.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        } else {
            if (itemInHand.m_41619_() || !this.filterTest(itemInHand)) {
                return;
            }
            int availableSpace = this.getMaxItemCapacity() - this.getStoredAmount();
            int srcAmount = itemInHand.m_41613_();
            if (availableSpace <= 0 && this.hasVoidUpgrade()) {
                itemInHand.m_41774_(srcAmount);
                return;
            }
            int moveAmount = Math.min(srcAmount, availableSpace);
            if (moveAmount > 0) {
                ItemStack remainder;
                if (this.getFilterItem().m_41619_()) {
                    this.setFilter(itemInHand);
                }
                if ((remainder = this.insertItems(itemInHand)).m_41613_() <= itemInHand.m_41613_() || remainder.m_41613_() == moveAmount) {
                    pPlayer.m_21008_(InteractionHand.MAIN_HAND, remainder);
                } else {
                    pPlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        }
        this.m_6596_();
    }

    public void transferFromStorage(Player pPlayer) {
        ItemStack slot0 = this.itemHandler.getStackInSlot(0);
        if (!slot0.m_41619_()) {
            int maxStack = Math.min(slot0.m_41741_(), slot0.m_41613_());
            int amountToExtract = pPlayer.m_6144_() ? maxStack : 1;
            ItemStack toExtract = slot0.m_255036_(amountToExtract);
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)toExtract);
            slot0.m_41774_(amountToExtract);
            this.m_6596_();
        }
    }

    public ItemStack insertItems(ItemStack srcStack) {
        if (this.filterTest(srcStack)) {
            int availableSpace = this.getMaxItemCapacity() - this.getStoredAmount();
            int srcAmount = srcStack.m_41613_();
            if (availableSpace <= 0 && this.hasVoidUpgrade()) {
                srcStack.m_41774_(srcAmount);
                return srcStack;
            }
            int moveAmount = Math.min(srcAmount, availableSpace);
            if (moveAmount > 0) {
                if (this.getFilterItem().m_41619_()) {
                    this.setFilter(srcStack);
                }
                if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
                    this.itemHandler.getStackInSlot(0).m_41769_(moveAmount);
                } else {
                    this.itemHandler.setStackInSlot(0, srcStack.m_255036_(moveAmount));
                }
                srcStack.m_41774_(moveAmount);
                this.m_6596_();
            }
        }
        return srcStack;
    }

    public void removeFilter() {
        this.filterItem = ItemStack.f_41583_;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SimpleStorageBox.COPY_NBT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void setFilter(ItemStack itemStack) {
        this.filterItem = itemStack.m_255036_(1);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SimpleStorageBox.COPY_NBT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean filterTest(ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.STORAGE_BOX_ITEM) || stack.m_204117_(ModTags.Items.STORAGE_BOX_UPGRADE)) {
            return false;
        }
        return this.filterItem.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.filterItem);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        if (player.m_5833_()) {
            return null;
        }
        return new SimpleStorageBoxMenu(containerId, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    public int getMaxValue() {
        return this.maxItemCapacity;
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        return this.storedAmount;
    }

    public MutableComponent format(int i) {
        return CreateLang.translateDirect((String)"create.gui.threshold_switch.currently", (Object[])new Object[]{i});
    }

    public void applyInventoryToBlock(ItemStackHandler wrapped, ItemStack filterItem) {
        this.setFilter(filterItem);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, wrapped.getStackInSlot(i));
        }
    }
}

